/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.init.block;

import com.mojang.datafixers.DSL;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.confluence.lib.common.block.StateProperties;
import org.confluence.mod.common.block.common.StatueBlock;
import org.confluence.mod.common.block.functional.BehaviourStatueBlock;
import org.confluence.mod.common.block.functional.BoulderBlock;
import org.confluence.mod.common.block.functional.network.INetworkEntity;
import org.confluence.mod.common.entity.projectile.boulder.Boulder3x3Entity;
import org.confluence.mod.common.init.ModEffects;
import org.confluence.mod.common.init.block.FunctionalBlocks;
import org.confluence.mod.common.init.block.ModBlocks;
import org.confluence.mod.common.init.item.ConsumableItems;
import org.confluence.mod.common.init.item.ModItems;
import org.confluence.mod.common.init.item.SwordItems;
import org.confluence.mod.common.item.common.ThrowableItem;
import org.confluence.mod.util.DateUtils;
import org.confluence.terraentity.entity.monster.AbstractMonster;
import org.confluence.terraentity.entity.monster.demoneye.DemonEye;
import org.confluence.terraentity.entity.monster.prefab.AttributeBuilder;
import org.confluence.terraentity.entity.monster.prefab.FlyMonsterPrefab;
import org.confluence.terraentity.entity.monster.slime.BaseSlime;
import org.confluence.terraentity.init.entity.TEMonsterEntities;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class StatueBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"confluence");
    static List<Supplier<BehaviourStatueBlock>> BEHAVIOUR_STATUES = new ArrayList<Supplier<BehaviourStatueBlock>>();
    public static final DeferredBlock<StatueBlock> A_STATUE = StatueBlocks.register("a_statue");
    public static final DeferredBlock<StatueBlock> B_STATUE = StatueBlocks.register("b_statue");
    public static final DeferredBlock<StatueBlock> C_STATUE = StatueBlocks.register("c_statue");
    public static final DeferredBlock<StatueBlock> D_STATUE = StatueBlocks.register("d_statue");
    public static final DeferredBlock<StatueBlock> E_STATUE = StatueBlocks.register("e_statue");
    public static final DeferredBlock<StatueBlock> F_STATUE = StatueBlocks.register("f_statue");
    public static final DeferredBlock<StatueBlock> G_STATUE = StatueBlocks.register("g_statue");
    public static final DeferredBlock<StatueBlock> H_STATUE = StatueBlocks.register("h_statue");
    public static final DeferredBlock<StatueBlock> I_STATUE = StatueBlocks.register("i_statue");
    public static final DeferredBlock<StatueBlock> J_STATUE = StatueBlocks.register("j_statue");
    public static final DeferredBlock<StatueBlock> K_STATUE = StatueBlocks.register("k_statue");
    public static final DeferredBlock<StatueBlock> L_STATUE = StatueBlocks.register("l_statue");
    public static final DeferredBlock<StatueBlock> M_STATUE = StatueBlocks.register("m_statue");
    public static final DeferredBlock<StatueBlock> N_STATUE = StatueBlocks.register("n_statue");
    public static final DeferredBlock<StatueBlock> O_STATUE = StatueBlocks.register("o_statue");
    public static final DeferredBlock<StatueBlock> P_STATUE = StatueBlocks.register("p_statue");
    public static final DeferredBlock<StatueBlock> Q_STATUE = StatueBlocks.register("q_statue");
    public static final DeferredBlock<StatueBlock> R_STATUE = StatueBlocks.register("r_statue");
    public static final DeferredBlock<StatueBlock> S_STATUE = StatueBlocks.register("s_statue");
    public static final DeferredBlock<StatueBlock> T_STATUE = StatueBlocks.register("t_statue");
    public static final DeferredBlock<StatueBlock> U_STATUE = StatueBlocks.register("u_statue");
    public static final DeferredBlock<StatueBlock> V_STATUE = StatueBlocks.register("v_statue");
    public static final DeferredBlock<StatueBlock> W_STATUE = StatueBlocks.register("w_statue");
    public static final DeferredBlock<StatueBlock> X_STATUE = StatueBlocks.register("x_statue");
    public static final DeferredBlock<StatueBlock> Y_STATUE = StatueBlocks.register("y_statue");
    public static final DeferredBlock<StatueBlock> Z_STATUE = StatueBlocks.register("z_statue");
    public static final DeferredBlock<StatueBlock> N0_STATUE = StatueBlocks.register("n0_statue");
    public static final DeferredBlock<StatueBlock> N1_STATUE = StatueBlocks.register("n1_statue");
    public static final DeferredBlock<StatueBlock> N2_STATUE = StatueBlocks.register("n2_statue");
    public static final DeferredBlock<StatueBlock> N3_STATUE = StatueBlocks.register("n3_statue");
    public static final DeferredBlock<StatueBlock> N4_STATUE = StatueBlocks.register("n4_statue");
    public static final DeferredBlock<StatueBlock> N5_STATUE = StatueBlocks.register("n5_statue");
    public static final DeferredBlock<StatueBlock> N6_STATUE = StatueBlocks.register("n6_statue");
    public static final DeferredBlock<StatueBlock> N7_STATUE = StatueBlocks.register("n7_statue");
    public static final DeferredBlock<StatueBlock> N8_STATUE = StatueBlocks.register("n8_statue");
    public static final DeferredBlock<StatueBlock> N9_STATUE = StatueBlocks.register("n9_statue");
    public static final DeferredBlock<StatueBlock> PERIOD_STATUE = StatueBlocks.register("period_statue");
    public static final DeferredBlock<StatueBlock> EXCLAMATION_MARK_STATUE = StatueBlocks.register("exclamation_mark_statue");
    public static final DeferredBlock<StatueBlock> QUESTION_MARK_STATUE = StatueBlocks.register("question_mark_statue");
    public static final DeferredBlock<StatueBlock> ANVIL_STATUE = StatueBlocks.register("anvil_statue");
    public static final DeferredBlock<StatueBlock> ARMOR_STATUE = StatueBlocks.register("armor_statue");
    public static final DeferredBlock<StatueBlock> AXE_STATUE = StatueBlocks.register("axe_statue");
    public static final DeferredBlock<StatueBlock> BOOMERANG_STATUE = StatueBlocks.register("boomerang_statue");
    public static final DeferredBlock<StatueBlock> BOOT_STATUE = StatueBlocks.register("boot_statue");
    public static final DeferredBlock<StatueBlock> BOW_STATUE = StatueBlocks.register("bow_statue");
    public static final DeferredBlock<StatueBlock> CROSS_STATUE = StatueBlocks.register("cross_statue");
    public static final DeferredBlock<StatueBlock> GARGOYLE_STATUE = StatueBlocks.register("gargoyle_statue");
    public static final DeferredBlock<StatueBlock> GLOOM_STATUE = StatueBlocks.register("gloom_statue");
    public static final DeferredBlock<StatueBlock> HAMMER_STATUE = StatueBlocks.register("hammer_statue");
    public static final DeferredBlock<StatueBlock> PICKAXE_STATUE = StatueBlocks.register("pickaxe_statue");
    public static final DeferredBlock<StatueBlock> PILLAR_STATUE = StatueBlocks.register("pillar_statue");
    public static final DeferredBlock<StatueBlock> POT_STATUE = StatueBlocks.register("pot_statue");
    public static final DeferredBlock<StatueBlock> POTION_STATUE = StatueBlocks.register("potion_statue");
    public static final DeferredBlock<StatueBlock> REAPER_STATUE = StatueBlocks.register("reaper_statue");
    public static final DeferredBlock<StatueBlock> SHIELD_STATUE = StatueBlocks.register("shield_statue");
    public static final DeferredBlock<StatueBlock> SPEAR_STATUE = StatueBlocks.register("spear_statue");
    public static final DeferredBlock<StatueBlock> SUNFLOWER_STATUE = StatueBlocks.register("sunflower_statue");
    public static final DeferredBlock<StatueBlock> SWORD_STATUE = StatueBlocks.register("sword_statue");
    public static final DeferredBlock<StatueBlock> TREE_STATUE = StatueBlocks.register("tree_statue");
    public static final DeferredBlock<StatueBlock> WOMEN_STATUE = StatueBlocks.register("women_statue");
    public static final DeferredBlock<StatueBlock> LIHZAHRD_STATUE = StatueBlocks.register("lihzahrd_statue");
    public static final DeferredBlock<StatueBlock> LIHZAHRD_GUARDIAN_STATUE = StatueBlocks.register("lihzahrd_guardian_statue");
    public static final DeferredBlock<StatueBlock> LIHZAHRD_WATCHER_STATUE = StatueBlocks.register("lihzahrd_watcher_statue");
    public static final DeferredBlock<BehaviourStatueBlock> ARMED_ZOMBIE_STATUE = StatueBlocks.registerBehaviour("armed_zombie_statue", new BehaviourStatueBlock.SummonBehaviour(true, false, (state, level, pos) -> {
        Zombie zombie = new Zombie(level);
        zombie.setPos(pos);
        zombie.setItemInHand(InteractionHand.MAIN_HAND, SwordItems.ZOMBIE_ARM.toStack());
        return zombie;
    }));
    public static final DeferredBlock<BehaviourStatueBlock> BONE_SKELETON_STATUE = StatueBlocks.registerSimpleSummon("bone_skeleton_statue", true, level -> new Skeleton(EntityType.SKELETON, level));
    public static final DeferredBlock<BehaviourStatueBlock> CORRUPT_STATUE = StatueBlocks.registerSimpleSummon("corrupt_statue", true, level -> new AbstractMonster((EntityType)TEMonsterEntities.EATER_OF_SOULS.get(), level, (AttributeBuilder)FlyMonsterPrefab.EATER_OF_SOULS_BUILDER.get()));
    public static final DeferredBlock<BehaviourStatueBlock> DRIPPLER_STATUE = StatueBlocks.registerSimpleSummon("drippler_statue", true, level -> new AbstractMonster((EntityType)TEMonsterEntities.DRIPPLER.get(), level, (AttributeBuilder)FlyMonsterPrefab.DRIPPLER_BUILDER.get()));
    public static final DeferredBlock<BehaviourStatueBlock> EYEBALL_STATUE = StatueBlocks.registerSimpleSummon("eyeball_statue", true, level -> new DemonEye((EntityType)TEMonsterEntities.DEMON_EYE.get(), level));
    public static final DeferredBlock<BehaviourStatueBlock> SKELETON_STATUE = StatueBlocks.registerBehaviour("skeleton_statue", new BehaviourStatueBlock.SummonBehaviour<Skeleton>(true, true, (state, level, pos) -> {
        Skeleton skeleton = new Skeleton(EntityType.SKELETON, level);
        skeleton.setPos(pos);
        return skeleton;
    }, entity -> entity.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY)));
    public static final DeferredBlock<BehaviourStatueBlock> SLIME_STATUE = StatueBlocks.registerSimpleSummon("slime_statue", false, level -> new BaseSlime((EntityType)TEMonsterEntities.BLUE_SLIME.get(), level, 7585012, 2));
    public static final DeferredBlock<BehaviourStatueBlock> BOMB_STATUE = StatueBlocks.registerBehaviour("bomb_statue", new BehaviourStatueBlock.SummonBehaviour(true, false, 200, (state, level, pos) -> {
        ItemEntity itemEntity = new ItemEntity(level, pos.x, pos.y, pos.z, ((ThrowableItem)((Object)((Object)ConsumableItems.BOMB.get()))).getDefaultInstance());
        itemEntity.setPickUpDelay(0);
        return itemEntity;
    }));
    public static final DeferredBlock<BehaviourStatueBlock> HEART_STATUE = StatueBlocks.registerBehaviour("heart_statue", new BehaviourStatueBlock.SummonBehaviour(true, false, 200, (state, level, pos) -> {
        ItemEntity itemEntity = new ItemEntity(level, pos.x, pos.y, pos.z, DateUtils.getHeartItem().getDefaultInstance());
        itemEntity.setPickUpDelay(0);
        return itemEntity;
    }));
    public static final DeferredBlock<BehaviourStatueBlock> STAR_STATUE = StatueBlocks.registerBehaviour("star_statue", new BehaviourStatueBlock.SummonBehaviour(true, false, 200, (state, level, pos) -> {
        ItemEntity itemEntity = new ItemEntity(level, pos.x, pos.y, pos.z, DateUtils.getStarItem().getDefaultInstance());
        itemEntity.setPickUpDelay(0);
        return itemEntity;
    }));
    public static final DeferredBlock<BehaviourStatueBlock> BOULDER_3X_STATUE = StatueBlocks.registerBehaviour("boulder_3x_statue", new BehaviourStatueBlock.SummonBehaviour(false, true, 200, (state, level, pos) -> {
        Direction facing = (Direction)state.getValue((Property)StatueBlock.FACING);
        Boulder3x3Entity entity = new Boulder3x3Entity((Level)level, pos.relative(facing, 1.0).add(0.0, -0.4999900000002526, 0.0), ((BoulderBlock)FunctionalBlocks.NORMAL_BOULDER.get()).defaultBlockState());
        entity.shoot(facing, 0.4);
        return entity;
    }));
    public static final DeferredBlock<BehaviourStatueBlock> BAST_STATUE = StatueBlocks.registerBehaviour("bast_statue", new BehaviourStatueBlock.Behaviour(){

        @Override
        public void entityTick(Level level, BlockPos pos, BlockState blockState, BehaviourStatueBlock.BEntity entity) {
            if (!level.isClientSide && level.getGameTime() % 400L == 0L && ((Boolean)blockState.getValue((Property)StateProperties.DRIVE)).booleanValue()) {
                Vec3 center = pos.getCenter();
                for (Player player : level.players()) {
                    if (!(player.distanceToSqr(center) < 1024.0) || player.hasEffect(ModEffects.THE_BAST_DEFENSE)) continue;
                    player.addEffect(new MobEffectInstance(ModEffects.THE_BAST_DEFENSE, 420));
                }
            }
        }

        @Override
        public void onExecute(BlockState state, ServerLevel level, BlockPos pos, int color, INetworkEntity networkEntity) {
            if (((StateProperties.VerticalTwoPart)state.getValue((Property)StateProperties.VERTICAL_TWO_PART)).isBase()) {
                level.setBlockAndUpdate(pos, (BlockState)state.cycle((Property)StateProperties.DRIVE));
            }
        }

        @Override
        public BlockState getStateForPlacement(BlockPlaceContext context, BlockState state) {
            return (BlockState)state.setValue((Property)StateProperties.DRIVE, (Comparable)Boolean.valueOf(true));
        }
    });
    public static final Supplier<BlockEntityType<BehaviourStatueBlock.BEntity>> BLOCK_ENTITY = ModBlocks.BLOCK_ENTITIES.register("behaviour_statue_entity", () -> {
        BehaviourStatueBlock[] validBlocks = (BehaviourStatueBlock[])BEHAVIOUR_STATUES.stream().map(Supplier::get).toArray(BehaviourStatueBlock[]::new);
        BEHAVIOUR_STATUES = null;
        return BlockEntityType.Builder.of(BehaviourStatueBlock.BEntity::new, (Block[])validBlocks).build(DSL.remainderType());
    });

    private static DeferredBlock<StatueBlock> register(String id) {
        DeferredBlock block = BLOCKS.register(id, () -> new StatueBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS)));
        ModItems.BLOCK_ITEMS.register(id, () -> new BlockItem((Block)block.get(), new Item.Properties()));
        return block;
    }

    private static DeferredBlock<BehaviourStatueBlock> registerBehaviour(String id, BehaviourStatueBlock.Behaviour behaviour) {
        DeferredBlock block = BLOCKS.register(id, () -> new BehaviourStatueBlock(behaviour, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS)));
        ModItems.BLOCK_ITEMS.registerSimpleBlockItem((Holder)block, new Item.Properties());
        BEHAVIOUR_STATUES.add((Supplier<BehaviourStatueBlock>)block);
        return block;
    }

    private static DeferredBlock<BehaviourStatueBlock> registerSimpleSummon(String id, boolean noDrops, Function<Level, Entity> factory) {
        DeferredBlock block = BLOCKS.register(id, () -> new BehaviourStatueBlock(new BehaviourStatueBlock.SummonBehaviour(true, noDrops, (state, level, pos) -> {
            Entity entity = (Entity)factory.apply((Level)level);
            entity.setPos(pos);
            return entity;
        }), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS)));
        ModItems.BLOCK_ITEMS.registerSimpleBlockItem((Holder)block, new Item.Properties());
        BEHAVIOUR_STATUES.add((Supplier<BehaviourStatueBlock>)block);
        return block;
    }

    public static void acceptTag(IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block> tag) {
        BLOCKS.getEntries().forEach(block -> tag.add((Object)((Block)block.get())));
    }
}

