/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.init.item;

import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.confluence.lib.ConfluenceMagicLib;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.mod.common.init.ModArmorMaterials;
import org.confluence.mod.common.init.item.ModItems;
import org.confluence.mod.common.item.armor.MultiHeadArmorItem;
import org.confluence.mod.common.item.armor.NormalArmorItem;

public class ArmorItems {
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"confluence");
    public static final DeferredItem<ArmorItem> MINING_HELMET = ITEMS.register("mining_helmet", () -> new NormalArmorItem("armor/mining_armor", (Holder)ModArmorMaterials.MINING_ARMOR_MATERIALS, ArmorItem.Type.HELMET, new Item.Properties().stacksTo(1).component(DataComponents.UNBREAKABLE, (Object)ModItems.UNBREAKABLE).component(ConfluenceMagicLib.MOD_RARITY, (Object)ModRarity.PINK)){
        private final boolean noneLoaded = !ModList.get().isLoaded("sodiumdynamiclights");

        @ParametersAreNonnullByDefault
        public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
            if (this.noneLoaded) {
                tooltipComponents.add((Component)Component.translatable((String)"tooltip.terra_curio.requires_mod_loaded", (Object[])new Object[]{"sodiumdynamiclights"}));
            }
        }
    });
    public static final DeferredItem<NormalArmorItem> MINING_CHESTPLATE = ArmorItems.registerNormalArmor("mining_chestplate", "mining_armor", ModRarity.PINK, ModArmorMaterials.MINING_ARMOR_MATERIALS, ArmorItem.Type.CHESTPLATE);
    public static final DeferredItem<NormalArmorItem> MINING_LEGGINGS = ArmorItems.registerNormalArmor("mining_leggings", "mining_armor", ModRarity.PINK, ModArmorMaterials.MINING_ARMOR_MATERIALS, ArmorItem.Type.LEGGINGS);
    public static final DeferredItem<NormalArmorItem> MINING_BOOTS = ArmorItems.registerNormalArmor("mining_boots", "mining_armor", ModRarity.PINK, ModArmorMaterials.MINING_ARMOR_MATERIALS, ArmorItem.Type.BOOTS);
    public static final DeferredItem<NormalArmorItem> PLANK_HELMET = ArmorItems.registerNormalArmor("plank_helmet", "plank_armor", ModArmorMaterials.PLANK_ARMOR_MATERIALS, ArmorItem.Type.HELMET, 55);
    public static final DeferredItem<NormalArmorItem> PLANK_CHESTPLATE = ArmorItems.registerNormalArmor("plank_chestplate", "plank_armor", ModArmorMaterials.PLANK_ARMOR_MATERIALS, ArmorItem.Type.CHESTPLATE, 80);
    public static final DeferredItem<NormalArmorItem> PLANK_LEGGINGS = ArmorItems.registerNormalArmor("plank_leggings", "plank_armor", ModArmorMaterials.PLANK_ARMOR_MATERIALS, ArmorItem.Type.LEGGINGS, 75);
    public static final DeferredItem<NormalArmorItem> PLANK_BOOTS = ArmorItems.registerNormalArmor("plank_boots", "plank_armor", ModArmorMaterials.PLANK_ARMOR_MATERIALS, ArmorItem.Type.BOOTS, 65);
    public static final DeferredItem<NormalArmorItem> EBONY_HELMET = ArmorItems.registerNormalArmor("ebony_helmet", "ebony_armor", ModArmorMaterials.EBONY_ARMOR_MATERIALS, ArmorItem.Type.HELMET, 120);
    public static final DeferredItem<NormalArmorItem> EBONY_CHESTPLATE = ArmorItems.registerNormalArmor("ebony_chestplate", "ebony_armor", ModArmorMaterials.EBONY_ARMOR_MATERIALS, ArmorItem.Type.CHESTPLATE, 170);
    public static final DeferredItem<NormalArmorItem> EBONY_LEGGINGS = ArmorItems.registerNormalArmor("ebony_leggings", "ebony_armor", ModArmorMaterials.EBONY_ARMOR_MATERIALS, ArmorItem.Type.LEGGINGS, 150);
    public static final DeferredItem<NormalArmorItem> EBONY_BOOTS = ArmorItems.registerNormalArmor("ebony_boots", "ebony_armor", ModArmorMaterials.EBONY_ARMOR_MATERIALS, ArmorItem.Type.BOOTS, 130);
    public static final DeferredItem<NormalArmorItem> SHADOW_PLANK_HELMET = ArmorItems.registerNormalArmor("shadow_plank_helmet", "shadow_plank_armor", ModArmorMaterials.SHADOW_PLANK_ARMOR_MATERIALS, ArmorItem.Type.HELMET, 120);
    public static final DeferredItem<NormalArmorItem> SHADOW_PLANK_CHESTPLATE = ArmorItems.registerNormalArmor("shadow_plank_chestplate", "shadow_plank_armor", ModArmorMaterials.SHADOW_PLANK_ARMOR_MATERIALS, ArmorItem.Type.CHESTPLATE, 170);
    public static final DeferredItem<NormalArmorItem> SHADOW_PLANK_LEGGINGS = ArmorItems.registerNormalArmor("shadow_plank_leggings", "shadow_plank_armor", ModArmorMaterials.SHADOW_PLANK_ARMOR_MATERIALS, ArmorItem.Type.LEGGINGS, 150);
    public static final DeferredItem<NormalArmorItem> SHADOW_PLANK_BOOTS = ArmorItems.registerNormalArmor("shadow_plank_boots", "shadow_plank_armor", ModArmorMaterials.SHADOW_PLANK_ARMOR_MATERIALS, ArmorItem.Type.BOOTS, 130);
    public static final DeferredItem<NormalArmorItem> ASH_HELMET = ArmorItems.registerNormalArmor("ash_helmet", "ash_armor", ModArmorMaterials.ASH_ARMOR_MATERIALS, ArmorItem.Type.HELMET, 220);
    public static final DeferredItem<NormalArmorItem> ASH_CHESTPLATE = ArmorItems.registerNormalArmor("ash_chestplate", "ash_armor", ModArmorMaterials.ASH_ARMOR_MATERIALS, ArmorItem.Type.CHESTPLATE, 270);
    public static final DeferredItem<NormalArmorItem> ASH_LEGGINGS = ArmorItems.registerNormalArmor("ash_leggings", "ash_armor", ModArmorMaterials.ASH_ARMOR_MATERIALS, ArmorItem.Type.LEGGINGS, 250);
    public static final DeferredItem<NormalArmorItem> ASH_BOOTS = ArmorItems.registerNormalArmor("ash_boots", "ash_armor", ModArmorMaterials.ASH_ARMOR_MATERIALS, ArmorItem.Type.BOOTS, 230);
    public static final DeferredItem<NormalArmorItem> RAIN_CAP = ArmorItems.registerNormalArmor("rain_cap", "raincoat_armor", ModArmorMaterials.RAINCOAT_ARMOR_MATERIALS, ArmorItem.Type.HELMET);
    public static final DeferredItem<NormalArmorItem> RAINCOAT = ArmorItems.registerNormalArmor("raincoat", "raincoat_armor", ModArmorMaterials.RAINCOAT_ARMOR_MATERIALS, ArmorItem.Type.CHESTPLATE);
    public static final DeferredItem<NormalArmorItem> SNOW_CAPS = ArmorItems.registerNormalArmor("snow_caps", "snow_armor", ModArmorMaterials.SNOW_ARMOR_MATERIALS, ArmorItem.Type.HELMET);
    public static final DeferredItem<NormalArmorItem> SNOW_SUITS = ArmorItems.registerNormalArmor("snow_suits", "snow_armor", ModArmorMaterials.SNOW_ARMOR_MATERIALS, ArmorItem.Type.CHESTPLATE);
    public static final DeferredItem<NormalArmorItem> INSULATED_PANTS = ArmorItems.registerNormalArmor("insulated_pants", "snow_armor", ModArmorMaterials.SNOW_ARMOR_MATERIALS, ArmorItem.Type.LEGGINGS);
    public static final DeferredItem<NormalArmorItem> INSULATED_SHOES = ArmorItems.registerNormalArmor("insulated_shoes", "snow_armor", ModArmorMaterials.SNOW_ARMOR_MATERIALS, ArmorItem.Type.BOOTS);
    public static final DeferredItem<NormalArmorItem> PINK_SNOW_CAPS = ArmorItems.registerNormalArmor("pink_snow_caps", "snow_pink_armor", ModArmorMaterials.PINK_SNOW_ARMOR_MATERIALS, ArmorItem.Type.HELMET);
    public static final DeferredItem<NormalArmorItem> PINK_SNOW_SUITS = ArmorItems.registerNormalArmor("pink_snow_suits", "snow_pink_armor", ModArmorMaterials.PINK_SNOW_ARMOR_MATERIALS, ArmorItem.Type.CHESTPLATE);
    public static final DeferredItem<NormalArmorItem> PINK_INSULATED_PANTS = ArmorItems.registerNormalArmor("pink_insulated_pants", "snow_pink_armor", ModArmorMaterials.PINK_SNOW_ARMOR_MATERIALS, ArmorItem.Type.LEGGINGS);
    public static final DeferredItem<NormalArmorItem> PINK_INSULATED_SHOES = ArmorItems.registerNormalArmor("pink_insulated_shoes", "snow_pink_armor", ModArmorMaterials.PINK_SNOW_ARMOR_MATERIALS, ArmorItem.Type.BOOTS);
    public static final DeferredItem<NormalArmorItem> ANGLER_HAT = ArmorItems.registerNormalArmor("angler_hat", "angler_armor", ModRarity.BLUE, ModArmorMaterials.ANGLER_ARMOR_MATERIALS, ArmorItem.Type.HELMET);
    public static final DeferredItem<NormalArmorItem> ANGLER_VEST = ArmorItems.registerNormalArmor("angler_vest", "angler_armor", ModRarity.BLUE, ModArmorMaterials.ANGLER_ARMOR_MATERIALS, ArmorItem.Type.CHESTPLATE);
    public static final DeferredItem<NormalArmorItem> ANGLER_PANTS = ArmorItems.registerNormalArmor("angler_pants", "angler_armor", ModRarity.BLUE, ModArmorMaterials.ANGLER_ARMOR_MATERIALS, ArmorItem.Type.LEGGINGS);
    public static final DeferredItem<NormalArmorItem> CACTUS_HELMET = ArmorItems.registerNormalArmor("cactus_helmet", "cactus_armor", ModArmorMaterials.CACTUS_ARMOR_MATERIALS, ArmorItem.Type.HELMET, 120);
    public static final DeferredItem<NormalArmorItem> CACTUS_CHESTPLATE = ArmorItems.registerNormalArmor("cactus_chestplate", "cactus_armor", ModArmorMaterials.CACTUS_ARMOR_MATERIALS, ArmorItem.Type.CHESTPLATE, 170);
    public static final DeferredItem<NormalArmorItem> CACTUS_LEGGINGS = ArmorItems.registerNormalArmor("cactus_leggings", "cactus_armor", ModArmorMaterials.CACTUS_ARMOR_MATERIALS, ArmorItem.Type.LEGGINGS, 150);
    public static final DeferredItem<NormalArmorItem> CACTUS_BOOTS = ArmorItems.registerNormalArmor("cactus_boots", "cactus_armor", ModArmorMaterials.CACTUS_ARMOR_MATERIALS, ArmorItem.Type.BOOTS, 130);
    public static final DeferredItem<NormalArmorItem> COPPER_HELMET = ArmorItems.registerNormalArmor("copper_helmet", "copper_armor", ModArmorMaterials.COPPER_ARMOR_MATERIALS, ArmorItem.Type.HELMET, 120);
    public static final DeferredItem<NormalArmorItem> COPPER_CHESTPLATE = ArmorItems.registerNormalArmor("copper_chestplate", "copper_armor", ModArmorMaterials.COPPER_ARMOR_MATERIALS, ArmorItem.Type.CHESTPLATE, 170);
    public static final DeferredItem<NormalArmorItem> COPPER_LEGGINGS = ArmorItems.registerNormalArmor("copper_leggings", "copper_armor", ModArmorMaterials.COPPER_ARMOR_MATERIALS, ArmorItem.Type.LEGGINGS, 150);
    public static final DeferredItem<NormalArmorItem> COPPER_BOOTS = ArmorItems.registerNormalArmor("copper_boots", "copper_armor", ModArmorMaterials.COPPER_ARMOR_MATERIALS, ArmorItem.Type.BOOTS, 130);
    public static final DeferredItem<NormalArmorItem> TIN_HELMET = ArmorItems.registerNormalArmor("tin_helmet", "tin_armor", ModArmorMaterials.TIN_ARMOR_MATERIALS, ArmorItem.Type.HELMET, 150);
    public static final DeferredItem<NormalArmorItem> TIN_CHESTPLATE = ArmorItems.registerNormalArmor("tin_chestplate", "tin_armor", ModArmorMaterials.TIN_ARMOR_MATERIALS, ArmorItem.Type.CHESTPLATE, 190);
    public static final DeferredItem<NormalArmorItem> TIN_LEGGINGS = ArmorItems.registerNormalArmor("tin_leggings", "tin_armor", ModArmorMaterials.TIN_ARMOR_MATERIALS, ArmorItem.Type.LEGGINGS, 170);
    public static final DeferredItem<NormalArmorItem> TIN_BOOTS = ArmorItems.registerNormalArmor("tin_boots", "tin_armor", ModArmorMaterials.TIN_ARMOR_MATERIALS, ArmorItem.Type.BOOTS, 150);
    public static final DeferredItem<NormalArmorItem> PUMPKIN_HELMET = ArmorItems.registerNormalArmor("pumpkin_helmet", "pumpkin_armor", ModArmorMaterials.PUMPKIN_ARMOR_MATERIALS, ArmorItem.Type.HELMET);
    public static final DeferredItem<NormalArmorItem> PUMPKIN_CHESTPLATE = ArmorItems.registerNormalArmor("pumpkin_chestplate", "pumpkin_armor", ModArmorMaterials.PUMPKIN_ARMOR_MATERIALS, ArmorItem.Type.CHESTPLATE);
    public static final DeferredItem<NormalArmorItem> PUMPKIN_LEGGINGS = ArmorItems.registerNormalArmor("pumpkin_leggings", "pumpkin_armor", ModArmorMaterials.PUMPKIN_ARMOR_MATERIALS, ArmorItem.Type.LEGGINGS);
    public static final DeferredItem<NormalArmorItem> PUMPKIN_BOOTS = ArmorItems.registerNormalArmor("pumpkin_boots", "pumpkin_armor", ModArmorMaterials.PUMPKIN_ARMOR_MATERIALS, ArmorItem.Type.BOOTS);
    public static final DeferredItem<NormalArmorItem> NINJA_HELMET = ArmorItems.registerNormalArmor("ninja_helmet", "ninja_armor", ModRarity.BLUE, ModArmorMaterials.NINJA_ARMOR_MATERIALS, ArmorItem.Type.HELMET);
    public static final DeferredItem<NormalArmorItem> NINJA_CHESTPLATE = ArmorItems.registerNormalArmor("ninja_chestplate", "ninja_armor", ModRarity.BLUE, ModArmorMaterials.NINJA_ARMOR_MATERIALS, ArmorItem.Type.CHESTPLATE);
    public static final DeferredItem<NormalArmorItem> NINJA_LEGGINGS = ArmorItems.registerNormalArmor("ninja_leggings", "ninja_armor", ModRarity.BLUE, ModArmorMaterials.NINJA_ARMOR_MATERIALS, ArmorItem.Type.LEGGINGS);
    public static final DeferredItem<NormalArmorItem> NINJA_BOOTS = ArmorItems.registerNormalArmor("ninja_boots", "ninja_armor", ModRarity.BLUE, ModArmorMaterials.NINJA_ARMOR_MATERIALS, ArmorItem.Type.BOOTS);
    public static final DeferredItem<NormalArmorItem> LEAD_HELMET = ArmorItems.registerNormalArmor("lead_helmet", "lead_armor", ModArmorMaterials.LEAD_ARMOR_MATERIALS, ArmorItem.Type.HELMET, 170);
    public static final DeferredItem<NormalArmorItem> LEAD_CHESTPLATE = ArmorItems.registerNormalArmor("lead_chestplate", "lead_armor", ModArmorMaterials.LEAD_ARMOR_MATERIALS, ArmorItem.Type.CHESTPLATE, 250);
    public static final DeferredItem<NormalArmorItem> LEAD_LEGGINGS = ArmorItems.registerNormalArmor("lead_leggings", "lead_armor", ModArmorMaterials.LEAD_ARMOR_MATERIALS, ArmorItem.Type.LEGGINGS, 230);
    public static final DeferredItem<NormalArmorItem> LEAD_BOOTS = ArmorItems.registerNormalArmor("lead_boots", "lead_armor", ModArmorMaterials.LEAD_ARMOR_MATERIALS, ArmorItem.Type.BOOTS, 160);
    public static final DeferredItem<NormalArmorItem> SILVER_HELMET = ArmorItems.registerNormalArmor("silver_helmet", "silver_armor", ModArmorMaterials.SILVER_ARMOR_MATERIALS, ArmorItem.Type.HELMET, 190);
    public static final DeferredItem<NormalArmorItem> SILVER_CHESTPLATE = ArmorItems.registerNormalArmor("silver_chestplate", "silver_armor", ModArmorMaterials.SILVER_ARMOR_MATERIALS, ArmorItem.Type.CHESTPLATE, 270);
    public static final DeferredItem<NormalArmorItem> SILVER_LEGGINGS = ArmorItems.registerNormalArmor("silver_leggings", "silver_armor", ModArmorMaterials.SILVER_ARMOR_MATERIALS, ArmorItem.Type.LEGGINGS, 250);
    public static final DeferredItem<NormalArmorItem> SILVER_BOOTS = ArmorItems.registerNormalArmor("silver_boots", "silver_armor", ModArmorMaterials.SILVER_ARMOR_MATERIALS, ArmorItem.Type.BOOTS, 180);
    public static final DeferredItem<NormalArmorItem> TUNGSTEN_HELMET = ArmorItems.registerNormalArmor("tungsten_helmet", "tungsten_armor", ModArmorMaterials.TUNGSTEN_ARMOR_MATERIALS, ArmorItem.Type.HELMET, 210);
    public static final DeferredItem<NormalArmorItem> TUNGSTEN_CHESTPLATE = ArmorItems.registerNormalArmor("tungsten_chestplate", "tungsten_armor", ModArmorMaterials.TUNGSTEN_ARMOR_MATERIALS, ArmorItem.Type.CHESTPLATE, 290);
    public static final DeferredItem<NormalArmorItem> TUNGSTEN_LEGGINGS = ArmorItems.registerNormalArmor("tungsten_leggings", "tungsten_armor", ModArmorMaterials.TUNGSTEN_ARMOR_MATERIALS, ArmorItem.Type.LEGGINGS, 270);
    public static final DeferredItem<NormalArmorItem> TUNGSTEN_BOOTS = ArmorItems.registerNormalArmor("tungsten_boots", "tungsten_armor", ModArmorMaterials.TUNGSTEN_ARMOR_MATERIALS, ArmorItem.Type.BOOTS, 200);
    public static final DeferredItem<NormalArmorItem> GOLDEN_HELMET = ArmorItems.registerNormalArmor("golden_helmet", "golden_armor", ModArmorMaterials.GOLDEN_ARMOR_MATERIALS, ArmorItem.Type.HELMET, 250);
    public static final DeferredItem<NormalArmorItem> GOLDEN_CHESTPLATE = ArmorItems.registerNormalArmor("golden_chestplate", "golden_armor", ModArmorMaterials.GOLDEN_ARMOR_MATERIALS, ArmorItem.Type.CHESTPLATE, 340);
    public static final DeferredItem<NormalArmorItem> GOLDEN_LEGGINGS = ArmorItems.registerNormalArmor("golden_leggings", "golden_armor", ModArmorMaterials.GOLDEN_ARMOR_MATERIALS, ArmorItem.Type.LEGGINGS, 320);
    public static final DeferredItem<NormalArmorItem> GOLDEN_BOOTS = ArmorItems.registerNormalArmor("golden_boots", "golden_armor", ModArmorMaterials.GOLDEN_ARMOR_MATERIALS, ArmorItem.Type.BOOTS, 260);
    public static final DeferredItem<NormalArmorItem> PLATINUM_HELMET = ArmorItems.registerNormalArmor("platinum_helmet", "platinum_armor", ModArmorMaterials.PLATINUM_ARMOR_MATERIALS, ArmorItem.Type.HELMET, 250);
    public static final DeferredItem<NormalArmorItem> PLATINUM_CHESTPLATE = ArmorItems.registerNormalArmor("platinum_chestplate", "platinum_armor", ModArmorMaterials.PLATINUM_ARMOR_MATERIALS, ArmorItem.Type.CHESTPLATE, 340);
    public static final DeferredItem<NormalArmorItem> PLATINUM_LEGGINGS = ArmorItems.registerNormalArmor("platinum_leggings", "platinum_armor", ModArmorMaterials.PLATINUM_ARMOR_MATERIALS, ArmorItem.Type.LEGGINGS, 320);
    public static final DeferredItem<NormalArmorItem> PLATINUM_BOOTS = ArmorItems.registerNormalArmor("platinum_boots", "platinum_armor", ModArmorMaterials.PLATINUM_ARMOR_MATERIALS, ArmorItem.Type.BOOTS, 260);
    public static final DeferredItem<NormalArmorItem> FOSSIL_HELMET = ArmorItems.registerNormalArmor("fossil_helmet", "fossil_armor", ModRarity.BLUE, ModArmorMaterials.FOSSIL_ARMOR_MATERIALS, ArmorItem.Type.HELMET);
    public static final DeferredItem<NormalArmorItem> FOSSIL_CHESTPLATE = ArmorItems.registerNormalArmor("fossil_chestplate", "fossil_armor", ModRarity.BLUE, ModArmorMaterials.FOSSIL_ARMOR_MATERIALS, ArmorItem.Type.CHESTPLATE);
    public static final DeferredItem<NormalArmorItem> FOSSIL_LEGGINGS = ArmorItems.registerNormalArmor("fossil_leggings", "fossil_armor", ModRarity.BLUE, ModArmorMaterials.FOSSIL_ARMOR_MATERIALS, ArmorItem.Type.LEGGINGS);
    public static final DeferredItem<NormalArmorItem> FOSSIL_BOOTS = ArmorItems.registerNormalArmor("fossil_boots", "fossil_armor", ModRarity.BLUE, ModArmorMaterials.FOSSIL_ARMOR_MATERIALS, ArmorItem.Type.BOOTS);
    public static final DeferredItem<NormalArmorItem> SPORE_ROOT_HELMET = ArmorItems.registerNormalArmor("spore_root_helmet", "spore_root_armor", ModRarity.BLUE, ModArmorMaterials.SPORE_ROOT_ARMOR_MATERIALS, ArmorItem.Type.HELMET);
    public static final DeferredItem<NormalArmorItem> SPORE_ROOT_CHESTPLATE = ArmorItems.registerNormalArmor("spore_root_chestplate", "spore_root_armor", ModRarity.BLUE, ModArmorMaterials.SPORE_ROOT_ARMOR_MATERIALS, ArmorItem.Type.CHESTPLATE);
    public static final DeferredItem<NormalArmorItem> SPORE_ROOT_LEGGINGS = ArmorItems.registerNormalArmor("spore_root_leggings", "spore_root_armor", ModRarity.BLUE, ModArmorMaterials.SPORE_ROOT_ARMOR_MATERIALS, ArmorItem.Type.LEGGINGS);
    public static final DeferredItem<NormalArmorItem> SPORE_ROOT_BOOTS = ArmorItems.registerNormalArmor("spore_root_boots", "spore_root_armor", ModRarity.BLUE, ModArmorMaterials.SPORE_ROOT_ARMOR_MATERIALS, ArmorItem.Type.BOOTS);
    public static final DeferredItem<NormalArmorItem> COLD_CRYSTAL_HELMET = ArmorItems.registerNormalArmor("cold_crystal_helmet", "cold_crystal_armor", ModRarity.BLUE, ModArmorMaterials.COLD_CRYSTAL_ARMOR_MATERIALS, ArmorItem.Type.HELMET);
    public static final DeferredItem<NormalArmorItem> COLD_CRYSTAL_CHESTPLATE = ArmorItems.registerNormalArmor("cold_crystal_chestplate", "cold_crystal_armor", ModRarity.BLUE, ModArmorMaterials.COLD_CRYSTAL_ARMOR_MATERIALS, ArmorItem.Type.CHESTPLATE);
    public static final DeferredItem<NormalArmorItem> COLD_CRYSTAL_LEGGINGS = ArmorItems.registerNormalArmor("cold_crystal_leggings", "cold_crystal_armor", ModRarity.BLUE, ModArmorMaterials.COLD_CRYSTAL_ARMOR_MATERIALS, ArmorItem.Type.LEGGINGS);
    public static final DeferredItem<NormalArmorItem> COLD_CRYSTAL_BOOTS = ArmorItems.registerNormalArmor("cold_crystal_boots", "cold_crystal_armor", ModRarity.BLUE, ModArmorMaterials.COLD_CRYSTAL_ARMOR_MATERIALS, ArmorItem.Type.BOOTS);
    public static final DeferredItem<NormalArmorItem> HEIM_HELMET = ArmorItems.registerNormalArmor("heim_helmet", "heim_armor", ModRarity.BLUE, ModArmorMaterials.HEIM_ARMOR_MATERIALS, ArmorItem.Type.HELMET);
    public static final DeferredItem<NormalArmorItem> HEIM_CHESTPLATE = ArmorItems.registerNormalArmor("heim_chestplate", "heim_armor", ModRarity.BLUE, ModArmorMaterials.HEIM_ARMOR_MATERIALS, ArmorItem.Type.CHESTPLATE);
    public static final DeferredItem<NormalArmorItem> HEIM_LEGGINGS = ArmorItems.registerNormalArmor("heim_leggings", "heim_armor", ModRarity.BLUE, ModArmorMaterials.HEIM_ARMOR_MATERIALS, ArmorItem.Type.LEGGINGS);
    public static final DeferredItem<NormalArmorItem> HEIM_BOOTS = ArmorItems.registerNormalArmor("heim_boots", "heim_armor", ModRarity.BLUE, ModArmorMaterials.HEIM_ARMOR_MATERIALS, ArmorItem.Type.BOOTS);
    public static final DeferredItem<NormalArmorItem> BEE_HELMET = ArmorItems.registerNormalArmor("bee_helmet", "bee_armor", ModRarity.ORANGE, ModArmorMaterials.BEE_ARMOR_MATERIALS, ArmorItem.Type.HELMET);
    public static final DeferredItem<NormalArmorItem> BEE_CHESTPLATE = ArmorItems.registerNormalArmor("bee_chestplate", "bee_armor", ModRarity.ORANGE, ModArmorMaterials.BEE_ARMOR_MATERIALS, ArmorItem.Type.CHESTPLATE);
    public static final DeferredItem<NormalArmorItem> BEE_LEGGINGS = ArmorItems.registerNormalArmor("bee_leggings", "bee_armor", ModRarity.ORANGE, ModArmorMaterials.BEE_ARMOR_MATERIALS, ArmorItem.Type.LEGGINGS);
    public static final DeferredItem<NormalArmorItem> BEE_BOOTS = ArmorItems.registerNormalArmor("bee_boots", "bee_armor", ModRarity.ORANGE, ModArmorMaterials.BEE_ARMOR_MATERIALS, ArmorItem.Type.BOOTS);
    public static final DeferredItem<NormalArmorItem> OBSIDIAN_HELMET = ArmorItems.registerNormalArmor("obsidian_helmet", "obsidian_armor", ModRarity.BLUE, ModArmorMaterials.OBSIDIAN_ARMOR_MATERIALS, ArmorItem.Type.HELMET);
    public static final DeferredItem<NormalArmorItem> OBSIDIAN_CHESTPLATE = ArmorItems.registerNormalArmor("obsidian_chestplate", "obsidian_armor", ModRarity.BLUE, ModArmorMaterials.OBSIDIAN_ARMOR_MATERIALS, ArmorItem.Type.CHESTPLATE);
    public static final DeferredItem<NormalArmorItem> OBSIDIAN_LEGGINGS = ArmorItems.registerNormalArmor("obsidian_leggings", "obsidian_armor", ModRarity.BLUE, ModArmorMaterials.OBSIDIAN_ARMOR_MATERIALS, ArmorItem.Type.LEGGINGS);
    public static final DeferredItem<NormalArmorItem> OBSIDIAN_BOOTS = ArmorItems.registerNormalArmor("obsidian_boots", "obsidian_armor", ModRarity.BLUE, ModArmorMaterials.OBSIDIAN_ARMOR_MATERIALS, ArmorItem.Type.BOOTS);
    public static final DeferredItem<NormalArmorItem> GLADIATOR_HELMET = ArmorItems.registerNormalArmor("gladiator_helmet", "gladiator_armor", ModArmorMaterials.GLADIATOR_ARMOR_MATERIALS, ArmorItem.Type.HELMET);
    public static final DeferredItem<NormalArmorItem> GLADIATOR_CHESTPLATE = ArmorItems.registerNormalArmor("gladiator_chestplate", "gladiator_armor", ModArmorMaterials.GLADIATOR_ARMOR_MATERIALS, ArmorItem.Type.CHESTPLATE);
    public static final DeferredItem<NormalArmorItem> GLADIATOR_LEGGINGS = ArmorItems.registerNormalArmor("gladiator_leggings", "gladiator_armor", ModArmorMaterials.GLADIATOR_ARMOR_MATERIALS, ArmorItem.Type.LEGGINGS);
    public static final DeferredItem<NormalArmorItem> GLADIATOR_BOOTS = ArmorItems.registerNormalArmor("gladiator_boots", "gladiator_armor", ModArmorMaterials.GLADIATOR_ARMOR_MATERIALS, ArmorItem.Type.BOOTS);
    public static final DeferredItem<NormalArmorItem> METEOR_HELMET = ArmorItems.registerNormalArmor("meteor_helmet", "meteor_armor", ModRarity.BLUE, ModArmorMaterials.METEOR_ARMOR_MATERIALS, ArmorItem.Type.HELMET);
    public static final DeferredItem<NormalArmorItem> METEOR_CHESTPLATE = ArmorItems.registerNormalArmor("meteor_chestplate", "meteor_armor", ModRarity.BLUE, ModArmorMaterials.METEOR_ARMOR_MATERIALS, ArmorItem.Type.CHESTPLATE);
    public static final DeferredItem<NormalArmorItem> METEOR_LEGGINGS = ArmorItems.registerNormalArmor("meteor_leggings", "meteor_armor", ModRarity.BLUE, ModArmorMaterials.METEOR_ARMOR_MATERIALS, ArmorItem.Type.LEGGINGS);
    public static final DeferredItem<NormalArmorItem> METEOR_BOOTS = ArmorItems.registerNormalArmor("meteor_boots", "meteor_armor", ModRarity.BLUE, ModArmorMaterials.METEOR_ARMOR_MATERIALS, ArmorItem.Type.BOOTS);
    public static final DeferredItem<NormalArmorItem> JUNGLE_HELMET = ArmorItems.registerNormalArmor("jungle_helmet", "jungle_armor", ModRarity.ORANGE, ModArmorMaterials.JUNGLE_ARMOR_MATERIALS, ArmorItem.Type.HELMET);
    public static final DeferredItem<NormalArmorItem> JUNGLE_CHESTPLATE = ArmorItems.registerNormalArmor("jungle_chestplate", "jungle_armor", ModRarity.ORANGE, ModArmorMaterials.JUNGLE_ARMOR_MATERIALS, ArmorItem.Type.CHESTPLATE);
    public static final DeferredItem<NormalArmorItem> JUNGLE_LEGGINGS = ArmorItems.registerNormalArmor("jungle_leggings", "jungle_armor", ModRarity.ORANGE, ModArmorMaterials.JUNGLE_ARMOR_MATERIALS, ArmorItem.Type.LEGGINGS);
    public static final DeferredItem<NormalArmorItem> JUNGLE_BOOTS = ArmorItems.registerNormalArmor("jungle_boots", "jungle_armor", ModRarity.ORANGE, ModArmorMaterials.JUNGLE_ARMOR_MATERIALS, ArmorItem.Type.BOOTS);
    public static final DeferredItem<NormalArmorItem> NECRO_HELMET = ArmorItems.registerNormalArmor("necro_helmet", "necro_armor", ModRarity.GREEN, ModArmorMaterials.NECRO_ARMOR_MATERIALS, ArmorItem.Type.HELMET);
    public static final DeferredItem<NormalArmorItem> NECRO_CHESTPLATE = ArmorItems.registerNormalArmor("necro_chestplate", "necro_armor", ModRarity.GREEN, ModArmorMaterials.NECRO_ARMOR_MATERIALS, ArmorItem.Type.CHESTPLATE);
    public static final DeferredItem<NormalArmorItem> NECRO_LEGGINGS = ArmorItems.registerNormalArmor("necro_leggings", "necro_armor", ModRarity.GREEN, ModArmorMaterials.NECRO_ARMOR_MATERIALS, ArmorItem.Type.LEGGINGS);
    public static final DeferredItem<NormalArmorItem> NECRO_BOOTS = ArmorItems.registerNormalArmor("necro_boots", "necro_armor", ModRarity.GREEN, ModArmorMaterials.NECRO_ARMOR_MATERIALS, ArmorItem.Type.BOOTS);
    public static final DeferredItem<NormalArmorItem> SHADOW_HELMET = ArmorItems.registerNormalArmor("shadow_helmet", "shadow_armor", ModRarity.BLUE, ModArmorMaterials.SHADOW_ARMOR_MATERIALS, ArmorItem.Type.HELMET);
    public static final DeferredItem<NormalArmorItem> SHADOW_CHESTPLATE = ArmorItems.registerNormalArmor("shadow_chestplate", "shadow_armor", ModRarity.BLUE, ModArmorMaterials.SHADOW_ARMOR_MATERIALS, ArmorItem.Type.CHESTPLATE);
    public static final DeferredItem<NormalArmorItem> SHADOW_LEGGINGS = ArmorItems.registerNormalArmor("shadow_leggings", "shadow_armor", ModRarity.BLUE, ModArmorMaterials.SHADOW_ARMOR_MATERIALS, ArmorItem.Type.LEGGINGS);
    public static final DeferredItem<NormalArmorItem> SHADOW_BOOTS = ArmorItems.registerNormalArmor("shadow_boots", "shadow_armor", ModRarity.BLUE, ModArmorMaterials.SHADOW_ARMOR_MATERIALS, ArmorItem.Type.BOOTS);
    public static final DeferredItem<NormalArmorItem> CRIMSON_HELMET = ArmorItems.registerNormalArmor("crimson_helmet", "crimson_armor", ModRarity.BLUE, ModArmorMaterials.CRIMSON_ARMOR_MATERIALS, ArmorItem.Type.HELMET);
    public static final DeferredItem<NormalArmorItem> CRIMSON_CHESTPLATE = ArmorItems.registerNormalArmor("crimson_chestplate", "crimson_armor", ModRarity.BLUE, ModArmorMaterials.CRIMSON_ARMOR_MATERIALS, ArmorItem.Type.CHESTPLATE);
    public static final DeferredItem<NormalArmorItem> CRIMSON_LEGGINGS = ArmorItems.registerNormalArmor("crimson_leggings", "crimson_armor", ModRarity.BLUE, ModArmorMaterials.CRIMSON_ARMOR_MATERIALS, ArmorItem.Type.LEGGINGS);
    public static final DeferredItem<NormalArmorItem> CRIMSON_BOOTS = ArmorItems.registerNormalArmor("crimson_boots", "crimson_armor", ModRarity.BLUE, ModArmorMaterials.CRIMSON_ARMOR_MATERIALS, ArmorItem.Type.BOOTS);
    public static final DeferredItem<NormalArmorItem> MOLTEN_HELMET = ArmorItems.registerNormalArmor("molten_helmet", "molten_armor", ModRarity.ORANGE, ModArmorMaterials.MOLTEN_ARMOR_MATERIALS, ArmorItem.Type.HELMET);
    public static final DeferredItem<NormalArmorItem> MOLTEN_CHESTPLATE = ArmorItems.registerNormalArmor("molten_chestplate", "molten_armor", ModRarity.ORANGE, ModArmorMaterials.MOLTEN_ARMOR_MATERIALS, ArmorItem.Type.CHESTPLATE);
    public static final DeferredItem<NormalArmorItem> MOLTEN_LEGGINGS = ArmorItems.registerNormalArmor("molten_leggings", "molten_armor", ModRarity.ORANGE, ModArmorMaterials.MOLTEN_ARMOR_MATERIALS, ArmorItem.Type.LEGGINGS);
    public static final DeferredItem<NormalArmorItem> MOLTEN_BOOTS = ArmorItems.registerNormalArmor("molten_boots", "molten_armor", ModRarity.ORANGE, ModArmorMaterials.MOLTEN_ARMOR_MATERIALS, ArmorItem.Type.BOOTS);
    public static final DeferredItem<NormalArmorItem> PEARL_HELMET = ArmorItems.registerNormalArmor("pearl_helmet", "pearl_armor", ModArmorMaterials.PEARL_ARMOR_MATERIALS, ArmorItem.Type.HELMET, 120);
    public static final DeferredItem<NormalArmorItem> PEARL_CHESTPLATE = ArmorItems.registerNormalArmor("pearl_chestplate", "pearl_armor", ModArmorMaterials.PEARL_ARMOR_MATERIALS, ArmorItem.Type.CHESTPLATE, 170);
    public static final DeferredItem<NormalArmorItem> PEARL_LEGGINGS = ArmorItems.registerNormalArmor("pearl_leggings", "pearl_armor", ModArmorMaterials.PEARL_ARMOR_MATERIALS, ArmorItem.Type.LEGGINGS, 150);
    public static final DeferredItem<NormalArmorItem> PEARL_BOOTS = ArmorItems.registerNormalArmor("pearl_boots", "pearl_armor", ModArmorMaterials.PEARL_ARMOR_MATERIALS, ArmorItem.Type.BOOTS, 130);
    public static final DeferredItem<NormalArmorItem> SPIDER_HELMET = ArmorItems.registerNormalArmor("spider_helmet", "spider_armor", ModRarity.LIGHT_RED, ModArmorMaterials.SPIDER_ARMOR_MATERIALS, ArmorItem.Type.HELMET);
    public static final DeferredItem<NormalArmorItem> SPIDER_CHESTPLATE = ArmorItems.registerNormalArmor("spider_chestplate", "spider_armor", ModRarity.LIGHT_RED, ModArmorMaterials.SPIDER_ARMOR_MATERIALS, ArmorItem.Type.CHESTPLATE);
    public static final DeferredItem<NormalArmorItem> SPIDER_LEGGINGS = ArmorItems.registerNormalArmor("spider_leggings", "spider_armor", ModRarity.LIGHT_RED, ModArmorMaterials.SPIDER_ARMOR_MATERIALS, ArmorItem.Type.LEGGINGS);
    public static final DeferredItem<NormalArmorItem> SPIDER_BOOTS = ArmorItems.registerNormalArmor("spider_boots", "spider_armor", ModRarity.LIGHT_RED, ModArmorMaterials.SPIDER_ARMOR_MATERIALS, ArmorItem.Type.BOOTS);
    public static final DeferredItem<MultiHeadArmorItem> COBALT_MASK = ArmorItems.registerMultiHeadArmor("cobalt_mask", "cobalt_armor", ModRarity.LIGHT_RED, ModArmorMaterials.COBALT_MASK_MATERIAL, ArmorItem.Type.HELMET);
    public static final DeferredItem<MultiHeadArmorItem> COBALT_HAT = ArmorItems.registerMultiHeadArmor("cobalt_hat", "cobalt_armor", ModRarity.LIGHT_RED, ModArmorMaterials.COBALT_HAT_MATERIAL, ArmorItem.Type.HELMET);
    public static final DeferredItem<MultiHeadArmorItem> COBALT_HELMET = ArmorItems.registerMultiHeadArmor("cobalt_helmet", "cobalt_armor", ModRarity.LIGHT_RED, ModArmorMaterials.COBALT_ARMOR_MATERIALS, ArmorItem.Type.HELMET);
    public static final DeferredItem<MultiHeadArmorItem> COBALT_CHESTPLATE = ArmorItems.registerMultiHeadArmor("cobalt_chestplate", "cobalt_armor", ModRarity.LIGHT_RED, ModArmorMaterials.COBALT_ARMOR_MATERIALS, ArmorItem.Type.CHESTPLATE);
    public static final DeferredItem<MultiHeadArmorItem> COBALT_LEGGINGS = ArmorItems.registerMultiHeadArmor("cobalt_leggings", "cobalt_armor", ModRarity.LIGHT_RED, ModArmorMaterials.COBALT_ARMOR_MATERIALS, ArmorItem.Type.LEGGINGS);
    public static final DeferredItem<MultiHeadArmorItem> COBALT_BOOTS = ArmorItems.registerMultiHeadArmor("cobalt_boots", "cobalt_armor", ModRarity.LIGHT_RED, ModArmorMaterials.COBALT_ARMOR_MATERIALS, ArmorItem.Type.BOOTS);
    public static final DeferredItem<MultiHeadArmorItem> PALLADIUM_MASK = ArmorItems.registerMultiHeadArmor("palladium_mask", "palladium_armor", ModRarity.PINK, ModArmorMaterials.PALLADIUM_MASK_MATERIAL, ArmorItem.Type.HELMET);
    public static final DeferredItem<MultiHeadArmorItem> PALLADIUM_HEADGEAR = ArmorItems.registerMultiHeadArmor("palladium_headgear", "palladium_armor", ModRarity.PINK, ModArmorMaterials.PALLADIUM_HEADGEAR_MATERIAL, ArmorItem.Type.HELMET);
    public static final DeferredItem<MultiHeadArmorItem> PALLADIUM_HELMET = ArmorItems.registerMultiHeadArmor("palladium_helmet", "palladium_armor", ModRarity.PINK, ModArmorMaterials.PALLADIUM_ARMOR_MATERIALS, ArmorItem.Type.HELMET);
    public static final DeferredItem<MultiHeadArmorItem> PALLADIUM_CHESTPLATE = ArmorItems.registerMultiHeadArmor("palladium_chestplate", "palladium_armor", ModRarity.PINK, ModArmorMaterials.PALLADIUM_ARMOR_MATERIALS, ArmorItem.Type.CHESTPLATE);
    public static final DeferredItem<MultiHeadArmorItem> PALLADIUM_LEGGINGS = ArmorItems.registerMultiHeadArmor("palladium_leggings", "palladium_armor", ModRarity.PINK, ModArmorMaterials.PALLADIUM_ARMOR_MATERIALS, ArmorItem.Type.LEGGINGS);
    public static final DeferredItem<MultiHeadArmorItem> PALLADIUM_BOOTS = ArmorItems.registerMultiHeadArmor("palladium_boots", "palladium_armor", ModRarity.PINK, ModArmorMaterials.PALLADIUM_ARMOR_MATERIALS, ArmorItem.Type.BOOTS);
    public static final DeferredItem<MultiHeadArmorItem> MYTHRIL_HOOD = ArmorItems.registerMultiHeadArmor("mythril_hood", "mythril_armor", ModRarity.LIGHT_RED, ModArmorMaterials.MYTHRIL_HOOD_MATERIAL, ArmorItem.Type.HELMET);
    public static final DeferredItem<MultiHeadArmorItem> MYTHRIL_HAT = ArmorItems.registerMultiHeadArmor("mythril_hat", "mythril_armor", ModRarity.LIGHT_RED, ModArmorMaterials.MYTHRIL_HAT_MATERIAL, ArmorItem.Type.HELMET);
    public static final DeferredItem<MultiHeadArmorItem> MYTHRIL_HELMET = ArmorItems.registerMultiHeadArmor("mythril_helmet", "mythril_armor", ModRarity.LIGHT_RED, ModArmorMaterials.MYTHRIL_ARMOR_MATERIALS, ArmorItem.Type.HELMET);
    public static final DeferredItem<MultiHeadArmorItem> MYTHRIL_CHESTPLATE = ArmorItems.registerMultiHeadArmor("mythril_chestplate", "mythril_armor", ModRarity.LIGHT_RED, ModArmorMaterials.MYTHRIL_ARMOR_MATERIALS, ArmorItem.Type.CHESTPLATE);
    public static final DeferredItem<MultiHeadArmorItem> MYTHRIL_LEGGINGS = ArmorItems.registerMultiHeadArmor("mythril_leggings", "mythril_armor", ModRarity.LIGHT_RED, ModArmorMaterials.MYTHRIL_ARMOR_MATERIALS, ArmorItem.Type.LEGGINGS);
    public static final DeferredItem<MultiHeadArmorItem> MYTHRIL_BOOTS = ArmorItems.registerMultiHeadArmor("mythril_boots", "mythril_armor", ModRarity.LIGHT_RED, ModArmorMaterials.MYTHRIL_ARMOR_MATERIALS, ArmorItem.Type.BOOTS);
    public static final DeferredItem<MultiHeadArmorItem> ORICHALCUM_HEADGEAR = ArmorItems.registerMultiHeadArmor("orichalcum_headgear", "orichalcum_armor", ModRarity.LIGHT_RED, ModArmorMaterials.ORICHALCUM_HEADGEAR_MATERIAL, ArmorItem.Type.HELMET);
    public static final DeferredItem<MultiHeadArmorItem> ORICHALCUM_MASK = ArmorItems.registerMultiHeadArmor("orichalcum_mask", "orichalcum_armor", ModRarity.LIGHT_RED, ModArmorMaterials.ORICHALCUM_MASK_MATERIAL, ArmorItem.Type.HELMET);
    public static final DeferredItem<MultiHeadArmorItem> ORICHALCUM_HELMET = ArmorItems.registerMultiHeadArmor("orichalcum_helmet", "orichalcum_armor", ModRarity.LIGHT_RED, ModArmorMaterials.ORICHALCUM_ARMOR_MATERIALS, ArmorItem.Type.HELMET);
    public static final DeferredItem<MultiHeadArmorItem> ORICHALCUM_CHESTPLATE = ArmorItems.registerMultiHeadArmor("orichalcum_chestplate", "orichalcum_armor", ModRarity.LIGHT_RED, ModArmorMaterials.ORICHALCUM_ARMOR_MATERIALS, ArmorItem.Type.CHESTPLATE);
    public static final DeferredItem<MultiHeadArmorItem> ORICHALCUM_LEGGINGS = ArmorItems.registerMultiHeadArmor("orichalcum_leggings", "orichalcum_armor", ModRarity.LIGHT_RED, ModArmorMaterials.ORICHALCUM_ARMOR_MATERIALS, ArmorItem.Type.LEGGINGS);
    public static final DeferredItem<MultiHeadArmorItem> ORICHALCUM_BOOTS = ArmorItems.registerMultiHeadArmor("orichalcum_boots", "orichalcum_armor", ModRarity.LIGHT_RED, ModArmorMaterials.ORICHALCUM_ARMOR_MATERIALS, ArmorItem.Type.BOOTS);
    public static final DeferredItem<MultiHeadArmorItem> ADAMANTITE_HEADGEAR = ArmorItems.registerMultiHeadArmor("adamantite_headgear", "adamantite_armor", ModRarity.LIGHT_RED, ModArmorMaterials.ADAMANTITE_HEADGEAR_MATERIAL, ArmorItem.Type.HELMET);
    public static final DeferredItem<MultiHeadArmorItem> ADAMANTITE_MASK = ArmorItems.registerMultiHeadArmor("adamantite_mask", "adamantite_armor", ModRarity.LIGHT_RED, ModArmorMaterials.ADAMANTITE_MASK_MATERIAL, ArmorItem.Type.HELMET);
    public static final DeferredItem<MultiHeadArmorItem> ADAMANTITE_HELMET = ArmorItems.registerMultiHeadArmor("adamantite_helmet", "adamantite_armor", ModRarity.LIGHT_RED, ModArmorMaterials.ADAMANTITE_ARMOR_MATERIALS, ArmorItem.Type.HELMET);
    public static final DeferredItem<MultiHeadArmorItem> ADAMANTITE_CHESTPLATE = ArmorItems.registerMultiHeadArmor("adamantite_chestplate", "adamantite_armor", ModRarity.LIGHT_RED, ModArmorMaterials.ADAMANTITE_ARMOR_MATERIALS, ArmorItem.Type.CHESTPLATE);
    public static final DeferredItem<MultiHeadArmorItem> ADAMANTITE_LEGGINGS = ArmorItems.registerMultiHeadArmor("adamantite_leggings", "adamantite_armor", ModRarity.LIGHT_RED, ModArmorMaterials.ADAMANTITE_ARMOR_MATERIALS, ArmorItem.Type.LEGGINGS);
    public static final DeferredItem<MultiHeadArmorItem> ADAMANTITE_BOOTS = ArmorItems.registerMultiHeadArmor("adamantite_boots", "adamantite_armor", ModRarity.LIGHT_RED, ModArmorMaterials.ADAMANTITE_ARMOR_MATERIALS, ArmorItem.Type.BOOTS);
    public static final DeferredItem<MultiHeadArmorItem> TITANIUM_HEADGEAR = ArmorItems.registerMultiHeadArmor("titanium_headgear", "titanium_armor", ModRarity.LIGHT_RED, ModArmorMaterials.TITANIUM_HEADGEAR_MATERIAL, ArmorItem.Type.HELMET);
    public static final DeferredItem<MultiHeadArmorItem> TITANIUM_MASK = ArmorItems.registerMultiHeadArmor("titanium_mask", "titanium_armor", ModRarity.LIGHT_RED, ModArmorMaterials.TITANIUM_MASK_MATERIAL, ArmorItem.Type.HELMET);
    public static final DeferredItem<MultiHeadArmorItem> TITANIUM_HELMET = ArmorItems.registerMultiHeadArmor("titanium_helmet", "titanium_armor", ModRarity.LIGHT_RED, ModArmorMaterials.TITANIUM_ARMOR_MATERIALS, ArmorItem.Type.HELMET);
    public static final DeferredItem<MultiHeadArmorItem> TITANIUM_CHESTPLATE = ArmorItems.registerMultiHeadArmor("titanium_chestplate", "titanium_armor", ModRarity.LIGHT_RED, ModArmorMaterials.TITANIUM_ARMOR_MATERIALS, ArmorItem.Type.CHESTPLATE);
    public static final DeferredItem<MultiHeadArmorItem> TITANIUM_LEGGINGS = ArmorItems.registerMultiHeadArmor("titanium_leggings", "titanium_armor", ModRarity.LIGHT_RED, ModArmorMaterials.TITANIUM_ARMOR_MATERIALS, ArmorItem.Type.LEGGINGS);
    public static final DeferredItem<MultiHeadArmorItem> TITANIUM_BOOTS = ArmorItems.registerMultiHeadArmor("titanium_boots", "titanium_armor", ModRarity.LIGHT_RED, ModArmorMaterials.TITANIUM_ARMOR_MATERIALS, ArmorItem.Type.BOOTS);
    public static final DeferredItem<NormalArmorItem> CRYSTAL_ASSASSIN_HELMET = ArmorItems.registerNormalArmor("crystal_assassin_helmet", "crystal_assassin_armor", ModRarity.PINK, ModArmorMaterials.CRYSTAL_ASSASSIN_ARMOR_MATERIALS, ArmorItem.Type.HELMET);
    public static final DeferredItem<NormalArmorItem> CRYSTAL_ASSASSIN_CHESTPLATE = ArmorItems.registerNormalArmor("crystal_assassin_chestplate", "crystal_assassin_armor", ModRarity.PINK, ModArmorMaterials.CRYSTAL_ASSASSIN_ARMOR_MATERIALS, ArmorItem.Type.CHESTPLATE);
    public static final DeferredItem<NormalArmorItem> CRYSTAL_ASSASSIN_LEGGINGS = ArmorItems.registerNormalArmor("crystal_assassin_leggings", "crystal_assassin_armor", ModRarity.PINK, ModArmorMaterials.CRYSTAL_ASSASSIN_ARMOR_MATERIALS, ArmorItem.Type.LEGGINGS);
    public static final DeferredItem<NormalArmorItem> CRYSTAL_ASSASSIN_BOOTS = ArmorItems.registerNormalArmor("crystal_assassin_boots", "crystal_assassin_armor", ModRarity.PINK, ModArmorMaterials.CRYSTAL_ASSASSIN_ARMOR_MATERIALS, ArmorItem.Type.BOOTS);
    public static final DeferredItem<MultiHeadArmorItem> HALLOWED_MASK = ArmorItems.registerMultiHeadArmor("hallowed_mask", "hallowed_armor", ModRarity.PINK, ModArmorMaterials.HALLOWED_MASK_MATERIAL, ArmorItem.Type.HELMET);
    public static final DeferredItem<MultiHeadArmorItem> HALLOWED_HEADGEAR = ArmorItems.registerMultiHeadArmor("hallowed_headgear", "hallowed_armor", ModRarity.PINK, ModArmorMaterials.HALLOWED_HEADGEAR_MATERIAL, ArmorItem.Type.HELMET);
    public static final DeferredItem<MultiHeadArmorItem> HALLOWED_HOOD = ArmorItems.registerMultiHeadArmor("hallowed_hood", "hallowed_armor", ModRarity.PINK, ModArmorMaterials.HALLOWED_HOOD_MATERIAL, ArmorItem.Type.HELMET);
    public static final DeferredItem<MultiHeadArmorItem> HALLOWED_HELMET = ArmorItems.registerMultiHeadArmor("hallowed_helmet", "hallowed_armor", ModRarity.PINK, ModArmorMaterials.HALLOWED_ARMOR_MATERIALS, ArmorItem.Type.HELMET);
    public static final DeferredItem<MultiHeadArmorItem> HALLOWED_CHESTPLATE = ArmorItems.registerMultiHeadArmor("hallowed_chestplate", "hallowed_armor", ModRarity.PINK, ModArmorMaterials.HALLOWED_ARMOR_MATERIALS, ArmorItem.Type.CHESTPLATE);
    public static final DeferredItem<MultiHeadArmorItem> HALLOWED_LEGGINGS = ArmorItems.registerMultiHeadArmor("hallowed_leggings", "hallowed_armor", ModRarity.PINK, ModArmorMaterials.HALLOWED_ARMOR_MATERIALS, ArmorItem.Type.LEGGINGS);
    public static final DeferredItem<MultiHeadArmorItem> HALLOWED_BOOTS = ArmorItems.registerMultiHeadArmor("hallowed_boots", "hallowed_armor", ModRarity.PINK, ModArmorMaterials.HALLOWED_ARMOR_MATERIALS, ArmorItem.Type.BOOTS);
    public static final DeferredItem<NormalArmorItem> WIZARD_HAT = ArmorItems.registerNormalArmor("wizard_hat", "wizard_hat", ModRarity.GREEN, ModArmorMaterials.WIZARD_HAT_MATERIAL, ArmorItem.Type.HELMET);
    public static final DeferredItem<NormalArmorItem> MAGIC_HAT = ArmorItems.registerNormalArmor("magic_hat", "magic_hat", ModRarity.GREEN, ModArmorMaterials.MAGIC_HAT_ARMOR_MATERIAL, ArmorItem.Type.HELMET);
    public static final DeferredItem<NormalArmorItem> AMETHYST_ROBE = ArmorItems.registerNormalArmor("amethyst_robe", "amethyst_robe", ModRarity.WHITE, ModArmorMaterials.AMETHYST_ROBE_ARMOR_MATERIAL, ArmorItem.Type.CHESTPLATE);
    public static final DeferredItem<NormalArmorItem> TOPAZ_ROBE = ArmorItems.registerNormalArmor("topaz_robe", "topaz_robe", ModRarity.WHITE, ModArmorMaterials.TOPAZ_ROBE_ARMOR_MATERIAL, ArmorItem.Type.CHESTPLATE);
    public static final DeferredItem<NormalArmorItem> SAPPHIRE_ROBE = ArmorItems.registerNormalArmor("sapphire_robe", "sapphire_robe", ModRarity.BLUE, ModArmorMaterials.SAPPHIRE_ROBE_ARMOR_MATERIAL, ArmorItem.Type.CHESTPLATE);
    public static final DeferredItem<NormalArmorItem> JADE_ROBE = ArmorItems.registerNormalArmor("jade_robe", "jade_robe", ModRarity.BLUE, ModArmorMaterials.EMERALD_ROBE_ARMOR_MATERIAL, ArmorItem.Type.CHESTPLATE);
    public static final DeferredItem<NormalArmorItem> RUBY_ROBE = ArmorItems.registerNormalArmor("ruby_robe", "ruby_robe", ModRarity.BLUE, ModArmorMaterials.RUBY_ROBE_ARMOR_MATERIAL, ArmorItem.Type.CHESTPLATE);
    public static final DeferredItem<NormalArmorItem> MYSTIC_ROBE = ArmorItems.registerNormalArmor("mystic_robe", "mystic_robe", ModRarity.BLUE, ModArmorMaterials.MYSTIC_ROBE_ARMOR_MATERIAL, ArmorItem.Type.CHESTPLATE);
    public static final DeferredItem<NormalArmorItem> DIAMOND_ROBE = ArmorItems.registerNormalArmor("diamond_robe", "diamond_robe", ModRarity.GREEN, ModArmorMaterials.DIAMOND_ROBE_ARMOR_MATERIAL, ArmorItem.Type.CHESTPLATE);
    public static final DeferredItem<NormalArmorItem> AMBER_ROBE = ArmorItems.registerNormalArmor("amber_robe", "amber_robe", ModRarity.GREEN, ModArmorMaterials.AMBER_ROBE_ARMOR_MATERIAL, ArmorItem.Type.CHESTPLATE);
    public static final DeferredItem<ArmorItem> GOGGLES = ITEMS.register("goggles", () -> new ArmorItem(ModArmorMaterials.GOGGLES_MATERIAL, ArmorItem.Type.HELMET, new Item.Properties().stacksTo(1).component(ConfluenceMagicLib.MOD_RARITY, (Object)ModRarity.WHITE)));
    public static final DeferredItem<ArmorItem> GREEN_CAP = ITEMS.register("green_cap", () -> new ArmorItem(ModArmorMaterials.GREEN_CAP_MATERIAL, ArmorItem.Type.HELMET, new Item.Properties().stacksTo(1).component(ConfluenceMagicLib.MOD_RARITY, (Object)ModRarity.WHITE)));
    public static final DeferredItem<NormalArmorItem> VIKING_HELMET = ArmorItems.registerNormalArmor("viking_helmet", "viking_armor", ModRarity.BLUE, ModArmorMaterials.VIKING_ARMOR_MATERIAL, ArmorItem.Type.HELMET);
    public static final DeferredItem<NormalArmorItem> FLINX_FUR_COAT = ArmorItems.registerNormalArmor("flinx_fur_coat", "flinx_fur_coat_armor", ModRarity.GREEN, ModArmorMaterials.FLINX_FUR_COAT_MATERIAL, ArmorItem.Type.CHESTPLATE);

    private static DeferredItem<NormalArmorItem> registerNormalArmor(String name, String geoName, Holder<ArmorMaterial> material, ArmorItem.Type type, int durability) {
        return ITEMS.register(name, () -> new NormalArmorItem("armor/" + geoName, material, type, new Item.Properties().stacksTo(1).durability(durability)));
    }

    private static DeferredItem<NormalArmorItem> registerNormalArmor(String name, String geoName, Holder<ArmorMaterial> material, ArmorItem.Type type) {
        return ITEMS.register(name, () -> new NormalArmorItem("armor/" + geoName, material, type, new Item.Properties().stacksTo(1).component(DataComponents.UNBREAKABLE, (Object)ModItems.UNBREAKABLE)));
    }

    private static DeferredItem<NormalArmorItem> registerNormalArmor(String name, String geoName, ModRarity rarity, Holder<ArmorMaterial> material, ArmorItem.Type type) {
        return ITEMS.register(name, () -> new NormalArmorItem("armor/" + geoName, rarity, material, type, new Item.Properties().stacksTo(1).component(DataComponents.UNBREAKABLE, (Object)ModItems.UNBREAKABLE)));
    }

    private static DeferredItem<MultiHeadArmorItem> registerMultiHeadArmor(String name, String geoName, ModRarity rarity, Holder<ArmorMaterial> material, ArmorItem.Type type) {
        return ITEMS.register(name, () -> new MultiHeadArmorItem("armor/" + geoName, rarity, material, type, new Item.Properties().stacksTo(1).component(DataComponents.UNBREAKABLE, (Object)ModItems.UNBREAKABLE)));
    }

    public static void register(IEventBus eventBus) {
        ModArmorMaterials.ARMOR_MATERIALS.register(eventBus);
        ITEMS.register(eventBus);
    }
}

