/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.init.item;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.BoatItem;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.confluence.mod.common.init.ModBoatTypes;

public class BoatItems {
    public static final DeferredRegister.Items BOAT_ITEMS = DeferredRegister.createItems((String)"confluence");
    public static final DeferredRegister.Items CHEST_BOAT_ITEMS = DeferredRegister.createItems((String)"confluence");
    public static final DeferredItem<BoatItem> ASH_BOAT = BoatItems.boat("ash_boat", () -> (Boat.Type)ModBoatTypes.ASH.getValue());
    public static final DeferredItem<BoatItem> ASH_CHEST_BOAT = BoatItems.chestBoat("ash_chest_boat", () -> (Boat.Type)ModBoatTypes.ASH.getValue());
    public static final DeferredItem<BoatItem> BAOBAB_BOAT = BoatItems.boat("baobab_boat", () -> (Boat.Type)ModBoatTypes.BAOBAB.getValue());
    public static final DeferredItem<BoatItem> BAOBAB_CHEST_BOAT = BoatItems.chestBoat("baobab_chest_boat", () -> (Boat.Type)ModBoatTypes.BAOBAB.getValue());
    public static final DeferredItem<BoatItem> EBONY_BOAT = BoatItems.boat("ebony_boat", () -> (Boat.Type)ModBoatTypes.EBONY.getValue());
    public static final DeferredItem<BoatItem> EBONY_CHEST_BOAT = BoatItems.chestBoat("ebony_chest_boat", () -> (Boat.Type)ModBoatTypes.EBONY.getValue());
    public static final DeferredItem<BoatItem> GLOWING_MUSHROOM_BOAT = BoatItems.boat("glowing_mushroom_boat", () -> (Boat.Type)ModBoatTypes.GLOWING_MUSHROOM.getValue());
    public static final DeferredItem<BoatItem> GLOWING_MUSHROOM_CHEST_BOAT = BoatItems.chestBoat("glowing_mushroom_chest_boat", () -> (Boat.Type)ModBoatTypes.GLOWING_MUSHROOM.getValue());
    public static final DeferredItem<BoatItem> LIVING_BOAT = BoatItems.boat("living_boat", () -> (Boat.Type)ModBoatTypes.LIVING.getValue());
    public static final DeferredItem<BoatItem> LIVING_CHEST_BOAT = BoatItems.chestBoat("living_chest_boat", () -> (Boat.Type)ModBoatTypes.LIVING.getValue());
    public static final DeferredItem<BoatItem> LIVING_MAHOGANY_BOAT = BoatItems.boat("living_mahogany_boat", () -> (Boat.Type)ModBoatTypes.LIVING_MAHOGANY.getValue());
    public static final DeferredItem<BoatItem> LIVING_MAHOGANY_CHEST_BOAT = BoatItems.chestBoat("living_mahogany_chest_boat", () -> (Boat.Type)ModBoatTypes.LIVING_MAHOGANY.getValue());
    public static final DeferredItem<BoatItem> PALM_BOAT = BoatItems.boat("palm_boat", () -> (Boat.Type)ModBoatTypes.PALM.getValue());
    public static final DeferredItem<BoatItem> PALM_CHEST_BOAT = BoatItems.chestBoat("palm_chest_boat", () -> (Boat.Type)ModBoatTypes.PALM.getValue());
    public static final DeferredItem<BoatItem> PEARL_BOAT = BoatItems.boat("pearl_boat", () -> (Boat.Type)ModBoatTypes.PEARL.getValue());
    public static final DeferredItem<BoatItem> PEARL_CHEST_BOAT = BoatItems.chestBoat("pearl_chest_boat", () -> (Boat.Type)ModBoatTypes.PEARL.getValue());
    public static final DeferredItem<BoatItem> SHADOW_BOAT = BoatItems.boat("shadow_boat", () -> (Boat.Type)ModBoatTypes.SHADOW.getValue());
    public static final DeferredItem<BoatItem> SHADOW_CHEST_BOAT = BoatItems.chestBoat("shadow_chest_boat", () -> (Boat.Type)ModBoatTypes.SHADOW.getValue());
    public static final DeferredItem<BoatItem> SPOOKY_BOAT = BoatItems.boat("spooky_boat", () -> (Boat.Type)ModBoatTypes.SPOOKY.getValue());
    public static final DeferredItem<BoatItem> SPOOKY_CHEST_BOAT = BoatItems.chestBoat("spooky_chest_boat", () -> (Boat.Type)ModBoatTypes.SPOOKY.getValue());
    public static final DeferredItem<BoatItem> YELLOW_WILLOW_BOAT = BoatItems.boat("yellow_willow_boat", () -> (Boat.Type)ModBoatTypes.YELLOW_WILLOW.getValue());
    public static final DeferredItem<BoatItem> YELLOW_WILLOW_CHEST_BOAT = BoatItems.chestBoat("yellow_willow_chest_boat", () -> (Boat.Type)ModBoatTypes.YELLOW_WILLOW.getValue());
    public static final DeferredItem<BoatItem> DYNASTY_BOAT = BoatItems.boat("dynasty_boat", () -> (Boat.Type)ModBoatTypes.DYNASTY.getValue());
    public static final DeferredItem<BoatItem> DYNASTY_CHEST_BOAT = BoatItems.chestBoat("dynasty_chest_boat", () -> (Boat.Type)ModBoatTypes.DYNASTY.getValue());

    private static DeferredItem<BoatItem> boat(String name, Supplier<Boat.Type> type) {
        return BOAT_ITEMS.register(name, () -> new BoatItem(false, (Boat.Type)type.get(), new Item.Properties().stacksTo(1)));
    }

    private static DeferredItem<BoatItem> chestBoat(String name, Supplier<Boat.Type> type) {
        return CHEST_BOAT_ITEMS.register(name, () -> new BoatItem(true, (Boat.Type)type.get(), new Item.Properties().stacksTo(1)));
    }

    public static void forEach(Consumer<DeferredHolder<Item, ? extends Item>> action) {
        BOAT_ITEMS.getEntries().forEach(action);
        CHEST_BOAT_ITEMS.getEntries().forEach(action);
    }

    public static void register(IEventBus eventBus) {
        BOAT_ITEMS.register(eventBus);
        CHEST_BOAT_ITEMS.register(eventBus);
    }
}

