/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.init.item;

import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.entity.minecart.BaseMinecartEntity;
import org.confluence.mod.common.entity.minecart.DemonicHellcartEntity;
import org.confluence.mod.common.entity.minecart.DiggingMolecartEntity;
import org.confluence.mod.common.entity.minecart.GenericMinecartEntity;
import org.confluence.mod.common.entity.minecart.MechanicalCartEntity;
import org.confluence.mod.common.entity.minecart.MeowmereMinecartEntity;
import org.confluence.mod.common.entity.minecart.MinecarpEntity;
import org.confluence.mod.common.init.ModEntities;
import org.confluence.mod.common.item.common.BaseMinecartItem;

public class MinecartItems {
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"confluence");
    public static final DeferredItem<BaseMinecartItem> MECHANICAL_CART = ITEMS.registerItem("mechanical_cart", properties -> new BaseMinecartItem(properties.fireResistant(), ModRarity.EXPERT, Types.MECHANICAL, MechanicalCartEntity::new));
    public static final DeferredItem<BaseMinecartItem> DESERT_MINECART = MinecartItems.registerGeneric("desert_minecart", Types.DESERT, GenericMinecartEntity.Variant.DESERT);
    public static final DeferredItem<BaseMinecartItem> MINECARP = ITEMS.registerItem("minecarp", properties -> new BaseMinecartItem((Item.Properties)properties, ModRarity.BLUE, Types.MINECARP, MinecarpEntity::new));
    public static final DeferredItem<BaseMinecartItem> BEE_MINECART = MinecartItems.registerGeneric("bee_minecart", Types.BEE, GenericMinecartEntity.Variant.BEE);
    public static final DeferredItem<BaseMinecartItem> LADYBUG_MINECART = MinecartItems.registerGeneric("ladybug_minecart", Types.LADYBUG, GenericMinecartEntity.Variant.LADYBUG);
    public static final DeferredItem<BaseMinecartItem> PIGRON_MINECART = MinecartItems.registerGeneric("pigron_minecart", Types.PIGRON, GenericMinecartEntity.Variant.PIGRON);
    public static final DeferredItem<BaseMinecartItem> SUNFLOWER_MINECART = MinecartItems.registerGeneric("sunflower_minecart", Types.SUNFLOWER, GenericMinecartEntity.Variant.SUNFLOWER);
    public static final DeferredItem<BaseMinecartItem> DEMONIC_HELLCART = ITEMS.registerItem("demonic_hellcart", properties -> new BaseMinecartItem((Item.Properties)properties, ModRarity.BLUE, Types.DEMONIC, DemonicHellcartEntity::new));
    public static final DeferredItem<BaseMinecartItem> SHROOM_MINECART = MinecartItems.registerGeneric("shroom_minecart", Types.SHROOM, GenericMinecartEntity.Variant.SHROOM);
    public static final DeferredItem<BaseMinecartItem> AMETHYST_MINECART = MinecartItems.registerGeneric("amethyst_minecart", Types.AMETHYST, GenericMinecartEntity.Variant.AMETHYST);
    public static final DeferredItem<BaseMinecartItem> TOPAZ_MINECART = MinecartItems.registerGeneric("topaz_minecart", Types.TOPAZ, GenericMinecartEntity.Variant.TOPAZ);
    public static final DeferredItem<BaseMinecartItem> SAPPHIRE_MINECART = MinecartItems.registerGeneric("sapphire_minecart", Types.SAPPHIRE, GenericMinecartEntity.Variant.SAPPHIRE);
    public static final DeferredItem<BaseMinecartItem> JADE_MINECART = MinecartItems.registerGeneric("jade_minecart", Types.JADE, GenericMinecartEntity.Variant.JADE);
    public static final DeferredItem<BaseMinecartItem> RUBY_MINECART = MinecartItems.registerGeneric("ruby_minecart", Types.RUBY, GenericMinecartEntity.Variant.RUBY);
    public static final DeferredItem<BaseMinecartItem> DIAMOND_MINECART = MinecartItems.registerGeneric("diamond_minecart", Types.DIAMOND, GenericMinecartEntity.Variant.DIAMOND);
    public static final DeferredItem<BaseMinecartItem> AMBER_MINECART = MinecartItems.registerGeneric("amber_minecart", Types.AMBER, GenericMinecartEntity.Variant.AMBER);
    public static final DeferredItem<BaseMinecartItem> BEETLE_MINECART = MinecartItems.registerGeneric("beetle_minecart", Types.BEETLE, GenericMinecartEntity.Variant.BEETLE);
    public static final DeferredItem<BaseMinecartItem> MEOWMERE_MINECART = ITEMS.registerItem("meowmere", properties -> new BaseMinecartItem((Item.Properties)properties, ModRarity.RED, Types.MEOWMERE, MeowmereMinecartEntity::new));
    public static final DeferredItem<BaseMinecartItem> PARTY_WAGON = MinecartItems.registerGeneric("party_wagon", Types.PARTY, GenericMinecartEntity.Variant.PARTY);
    public static final DeferredItem<BaseMinecartItem> THE_DUTCHMAN = MinecartItems.registerGeneric("the_dutchman", Types.DUTCHMAN, GenericMinecartEntity.Variant.DUTCHMAN);
    public static final DeferredItem<BaseMinecartItem> STEAMPUNK_MINECART = MinecartItems.registerGeneric("steampunk_minecart", Types.STEAMPUNK, GenericMinecartEntity.Variant.STEAMPUNK);
    public static final DeferredItem<BaseMinecartItem> COFFIN_MINECART = MinecartItems.registerGeneric("coffin_minecart", Types.COFFIN, GenericMinecartEntity.Variant.COFFIN);
    public static final DeferredItem<BaseMinecartItem> DIGGING_MOLECART = ITEMS.registerItem("digging_molecart", properties -> new BaseMinecartItem((Item.Properties)properties, ModRarity.BLUE, Types.MOLECART, DiggingMolecartEntity::new));
    public static final DeferredItem<BaseMinecartItem> FART_KART = ITEMS.registerItem("fart_kart", properties -> new BaseMinecartItem((Item.Properties)properties, ModRarity.GREEN, Types.FART, (level, x, y, z, abilities) -> new GenericMinecartEntity((Level)level, x, y, z, abilities, GenericMinecartEntity.Variant.FART)));
    public static final DeferredItem<BaseMinecartItem> TERRA_FART_KART = ITEMS.registerItem("terra_fart_kart", properties -> new BaseMinecartItem((Item.Properties)properties, ModRarity.YELLOW, Types.TERRA_FART, (level, x, y, z, abilities) -> new GenericMinecartEntity((Level)level, x, y, z, abilities, GenericMinecartEntity.Variant.TERRA_FART)));

    private static DeferredItem<BaseMinecartItem> registerGeneric(String name, BaseMinecartEntity.Abilities<GenericMinecartEntity> abilities, GenericMinecartEntity.Variant variant) {
        return ITEMS.registerItem(name, properties -> new BaseMinecartItem((Item.Properties)properties, ModRarity.BLUE, abilities, (level, x, y, z, abilities1) -> new GenericMinecartEntity((Level)level, x, y, z, abilities1, variant)));
    }

    public static class Types {
        public static final BaseMinecartEntity.Abilities<BaseMinecartEntity> WOODEN = Types.register(ModEntities.WOODEN_MINECART, ResourceLocation.withDefaultNamespace((String)"air"), 0.308f, 0.16, 0.94);
        public static final BaseMinecartEntity.Abilities<MechanicalCartEntity> MECHANICAL = Types.register(ModEntities.MECHANICAL_CART, Confluence.asResource("mechanical_cart"), 1.23f, 2.5, 0.99);
        public static final BaseMinecartEntity.Abilities<GenericMinecartEntity> DESERT = Types.registerGeneric(Confluence.asResource("desert_minecart"));
        public static final BaseMinecartEntity.Abilities<MinecarpEntity> MINECARP = Types.registerGeneric(ModEntities.MINECARP, Confluence.asResource("minecarp"));
        public static final BaseMinecartEntity.Abilities<GenericMinecartEntity> BEE = Types.registerGeneric(Confluence.asResource("bee_minecart"));
        public static final BaseMinecartEntity.Abilities<GenericMinecartEntity> LADYBUG = Types.registerGeneric(Confluence.asResource("ladybug_minecart"));
        public static final BaseMinecartEntity.Abilities<GenericMinecartEntity> PIGRON = Types.registerGeneric(Confluence.asResource("pigron_minecart"));
        public static final BaseMinecartEntity.Abilities<GenericMinecartEntity> SUNFLOWER = Types.registerGeneric(Confluence.asResource("sunflower_minecart"));
        public static final BaseMinecartEntity.Abilities<DemonicHellcartEntity> DEMONIC = Types.registerGeneric(ModEntities.DEMONIC_HELLCART, Confluence.asResource("demonic_hellcart"));
        public static final BaseMinecartEntity.Abilities<GenericMinecartEntity> SHROOM = Types.registerGeneric(Confluence.asResource("shroom_minecart"));
        public static final BaseMinecartEntity.Abilities<GenericMinecartEntity> AMETHYST = Types.registerGeneric(Confluence.asResource("amethyst_minecart"));
        public static final BaseMinecartEntity.Abilities<GenericMinecartEntity> TOPAZ = Types.registerGeneric(Confluence.asResource("topaz_minecart"));
        public static final BaseMinecartEntity.Abilities<GenericMinecartEntity> SAPPHIRE = Types.registerGeneric(Confluence.asResource("sapphire_minecart"));
        public static final BaseMinecartEntity.Abilities<GenericMinecartEntity> JADE = Types.registerGeneric(Confluence.asResource("jade_minecart"));
        public static final BaseMinecartEntity.Abilities<GenericMinecartEntity> RUBY = Types.registerGeneric(Confluence.asResource("ruby_minecart"));
        public static final BaseMinecartEntity.Abilities<GenericMinecartEntity> DIAMOND = Types.registerGeneric(Confluence.asResource("diamond_minecart"));
        public static final BaseMinecartEntity.Abilities<GenericMinecartEntity> AMBER = Types.registerGeneric(Confluence.asResource("amber_minecart"));
        public static final BaseMinecartEntity.Abilities<GenericMinecartEntity> BEETLE = Types.registerGeneric(Confluence.asResource("beetle_minecart"));
        public static final BaseMinecartEntity.Abilities<MeowmereMinecartEntity> MEOWMERE = Types.registerGeneric(ModEntities.MEOWMERE_MINECART, Confluence.asResource("meowmere"));
        public static final BaseMinecartEntity.Abilities<GenericMinecartEntity> PARTY = Types.registerGeneric(Confluence.asResource("party_wagon"));
        public static final BaseMinecartEntity.Abilities<GenericMinecartEntity> DUTCHMAN = Types.registerGeneric(Confluence.asResource("the_dutchman"));
        public static final BaseMinecartEntity.Abilities<GenericMinecartEntity> STEAMPUNK = Types.registerGeneric(Confluence.asResource("steampunk_minecart"));
        public static final BaseMinecartEntity.Abilities<GenericMinecartEntity> COFFIN = Types.registerGeneric(Confluence.asResource("coffin_minecart"));
        public static final BaseMinecartEntity.Abilities<DiggingMolecartEntity> MOLECART = Types.register(ModEntities.DIGGING_MOLECART, Confluence.asResource("digging_molecart"), 0.185f, 0.15, 0.93);
        public static final BaseMinecartEntity.Abilities<GenericMinecartEntity> FART = Types.registerGeneric(Confluence.asResource("fart_kart"));
        public static final BaseMinecartEntity.Abilities<GenericMinecartEntity> TERRA_FART = Types.registerGeneric(Confluence.asResource("terra_fart_kart"));

        private static <E extends BaseMinecartEntity> BaseMinecartEntity.Abilities<E> register(Supplier<EntityType<E>> entityType, ResourceLocation item, float maxSpeed, double acceleration, double dragAir) {
            return new BaseMinecartEntity.Abilities<E>(entityType, item, maxSpeed, acceleration, dragAir);
        }

        private static <E extends BaseMinecartEntity> BaseMinecartEntity.Abilities<E> registerGeneric(Supplier<EntityType<E>> entityType, ResourceLocation item) {
            return new BaseMinecartEntity.Abilities<E>(entityType, item, 0.4f, 0.75, 0.95f);
        }

        private static BaseMinecartEntity.Abilities<GenericMinecartEntity> registerGeneric(ResourceLocation item) {
            return new BaseMinecartEntity.Abilities<GenericMinecartEntity>((Supplier<EntityType<GenericMinecartEntity>>)ModEntities.GENERIC_MINECART, item, 0.4f, 0.75, 0.95f);
        }
    }
}

