/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.init.item;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.mod.common.component.SwordProjectileComponent;
import org.confluence.mod.common.init.ModDataComponentTypes;
import org.confluence.mod.common.init.ModEffects;
import org.confluence.mod.common.init.ModEntities;
import org.confluence.mod.common.init.ModSoundEvents;
import org.confluence.mod.common.init.ModTiers;
import org.confluence.mod.common.init.item.ModItems;
import org.confluence.mod.common.item.sword.BaseSwordItem;
import org.confluence.mod.common.item.sword.GeoSwordItem;
import org.confluence.mod.common.item.sword.Phaseblade;
import org.confluence.mod.common.item.sword.SweetSword;
import org.confluence.mod.common.item.sword.legacy.SwordPrefabs;
import org.confluence.mod.integration.terra_entity.init.ModEffectStrategies;
import org.confluence.terraentity.api.entity.IGeneration;
import org.confluence.terraentity.data.component.EffectStrategyComponent;
import org.confluence.terraentity.init.TEEffectStrategies;
import org.confluence.terraentity.registries.generation.variant.ForwardGeneration;
import org.confluence.terraentity.registries.track.variant.SimpleTrack;

public class SwordItems {
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"confluence");
    public static final DeferredItem<BaseSwordItem> COPPER_SHORT_SWORD = SwordItems.register("copper_short_sword", ModTiers.COPPER, 2, 3.0f, ModRarity.WHITE, SwordPrefabs.SHORT_SWORD.get().addTooltip(p -> p.withColor(9980945)).addTooltip(p -> p.withColor(9980945)));
    public static final DeferredItem<BaseSwordItem> TIN_SHORT_SWORD = SwordItems.register("tin_short_sword", ModTiers.TIN, 2, 3.0f, SwordPrefabs.SHORT_SWORD.get());
    public static final DeferredItem<BaseSwordItem> IRON_SHORT_SWORD = SwordItems.register("iron_short_sword", ModTiers.IRON, 4, 3.0f, SwordPrefabs.SHORT_SWORD.get());
    public static final DeferredItem<BaseSwordItem> LEAD_SHORT_SWORD = SwordItems.register("lead_short_sword", ModTiers.LEAD, 4, 3.0f, SwordPrefabs.SHORT_SWORD.get());
    public static final DeferredItem<BaseSwordItem> SILVER_SHORT_SWORD = SwordItems.register("silver_short_sword", ModTiers.SILVER, 4, 3.0f, SwordPrefabs.SHORT_SWORD.get());
    public static final DeferredItem<BaseSwordItem> TUNGSTEN_SHORT_SWORD = SwordItems.register("tungsten_short_sword", ModTiers.TUNGSTEN, 5, 3.0f, SwordPrefabs.SHORT_SWORD.get());
    public static final DeferredItem<BaseSwordItem> GOLDEN_SHORT_SWORD = SwordItems.register("golden_short_sword", ModTiers.GOLD, 6, 3.0f, SwordPrefabs.SHORT_SWORD.get());
    public static final DeferredItem<BaseSwordItem> PLATINUM_SHORT_SWORD = SwordItems.register("platinum_short_sword", ModTiers.PLATINUM, 7, 3.0f, SwordPrefabs.SHORT_SWORD.get());
    public static final DeferredItem<BaseSwordItem> BREATHING_REED = SwordItems.register("breathing_reed", ModTiers.UNBREAKABLE, 2, 1.6f, ModRarity.BLUE, SwordPrefabs.SHORT_SWORD.get().addTooltip(p -> p.withColor(0xAAAAAA)));
    public static final DeferredItem<BaseSwordItem> GLADIUS = SwordItems.register("gladius", ModTiers.UNBREAKABLE, 6, 3.0f, SwordPrefabs.SHORT_SWORD.get());
    public static final DeferredItem<BaseSwordItem> UMBRELLA = SwordItems.register("umbrella", () -> new GeoSwordItem(ModTiers.UNBREAKABLE, ModRarity.BLUE, 2, 1.6f, SwordPrefabs.UMBRELLA_SWORD.get().addTooltip(p -> p.withColor(0xAAAAAA)).modifyProperties(p -> p.component(DataComponents.UNBREAKABLE, (Object)ModItems.UNBREAKABLE))));
    public static final DeferredItem<BaseSwordItem> TRAGIC_UMBRELLA = SwordItems.register("tragic_umbrella", () -> new GeoSwordItem(ModTiers.UNBREAKABLE, ModRarity.BLUE, 2, 1.6f, SwordPrefabs.UMBRELLA_SWORD.get().addTooltip(p -> p.withColor(0xAAAAAA)).modifyProperties(p -> p.component(DataComponents.UNBREAKABLE, (Object)ModItems.UNBREAKABLE))));
    public static final DeferredItem<BaseSwordItem> CACTUS_SWORD = SwordItems.register("cactus_sword", ModTiers.CACTUS, 5, 1.6f, SwordPrefabs.NORMAL_SWORD.get());
    public static final DeferredItem<BaseSwordItem> EBONWOOD_SWORD = SwordItems.register("ebonwood_sword", ModTiers.CACTUS, 6, 1.6f, SwordPrefabs.NORMAL_SWORD.get());
    public static final DeferredItem<BaseSwordItem> SHADEWOOD_SWORD = SwordItems.register("shadewood_sword", ModTiers.CACTUS, 6, 1.6f, SwordPrefabs.NORMAL_SWORD.get());
    public static final DeferredItem<BaseSwordItem> ASH_WOOD_SWORD = SwordItems.register("ash_wood_sword", ModTiers.CACTUS, 7, 1.6f, SwordPrefabs.NORMAL_SWORD.get());
    public static final DeferredItem<BaseSwordItem> PEARLWOOD_SWORD = SwordItems.register("pearlwood_sword", ModTiers.CACTUS, 8, 1.6f, SwordPrefabs.NORMAL_SWORD.get());
    public static final DeferredItem<BaseSwordItem> COPPER_BROADSWORD = SwordItems.register("copper_broadsword", ModTiers.COPPER, 5, 1.6f, SwordPrefabs.NORMAL_SWORD.get());
    public static final DeferredItem<BaseSwordItem> TIN_BROADSWORD = SwordItems.register("tin_broadsword", ModTiers.TIN, 5, 1.6f, SwordPrefabs.NORMAL_SWORD.get());
    public static final DeferredItem<BaseSwordItem> LEAD_BROADSWORD = SwordItems.register("lead_broadsword", ModTiers.LEAD, 6, 1.6f, SwordPrefabs.NORMAL_SWORD.get());
    public static final DeferredItem<BaseSwordItem> SILVER_BROADSWORD = SwordItems.register("silver_broadsword", ModTiers.SILVER, 6, 1.6f, SwordPrefabs.NORMAL_SWORD.get());
    public static final DeferredItem<BaseSwordItem> TUNGSTEN_BROADSWORD = SwordItems.register("tungsten_broadsword", ModTiers.TUNGSTEN, 6, 1.6f, SwordPrefabs.NORMAL_SWORD.get());
    public static final DeferredItem<BaseSwordItem> GOLDEN_BROADSWORD = SwordItems.register("golden_broadsword", ModTiers.GOLD, 7, 1.6f, SwordPrefabs.NORMAL_SWORD.get());
    public static final DeferredItem<BaseSwordItem> PLATINUM_BROADSWORD = SwordItems.register("platinum_broadsword", ModTiers.PLATINUM, 8, 1.6f, SwordPrefabs.NORMAL_SWORD.get());
    public static final DeferredItem<BaseSwordItem> MURAMASA = SwordItems.register("muramasa", ModTiers.UNBREAKABLE, 15, 3.0f, SwordPrefabs.BOARD_SWORD.apply(Float.valueOf(0.8f)).addAttributeModifier((Holder<Attribute>)Attributes.ENTITY_INTERACTION_RANGE, 1.5f, AttributeModifier.Operation.ADD_VALUE).addAttributeModifier((Holder<Attribute>)Attributes.ATTACK_KNOCKBACK, 0.2f, AttributeModifier.Operation.ADD_VALUE).hasImage());
    public static final DeferredItem<BaseSwordItem> COBALT_SWORD = SwordItems.register("cobalt_sword", ModTiers.UNBREAKABLE, 25, 2.4f, ModRarity.LIGHT_RED, SwordPrefabs.BOARD_SWORD.apply(Float.valueOf(0.8f)).addAttributeModifier((Holder<Attribute>)Attributes.ENTITY_INTERACTION_RANGE, 4.0f, AttributeModifier.Operation.ADD_VALUE).hasImage());
    public static final DeferredItem<BaseSwordItem> PALLADIUM_SWORD = SwordItems.register("palladium_sword", ModTiers.UNBREAKABLE, 29, 2.6f, ModRarity.LIGHT_RED, SwordPrefabs.BOARD_SWORD.apply(Float.valueOf(0.8f)).addAttributeModifier((Holder<Attribute>)Attributes.ENTITY_INTERACTION_RANGE, 4.0f, AttributeModifier.Operation.ADD_VALUE).hasImage());
    public static final DeferredItem<BaseSwordItem> MYTHRIL_SWORD = SwordItems.register("mythril_sword", ModTiers.UNBREAKABLE, 30, 2.6f, ModRarity.LIGHT_RED, SwordPrefabs.BOARD_SWORD.apply(Float.valueOf(0.8f)).addAttributeModifier((Holder<Attribute>)Attributes.ENTITY_INTERACTION_RANGE, 4.0f, AttributeModifier.Operation.ADD_VALUE).hasImage());
    public static final DeferredItem<BaseSwordItem> ORICHALCUM_SWORD = SwordItems.register("orichalcum_sword", ModTiers.UNBREAKABLE, 34, 2.4f, ModRarity.LIGHT_RED, SwordPrefabs.BOARD_SWORD.apply(Float.valueOf(0.8f)).addAttributeModifier((Holder<Attribute>)Attributes.ENTITY_INTERACTION_RANGE, 4.0f, AttributeModifier.Operation.ADD_VALUE).hasImage());
    public static final DeferredItem<BaseSwordItem> ADAMANTITE_SWORD = SwordItems.register("adamantite_sword", ModTiers.UNBREAKABLE, 36, 2.4f, ModRarity.LIGHT_RED, SwordPrefabs.BOARD_SWORD.apply(Float.valueOf(0.8f)).addAttributeModifier((Holder<Attribute>)Attributes.ENTITY_INTERACTION_RANGE, 4.0f, AttributeModifier.Operation.ADD_VALUE).hasImage());
    public static final DeferredItem<BaseSwordItem> TITANIUM_SWORD = SwordItems.register("titanium_sword", ModTiers.UNBREAKABLE, 36, 2.4f, ModRarity.LIGHT_RED, SwordPrefabs.BOARD_SWORD.apply(Float.valueOf(0.8f)).addAttributeModifier((Holder<Attribute>)Attributes.ENTITY_INTERACTION_RANGE, 4.0f, AttributeModifier.Operation.ADD_VALUE).hasImage());
    public static final DeferredItem<BaseSwordItem> FAKE_SWORD = SwordItems.register("fake_sword", ModTiers.CANDY_CANE, 3, 1.6f, ModRarity.GRAY, SwordPrefabs.NORMAL_SWORD.get());
    public static final DeferredItem<BaseSwordItem> CANDY_CANE_SWORD = SwordItems.register("candy_cane_sword", ModTiers.CANDY_CANE, 5, 2.4f, SwordPrefabs.BOARD_SWORD.apply(Float.valueOf(0.5f)).hasImage());
    public static final DeferredItem<BaseSwordItem> FALCON_BLADE = SwordItems.register("falcon_blade", ModTiers.UNBREAKABLE, 6, 2.55f, ModRarity.BLUE, SwordPrefabs.BOARD_SWORD.apply(Float.valueOf(0.5f)));
    public static final DeferredItem<BaseSwordItem> ZOMBIE_ARM = SwordItems.register("zombie_arm", ModTiers.UNBREAKABLE, 5, 2.4f, SwordPrefabs.BOARD_SWORD.apply(Float.valueOf(0.5f)));
    public static final DeferredItem<BaseSwordItem> MANDIBLE_BLADE = SwordItems.register("mandible_blade", ModTiers.UNBREAKABLE, 6, 2.4f, SwordPrefabs.BOARD_SWORD.apply(Float.valueOf(0.8f)));
    public static final DeferredItem<BaseSwordItem> BONE_SWORD = SwordItems.register("bone_sword", ModTiers.UNBREAKABLE, 7, 2.4f, ModRarity.ORANGE, SwordPrefabs.BOARD_SWORD.apply(Float.valueOf(0.8f)).hasImage());
    public static final DeferredItem<BaseSwordItem> PURPLE_CLUBBERFISH = SwordItems.register("purple_clubberfish", ModTiers.UNBREAKABLE, 15, 0.5f, SwordPrefabs.BOARD_SWORD.apply(Float.valueOf(0.8f)).addAttributeModifier((Holder<Attribute>)Attributes.ENTITY_INTERACTION_RANGE, 2.0f, AttributeModifier.Operation.ADD_VALUE).hasImage());
    public static final DeferredItem<BaseSwordItem> STYLISH_SCISSORS = SwordItems.register("stylish_scissors", ModTiers.UNBREAKABLE, 5, 2.2f, ModRarity.GREEN, SwordPrefabs.BOARD_SWORD.apply(Float.valueOf(0.8f)));
    public static final DeferredItem<BaseSwordItem> EXOTIC_SCIMITAR = SwordItems.register("exotic_scimitar", ModTiers.UNBREAKABLE, 7, 2.3f, ModRarity.GREEN, SwordPrefabs.BOARD_SWORD.apply(Float.valueOf(0.8f)));
    public static final DeferredItem<BaseSwordItem> KATANA = SwordItems.register("katana", ModTiers.UNBREAKABLE, 6, 3.7f, ModRarity.BLUE, SwordPrefabs.BOARD_SWORD.apply(Float.valueOf(0.8f)));
    public static final DeferredItem<BaseSwordItem> TERRAGRIM = SwordItems.register("terragrim", ModTiers.UNBREAKABLE, 1, 6.0f, ModRarity.ORANGE, SwordPrefabs.BOARD_SWORD.apply(Float.valueOf(0.0f)).addAttributeModifier((Holder<Attribute>)Attributes.ENTITY_INTERACTION_RANGE, -1.8f, AttributeModifier.Operation.ADD_VALUE));
    public static final DeferredItem<BaseSwordItem> BREAKER_BLADE = SwordItems.register("breaker_blade", ModTiers.UNBREAKABLE, 37, 1.0f, ModRarity.LIGHT_RED, SwordPrefabs.BOARD_SWORD.apply(Float.valueOf(0.8f)).hasImage().addAttributeModifier((Holder<Attribute>)Attributes.ENTITY_INTERACTION_RANGE, 9.0f, AttributeModifier.Operation.ADD_VALUE).addAttributeModifier((Holder<Attribute>)Attributes.ATTACK_KNOCKBACK, 0.8f, AttributeModifier.Operation.ADD_VALUE));
    public static final DeferredItem<BaseSwordItem> LIGHTS_BANE = SwordItems.register("lights_bane", ModTiers.UNBREAKABLE, 11, 3.0f, ModRarity.BLUE, SwordPrefabs.withSpecialSweep(0.8f, SwordPrefabs.EFFECT_SWORD.apply(ModEffectStrategies.Components.LIGHTS_BANE_EFFECT.get()).hasImage()));
    public static final DeferredItem<BaseSwordItem> BLOOD_BUTCHERER = SwordItems.register("blood_butcherer", ModTiers.UNBREAKABLE, 14, 1.3f, ModRarity.BLUE, SwordPrefabs.withSpecialSweep(0.8f, SwordPrefabs.EFFECT_SWORD.apply(ModEffectStrategies.Components.BLOOD_BUTCHERED_EFFECT.get()).hasImage()));
    public static final DeferredItem<BaseSwordItem> VOLCANO = SwordItems.register("volcano", ModTiers.UNBREAKABLE, 25, 1.2f, ModRarity.ORANGE, SwordPrefabs.withSpecialSweep(0.8f, SwordPrefabs.EFFECT_SWORD.apply((EffectStrategyComponent)TEEffectStrategies.Components.HELL_FIRE_EFFECT.get()).hasImage().addAttributeModifier((Holder<Attribute>)Attributes.ENTITY_INTERACTION_RANGE, 2.0f, AttributeModifier.Operation.ADD_VALUE).addAttributeModifier((Holder<Attribute>)Attributes.ATTACK_KNOCKBACK, 0.5f, AttributeModifier.Operation.ADD_VALUE)));
    public static final DeferredItem<BaseSwordItem> BAT_BAT = SwordItems.register("bat_bat", ModTiers.UNBREAKABLE, 21, 0.6f, ModRarity.ORANGE, SwordPrefabs.withSpecialSweep(0.8f, SwordPrefabs.EFFECT_SWORD.apply(ModEffectStrategies.Components.BAT_FANG_EFFECT.get()).hasImage().addAttributeModifier((Holder<Attribute>)Attributes.ENTITY_INTERACTION_RANGE, 2.0f, AttributeModifier.Operation.ADD_VALUE)));
    public static final DeferredItem<BaseSwordItem> TENTACLE_MACE = SwordItems.register("tentacle_mace", ModTiers.UNBREAKABLE, 13, 2.2f, ModRarity.GREEN, SwordPrefabs.withSpecialSweep(0.8f, SwordPrefabs.EFFECT_SWORD.apply(ModEffectStrategies.Components.TENTACLE_SPIKES_EFFECT.get())));
    public static final DeferredItem<BaseSwordItem> BEE_KEEPER = SwordItems.register("bee_keeper", ModTiers.UNBREAKABLE, 18, 1.6f, ModRarity.GREEN, SwordPrefabs.withSpecialSweep(0.8f, SwordPrefabs.EFFECT_SWORD.apply(ModEffectStrategies.Components.BEE_KEEPER_EFFECT.get()).addTooltip(2).hasImage()));
    public static final DeferredItem<BaseSwordItem> ICE_BLADE = SwordItems.register("ice_blade", ModTiers.UNBREAKABLE, 10, 3.0f, ModRarity.BLUE, SwordPrefabs.withSpecialSweep(0.8f, SwordPrefabs.PROJ_SWORD.apply(SwordProjectileComponent.ICE_PROJ).hasImage()));
    public static final DeferredItem<BaseSwordItem> STARFURY = SwordItems.register("starfury", ModTiers.UNBREAKABLE, 14, 2.4f, ModRarity.GREEN, SwordPrefabs.withSpecialSweep(0.8f, SwordPrefabs.PROJ_SWORD.apply(SwordProjectileComponent.STAR_FURY_PROJ).addTooltip(p -> p.withColor(14958985)).addTooltip(p -> p.withColor(14958985))));
    public static final DeferredItem<BaseSwordItem> ENCHANTED_SWORD = SwordItems.register("enchanted_sword", ModTiers.UNBREAKABLE, 12, 2.4f, ModRarity.ORANGE, SwordPrefabs.withSpecialSweep(0.8f, SwordPrefabs.PROJ_SWORD.apply(SwordProjectileComponent.ENCHANTED_SWORD_PROJ).addTooltip(p -> p.withColor(4282084)).addTooltip(p -> p.withColor(4282084))));
    public static final DeferredItem<BaseSwordItem> BLADE_OF_GRASS = SwordItems.register("blade_of_grass", ModTiers.UNBREAKABLE, 11, 2.4f, ModRarity.GREEN, SwordPrefabs.withSpecialSweep(0.8f, SwordPrefabs.PROJ_SWORD.apply(SwordProjectileComponent.GRASS_PROJ).hasImage()));
    public static final DeferredItem<BaseSwordItem> NIGHTS_EDGE = SwordItems.register("nights_edge", ModTiers.UNBREAKABLE, 25, 2.5f, ModRarity.GREEN, SwordPrefabs.PROJ_SWORD.apply(SwordProjectileComponent.NIGHT_PROJ).hasImage());
    public static final DeferredItem<BaseSwordItem> RED_PHASEBLADE = SwordItems.register("red_phaseblade", () -> new Phaseblade(ModTiers.METEOR, ModRarity.BLUE, 10, 2.0f, "red"));
    public static final DeferredItem<BaseSwordItem> ORANGE_PHASEBLADE = SwordItems.register("orange_phaseblade", () -> new Phaseblade(ModTiers.METEOR, ModRarity.BLUE, 10, 2.0f, "orange"));
    public static final DeferredItem<BaseSwordItem> YELLOW_PHASEBLADE = SwordItems.register("yellow_phaseblade", () -> new Phaseblade(ModTiers.METEOR, ModRarity.BLUE, 10, 2.0f, "yellow"));
    public static final DeferredItem<BaseSwordItem> GREEN_PHASEBLADE = SwordItems.register("green_phaseblade", () -> new Phaseblade(ModTiers.METEOR, ModRarity.BLUE, 10, 2.0f, "green"));
    public static final DeferredItem<BaseSwordItem> BLUE_PHASEBLADE = SwordItems.register("blue_phaseblade", () -> new Phaseblade(ModTiers.METEOR, ModRarity.BLUE, 10, 2.0f, "blue"));
    public static final DeferredItem<BaseSwordItem> PURPLE_PHASEBLADE = SwordItems.register("purple_phaseblade", () -> new Phaseblade(ModTiers.METEOR, ModRarity.BLUE, 10, 2.0f, "purple"));
    public static final DeferredItem<BaseSwordItem> WHITE_PHASEBLADE = SwordItems.register("white_phaseblade", () -> new Phaseblade(ModTiers.METEOR, ModRarity.BLUE, 10, 2.0f, "white"));
    public static final DeferredItem<BaseSwordItem> CROWBAR = SwordItems.register("crowbar", ModTiers.UNBREAKABLE, 18, 3.0f, ModRarity.MASTER, SwordPrefabs.BOARD_SWORD.apply(Float.valueOf(1.0f)).addAttributeModifier((Holder<Attribute>)Attributes.ENTITY_INTERACTION_RANGE, -1.0f, AttributeModifier.Operation.ADD_VALUE));
    public static final DeferredItem<BaseSwordItem> DEVELOPER_SWORD = SwordItems.register("developer_sword", ModTiers.UNBREAKABLE, 9999, 9999.0f, ModRarity.MASTER, SwordPrefabs.BOARD_SWORD.apply(Float.valueOf(1.0f)).addAttributeModifier((Holder<Attribute>)Attributes.ENTITY_INTERACTION_RANGE, 7.0f, AttributeModifier.Operation.ADD_VALUE).modifyProperties(p -> p.component(ModDataComponentTypes.SWORD_PROJECTILE, (Object)new SwordProjectileComponent(1.0f, 1.0f, 1.0f, 50, 0.05f, 20, ModSoundEvents.REGULAR_STAFF_SHOOT_2.getId(), ModEntities.ENCHANTED_SWORD_PROJECTILE.getId(), Optional.of(new SimpleTrack(1.5707963705062866, 0.5, (double)0.1f, Optional.empty(), 0.1)), (IGeneration)ForwardGeneration.of((float)0.0f, (float)0.0f), Optional.empty()))));
    public static final DeferredItem<BaseSwordItem> BROKEN_SWEET_SWORD = SwordItems.register("broken_sweet_sword", () -> new SweetSword(ModTiers.UNBREAKABLE, ModRarity.EXPERT, 2, 1.0f, new BaseSwordItem.ModifierBuilder()));
    public static final DeferredItem<BaseSwordItem> SWEET_SWORD = SwordItems.register("sweet_sword", () -> new SweetSword(ModTiers.UNBREAKABLE, ModRarity.EXPERT, 6, 2.0f, new BaseSwordItem.ModifierBuilder().addTooltip(p -> p.withColor(14958985)).modifyProperties(p -> p.food(new FoodProperties(1, 1.0f, false, 2.0f, Optional.of(((BaseSwordItem)((Object)((Object)((Object)BROKEN_SWEET_SWORD.get())))).getDefaultInstance()), List.of(new FoodProperties.PossibleEffect(() -> new MobEffectInstance(ModEffects.DELICIOUS, 200), 1.0f)))))));

    public static DeferredItem<BaseSwordItem> register(String name, Supplier<BaseSwordItem> supplier) {
        return ITEMS.register(name, supplier);
    }

    public static DeferredItem<BaseSwordItem> register(String name, Tier tier, int rawDamage, float rawSpeed, BaseSwordItem.ModifierBuilder modifierBuilder) {
        return SwordItems.register(name, tier, rawDamage, rawSpeed, ModRarity.WHITE, modifierBuilder);
    }

    public static DeferredItem<BaseSwordItem> register(String name, Tier tier, int rawDamage, float rawSpeed, ModRarity rarity, BaseSwordItem.ModifierBuilder modifierBuilder) {
        return SwordItems.register(name, () -> {
            if (tier == ModTiers.UNBREAKABLE) {
                modifierBuilder.modifyProperties(p -> p.component(DataComponents.UNBREAKABLE, (Object)ModItems.UNBREAKABLE));
            }
            return new BaseSwordItem(tier, rarity, rawDamage, rawSpeed, modifierBuilder);
        });
    }

    public static void acceptTag(IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item> tag) {
        ITEMS.getEntries().forEach(item -> tag.add((Object)((Item)item.get())));
    }
}

