/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.bow;

import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.confluence.lib.ConfluenceMagicLib;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.mod.common.entity.projectile.range.arrow.BaseArrowEntity;
import org.confluence.mod.common.init.ModEntities;
import org.confluence.mod.common.item.bow.TerraBowItem;
import org.confluence.terraentity.registries.hit_effect.IEffectStrategy;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BaseArrowItem
extends ArrowItem {
    @Nullable
    protected final BaseArrowEntity.Factory modifier;
    protected BaseArrowEntity.Builder attributes;

    public BaseArrowItem(ModRarity rarity) {
        this(rarity, null);
    }

    public BaseArrowItem(ModRarity rarity, @Nullable BaseArrowEntity.Factory modifier) {
        super(new Item.Properties().component(ConfluenceMagicLib.MOD_RARITY, (Object)rarity));
        this.modifier = modifier;
        if (modifier != null) {
            this.attributes = modifier.attr.get();
        }
    }

    public @Nullable BaseArrowEntity.Factory getModifier() {
        return this.modifier;
    }

    public AbstractArrow createArrow(Level level, ItemStack stack, LivingEntity shooter, @Nullable ItemStack weapon) {
        Item item = stack.getItem();
        if (item instanceof BaseArrowItem) {
            BaseArrowItem arrowItem = (BaseArrowItem)item;
            if (arrowItem.modifier != null) {
                BaseArrowEntity arrow;
                Item item2;
                if (weapon != null && (item2 = weapon.getItem()) instanceof TerraBowItem) {
                    TerraBowItem item3 = (TerraBowItem)item2;
                    arrow = new BaseArrowEntity((EntityType<? extends AbstractArrow>)((EntityType)ModEntities.ARROW_PROJECTILE.get()), shooter, this.getDefaultInstance(), weapon, this, item3.modifyArrowBuilder);
                } else {
                    arrow = new BaseArrowEntity((EntityType<? extends AbstractArrow>)((EntityType)ModEntities.ARROW_PROJECTILE.get()), shooter, this.getDefaultInstance(), weapon, this);
                }
                return arrow;
            }
        }
        return super.createArrow(level, stack, shooter, weapon);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (this.attributes != null) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.item.confluence.additional_attack_damage").append(": +").append(String.format("%.1f", Float.valueOf(this.attributes.base_damage))).withColor(65280));
            if (this.attributes.onHitEffects != null) {
                IEffectStrategy.appendDescriptions(tooltipComponents, this.attributes.onHitEffects, (Component)Component.translatable((String)"tooltip.item.confluence.on_hit_effects").append(": ").withColor(0xFF00FF));
            }
            if ((this.attributes.getType() & 2) != 0) {
                tooltipComponents.add((Component)Component.translatable((String)"tooltip.item.confluence.no_gravity"));
            }
            if ((this.attributes.getType() & 8) != 0) {
                tooltipComponents.add((Component)Component.translatable((String)"tooltip.item.confluence.cause_fire"));
            }
            if ((this.attributes.getType() & 1) != 0) {
                tooltipComponents.add((Component)Component.translatable((String)"tooltip.item.confluence.can_penetrate"));
            }
        }
    }
}

