/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.bow;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.mod.common.item.bow.TerraBowItem;
import org.confluence.terraentity.api.entity.IGeneration;
import org.confluence.terraentity.registries.generation.variant.AboveFallenGeneration;
import org.jetbrains.annotations.NotNull;

public class DaedalusStormbow
extends TerraBowItem {
    private final IGeneration generation = new AboveFallenGeneration(30.0f, 60.0f, 25.0f, 2.0f, 25.0f, 5.0f);

    public DaedalusStormbow(float baseDamage, ModRarity rarity) {
        super(baseDamage, new TerraBowItem.Builder().setRarity(rarity));
    }

    @Override
    public void onUseTick(@NotNull Level level, @NotNull LivingEntity owner, @NotNull ItemStack weapon, int remainingUseDuration) {
        super.onUseTick(level, owner, weapon, remainingUseDuration);
        if (!level.isClientSide && owner instanceof Player) {
            Player player = (Player)owner;
            if (remainingUseDuration % 4 == 0) {
                this.generation.genProjectile((LivingEntity)player, weapon, 2.0f, () -> {
                    ItemStack itemstack = owner.getProjectile(weapon);
                    if (itemstack.isEmpty()) {
                        return null;
                    }
                    ItemStack ammo = itemstack.copyWithCount(1);
                    itemstack.shrink(1);
                    return this.createProjectile(owner.level(), owner, weapon, ammo, true);
                });
            }
        }
    }

    @Override
    protected void shoot(@NotNull ServerLevel level, @NotNull LivingEntity shooter, @NotNull InteractionHand hand, @NotNull ItemStack weapon, List<ItemStack> projectileItems, float velocity, float inaccuracy, boolean isCrit, @Nullable LivingEntity target) {
    }
}

