/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.bow;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import org.confluence.lib.ConfluenceMagicLib;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.mod.common.entity.projectile.range.arrow.BaseArrowEntity;
import org.confluence.mod.common.init.ModSoundEvents;
import org.confluence.mod.common.init.ModTags;
import org.confluence.mod.common.item.bow.BaseArrowItem;
import org.confluence.mod.common.item.bow.ShortBowItem;
import org.confluence.mod.util.ModUtils;
import org.confluence.terraentity.attachment.WeaponStorage;
import org.confluence.terraentity.data.component.EffectStrategyComponent;
import org.confluence.terraentity.init.TEDataComponentTypes;
import org.confluence.terraentity.registries.hit_effect.IEffectStrategy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

public class TerraBowItem
extends BowItem {
    public float baseDamage;
    public BaseArrowEntity.Builder arrowModifier;
    public Builder modifyArrowBuilder;

    public TerraBowItem(float baseDamage, Builder builder) {
        super(builder.buildProperties(new Item.Properties().stacksTo(1)));
        this.baseDamage = baseDamage;
        this.arrowModifier = new BaseArrowEntity.Builder();
        builder.modifyArrowBuilder.forEach(m -> m.accept(this.arrowModifier));
        this.modifyArrowBuilder = builder;
    }

    public boolean supportsEnchantment(@NotNull ItemStack stack, @NotNull Holder<Enchantment> enchantment) {
        return ModUtils.supportsEnchantment(stack, enchantment);
    }

    @NotNull
    public AbstractArrow customArrow(@NotNull AbstractArrow arrow, @NotNull ItemStack projectileStack, @NotNull ItemStack weaponStack) {
        int multiShoot = this.modifyArrowBuilder.multiShoot;
        if (this.modifyArrowBuilder.canMultiShoot.test(projectileStack)) {
            float damage = this.baseDamage / (float)multiShoot;
            arrow.setBaseDamage((double)damage);
        } else {
            arrow.setBaseDamage((double)this.baseDamage);
        }
        return arrow;
    }

    public void releaseUsing(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity entity, int timeLeft) {
        super.releaseUsing(stack, level, entity, timeLeft);
        if (stack.is(ModTags.Items.FAST_BOW) && entity instanceof Player) {
            Player p = (Player)entity;
            p.getCooldowns().addCooldown((Item)this, 5);
            ItemStack off = p.getOffhandItem();
            if (off.getItem() instanceof BowItem) {
                p.getCooldowns().addCooldown(off.getItem(), 5);
            }
        }
    }

    protected void shoot(@NotNull ServerLevel level, @NotNull LivingEntity shooter, @NotNull InteractionHand hand, @NotNull ItemStack weapon, List<ItemStack> projectileItems, float velocity, float inaccuracy, boolean isCrit, @Nullable LivingEntity target) {
        float f = EnchantmentHelper.processProjectileSpread((ServerLevel)level, (ItemStack)weapon, (Entity)shooter, (float)0.0f);
        float f1 = projectileItems.size() == 1 ? 0.0f : 2.0f * f / (float)(projectileItems.size() - 1);
        float f2 = (float)((projectileItems.size() - 1) % 2) * f1 / 2.0f;
        float f3 = 1.0f;
        for (int i = 0; i < projectileItems.size(); ++i) {
            ItemStack itemstack = projectileItems.get(i);
            if (itemstack.isEmpty()) continue;
            float f4 = f2 + f3 * (float)((i + 1) / 2) * f1;
            f3 = -f3;
            int count = this.modifyArrowBuilder.multiShoot;
            if (!this.modifyArrowBuilder.canMultiShoot.test(itemstack)) {
                count = 1;
            }
            for (int k = 0; k < count; ++k) {
                Projectile projectile = this.createProjectile((Level)level, shooter, weapon, itemstack, isCrit);
                this.shootProjectile(shooter, projectile, i, velocity, inaccuracy + this.modifyArrowBuilder.inaccuracy, f4 + 0.0f, target);
                if (this.modifyArrowBuilder.multiShootOffset != null) {
                    Vec3 offset = this.modifyArrowBuilder.multiShootOffset.apply(k, count);
                    Vec3 initDirection = projectile.getDeltaMovement();
                    float yaw = (float)(-Math.atan2(initDirection.z, initDirection.x));
                    float pitch = (float)Math.atan2(initDirection.y, Math.sqrt(initDirection.x * initDirection.x + initDirection.z * initDirection.z));
                    Quaternionf q = new Quaternionf().rotateY(yaw).rotateZ(pitch);
                    offset = new Vec3(q.transform(offset.toVector3f()));
                    projectile.setPos(projectile.position().add(offset));
                }
                if (projectile instanceof AbstractArrow) {
                    AbstractArrow abstractArrow = (AbstractArrow)projectile;
                    if (k > 0) {
                        abstractArrow.pickup = AbstractArrow.Pickup.DISALLOWED;
                    }
                    ShortBowItem.applyToArrow(weapon, abstractArrow);
                    if (abstractArrow instanceof BaseArrowEntity) {
                        BaseArrowEntity terraArrow = (BaseArrowEntity)abstractArrow;
                        if (count > 1 && (terraArrow.modify.getType() & 4) == 0) {
                            terraArrow.modify.setAutoDiscard(100);
                        }
                        WeaponStorage data = WeaponStorage.of((IAttachmentHolder)shooter);
                        if (data.bowFullPull) {
                            terraArrow.fullPull = true;
                            data.bowFullPull = false;
                        }
                    }
                }
                level.addFreshEntity((Entity)projectile);
            }
            weapon.hurtAndBreak(this.getDurabilityUse(itemstack), shooter, LivingEntity.getSlotForHand((InteractionHand)hand));
            if (weapon.isEmpty()) break;
        }
    }

    public void onUseTick(@NotNull Level level, @NotNull LivingEntity entity, @NotNull ItemStack stack, int remainingUseDuration) {
        if (this.arrowModifier.fullPullHitEffects != null) {
            float f = this.getUseDuration(stack, entity) - remainingUseDuration;
            if (f < 16.0f) {
                WeaponStorage.of((IAttachmentHolder)entity).bowFullPull = false;
            } else if (f == 16.0f) {
                WeaponStorage.of((IAttachmentHolder)entity).bowFullPull = true;
                if (level.isClientSide) {
                    entity.playSound((SoundEvent)ModSoundEvents.BOW_COOLDOWN_RECOVERY.get());
                }
            }
        }
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        EffectStrategyComponent fullPullHitEffect;
        EffectStrategyComponent hitEffect;
        tooltipComponents.add((Component)Component.translatable((String)"attribute.name.generic.attack_damage").append(": ").append(String.format("%.1f", Float.valueOf(this.baseDamage))).withColor(65280));
        if (this.modifyArrowBuilder.multiShoot > 1) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.item.confluence.max_count").append(": ").append(String.format("%d", this.modifyArrowBuilder.multiShoot)).withColor(65280));
        }
        if ((hitEffect = (EffectStrategyComponent)stack.get(TEDataComponentTypes.EFFECT_STRATEGY)) != null) {
            IEffectStrategy.appendDescription(tooltipComponents, (List)hitEffect.effects(), (Component)Component.translatable((String)"tooltip.item.confluence.on_hit_effects").append(": ").withColor(0xFF00FF));
        }
        if ((fullPullHitEffect = (EffectStrategyComponent)stack.get(TEDataComponentTypes.BOW_FULL_CHARGE_EFFECT_STRATEGY)) != null) {
            IEffectStrategy.appendDescription(tooltipComponents, (List)fullPullHitEffect.effects(), (Component)Component.translatable((String)"tooltip.item.confluence.bow_full_pull_on_hit_effects").append(": ").withColor(0xFF00FF));
        }
        if (this.modifyArrowBuilder.entityTransform != null) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.item.confluence.arrow_transform").append(": ").append(this.modifyArrowBuilder.entityTransform.type.getDescription()).withColor(15839476));
        } else {
            BaseArrowItem transformArrow = this.arrowModifier.getTransformArrow();
            if (transformArrow != null) {
                tooltipComponents.add((Component)Component.translatable((String)"tooltip.item.confluence.arrow_transform").append(": ").append((Component)Component.translatable((String)transformArrow.getDescriptionId())).withColor(15839476));
            }
        }
    }

    public boolean isEnchantable(@NotNull ItemStack stack) {
        return true;
    }

    public boolean shouldCauseReequipAnimation(@NotNull ItemStack oldStack, @NotNull ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public static float getFastBowPowerForTime(int pCharge) {
        float f = (float)pCharge / 20.0f;
        f = (f * f + f * 2.0f) / 3.0f * 0.5f + 0.5f;
        f = Math.min(f, 1.0f);
        return f;
    }

    public static class Builder {
        List<Function<Item.Properties, Item.Properties>> modifyProperties = new ArrayList<Function<Item.Properties, Item.Properties>>();
        List<Consumer<BaseArrowEntity.Builder>> modifyArrowBuilder = new ArrayList<Consumer<BaseArrowEntity.Builder>>();
        int multiShoot = 1;
        Predicate<ItemStack> canMultiShoot = ammo -> false;
        BiFunction<Integer, Integer, Vec3> multiShootOffset;
        public EntityTransform entityTransform;
        float inaccuracy;

        public void applyModifiers(BaseArrowEntity.Builder modifyArrow) {
            this.modifyArrowBuilder.forEach(m -> m.accept(modifyArrow));
        }

        public Builder setEntityTransform(EntityTransform transformArrow) {
            this.entityTransform = transformArrow;
            return this;
        }

        public Builder setMultiShoot(int multiShoot) {
            this.multiShoot = multiShoot;
            return this;
        }

        public Builder setMultiShoot(int multiShoot, BiFunction<Integer, Integer, Vec3> multiShootOffset) {
            this.multiShoot = multiShoot;
            this.multiShootOffset = multiShootOffset;
            return this;
        }

        public Builder setCanMultiShoot(Predicate<ItemStack> canMultiShoot) {
            this.canMultiShoot = canMultiShoot;
            return this;
        }

        public Builder setDuration(int duration) {
            this.modifyProperties.add(p -> p.durability(duration));
            return this;
        }

        public Builder setOnHitEffect(EffectStrategyComponent component) {
            this.modifyProperties.add(p -> p.component(TEDataComponentTypes.EFFECT_STRATEGY, (Object)component));
            this.addModifyArrowBuilder(m -> m.addOnHitEffect(component));
            return this;
        }

        public Builder setFullPullHitEffect(EffectStrategyComponent component) {
            this.modifyProperties.add(p -> p.component(TEDataComponentTypes.BOW_FULL_CHARGE_EFFECT_STRATEGY, (Object)component));
            this.addModifyArrowBuilder(m -> m.addFullPullHitEffect(component));
            return this;
        }

        public Builder setArrowTransform(BaseArrowItem arrow) {
            this.modifyArrowBuilder.add(m -> m.setTransformArrow(arrow));
            return this;
        }

        public Builder setUnBreakable() {
            this.modifyProperties.add(p -> p.component(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true)));
            return this;
        }

        public Builder setRarity(ModRarity rarity) {
            this.modifyProperties.add(p -> p.component(ConfluenceMagicLib.MOD_RARITY, (Object)rarity));
            return this;
        }

        public Builder addModifyArrowBuilder(Consumer<BaseArrowEntity.Builder> modifyArrowBuilder) {
            this.modifyArrowBuilder.add(modifyArrowBuilder);
            return this;
        }

        public Builder setInaccuracy(float inaccuracy) {
            this.inaccuracy = inaccuracy;
            return this;
        }

        public Item.Properties buildProperties(Item.Properties properties) {
            for (Function<Item.Properties, Item.Properties> f : this.modifyProperties) {
                properties = f.apply(properties);
            }
            return properties;
        }
    }

    public record EntityTransform(EntityType<? extends AbstractArrow> type, ArrowFactory factory) {
        public static EntityTransform create(EntityType<? extends AbstractArrow> type, ArrowFactory factory) {
            return new EntityTransform(type, factory);
        }
    }

    @FunctionalInterface
    public static interface ArrowFactory {
        public BaseArrowEntity create(EntityType<? extends AbstractArrow> var1, LivingEntity var2, ItemStack var3, ItemStack var4, @Nullable BaseArrowItem var5, Builder var6);
    }
}

