/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.common;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.Tags;
import org.confluence.lib.ConfluenceMagicLib;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.mod.common.init.item.ModItems;
import org.confluence.mod.common.item.AltImageComponent;
import org.confluence.mod.util.ModUtils;
import org.jetbrains.annotations.Nullable;

public class BaseAxeItem
extends AxeItem {
    @Nullable
    private TooltipComponent component;
    private boolean hasImage;

    public BaseAxeItem(Tier tier, float rawDamage, float rawSpeed, ModRarity rarity) {
        this(tier, rawDamage, rawSpeed, new Item.Properties(), rarity);
    }

    public BaseAxeItem(Tier tier, float rawDamage, float rawSpeed, Item.Properties properties, ModRarity rarity) {
        super(tier, properties.component(ConfluenceMagicLib.MOD_RARITY, (Object)rarity).component(DataComponents.ATTRIBUTE_MODIFIERS, (Object)BaseAxeItem.createAttributes((Tier)tier, (float)(rawDamage - tier.getAttackDamageBonus() - 1.0f), (float)(rawSpeed - 4.0f))));
    }

    public BaseAxeItem(Tier tier, float rawDamage, float rawSpeed, Item.Properties properties, Consumer<ItemAttributeModifiers.Builder> consumer, ModRarity rarity) {
        super(tier, properties.component(ConfluenceMagicLib.MOD_RARITY, (Object)rarity).component(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ModItems.createAttributes(tier, rawDamage - tier.getAttackDamageBonus() - 1.0f, rawSpeed - 4.0f, consumer)));
    }

    public BaseAxeItem hasImage() {
        this.hasImage = true;
        return this;
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        if (this.component == null && this.hasImage) {
            this.component = AltImageComponent.of(stack.getItem());
        }
        return Optional.ofNullable(this.component);
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return ModUtils.supportsEnchantment(stack, enchantment);
    }

    public static void dropAndPlaceOnRightClick(Player player, ItemStack stack, BlockPos pos) {
        Level level = player.level();
        BlockState state = level.getBlockState(pos);
        if (!state.is(BlockTags.CROPS)) {
            return;
        }
        for (Property property : state.getProperties()) {
            block11: {
                IntegerProperty integerProperty;
                if (!(property instanceof IntegerProperty) || !"age".equals((integerProperty = (IntegerProperty)property).getName())) continue;
                int age = (Integer)state.getValue((Property)integerProperty);
                if (property.getPossibleValues().size() == age + 1) {
                    Item item;
                    ItemStack consumed = ItemStack.EMPTY;
                    for (ItemStack drop : Block.getDrops((BlockState)state, (ServerLevel)((ServerLevel)level), (BlockPos)pos, (BlockEntity)level.getBlockEntity(pos), (Entity)player, (ItemStack)stack)) {
                        if (consumed.isEmpty() && (drop.is(Tags.Items.SEEDS) || drop.is(state.getBlock().asItem()))) {
                            consumed = drop.split(1);
                            if (drop.isEmpty()) continue;
                        }
                        Block.popResource((Level)level, (BlockPos)pos, (ItemStack)drop);
                    }
                    if (!consumed.isEmpty() && (item = consumed.getItem()) instanceof BlockItem) {
                        BlockItem blockItem = (BlockItem)item;
                        level.setBlockAndUpdate(pos, blockItem.getBlock().defaultBlockState());
                    } else {
                        level.removeBlock(pos, false);
                    }
                } else if (age > 0) {
                    for (ItemStack drop : Block.getDrops((BlockState)state, (ServerLevel)((ServerLevel)level), (BlockPos)pos, (BlockEntity)level.getBlockEntity(pos), (Entity)player, (ItemStack)stack)) {
                        if (drop.is(Tags.Items.SEEDS)) {
                            Block.popResource((Level)level, (BlockPos)pos, (ItemStack)drop);
                            continue;
                        }
                        if (!drop.is(state.getBlock().asItem())) continue;
                        break block11;
                    }
                    level.setBlock(pos, (BlockState)state.setValue((Property)integerProperty, (Comparable)Integer.valueOf(0)), 2);
                }
            }
            player.swing(InteractionHand.MAIN_HAND, true);
            break;
        }
    }

    public static void increaseDropsOnBlockBreak(Entity entity, ItemStack stack, List<ItemEntity> drops) {
        Holder.Reference enchantment = entity.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.FORTUNE);
        int l = stack.getTagEnchantments().getLevel((Holder)enchantment);
        for (ItemEntity drop : drops) {
            int increase = entity.getRandom().nextIntBetweenInclusive(0, 2);
            drop.getItem().grow(increase);
            for (int i = 0; i < l; ++i) {
                if (!(entity.getRandom().nextFloat() < 0.5f)) continue;
                drop.getItem().grow(1);
            }
        }
    }
}

