/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.common;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import org.confluence.lib.ConfluenceMagicLib;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.lib.common.component.ToolMode;
import org.confluence.mod.common.init.ModTags;
import org.confluence.mod.common.init.item.ModItems;
import org.confluence.mod.common.item.AltImageComponent;
import org.confluence.mod.common.item.common.BaseHammerItem;
import org.confluence.mod.util.ModUtils;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BaseHamaxeItem
extends DiggerItem {
    @Nullable
    private TooltipComponent component;
    private boolean hasImage;

    public BaseHamaxeItem(Tier tier, float rawDamage, float rawSpeed, Item.Properties properties, ModRarity rarity) {
        super(tier, ModTags.Blocks.MINEABLE_WITH_HAMAXE, properties.component(ConfluenceMagicLib.MOD_RARITY, (Object)rarity).component(DataComponents.ATTRIBUTE_MODIFIERS, (Object)BaseHamaxeItem.createAttributes((Tier)tier, (float)(rawDamage - tier.getAttackDamageBonus() - 1.0f), (float)(rawSpeed - 4.0f))).component(ConfluenceMagicLib.TOOL_MODE, (Object)new ToolMode(0)));
    }

    public BaseHamaxeItem(Tier tier, float rawDamage, float rawSpeed, Item.Properties properties, Consumer<ItemAttributeModifiers.Builder> consumer, ModRarity rarity) {
        super(tier, ModTags.Blocks.MINEABLE_WITH_HAMAXE, properties.component(ConfluenceMagicLib.MOD_RARITY, (Object)rarity).component(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ModItems.createAttributes(tier, rawDamage - tier.getAttackDamageBonus() - 1.0f, rawSpeed - 4.0f, consumer)).component(ConfluenceMagicLib.TOOL_MODE, (Object)new ToolMode(0)));
    }

    public BaseHamaxeItem hasImage() {
        this.hasImage = true;
        return this;
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        if (this.component == null && this.hasImage) {
            this.component = AltImageComponent.of(stack.getItem());
        }
        return Optional.ofNullable(this.component);
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return ModUtils.supportsEnchantment(stack, enchantment);
    }

    public boolean mineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity miningEntity) {
        ToolMode toolMode = (ToolMode)stack.get((DataComponentType)ConfluenceMagicLib.TOOL_MODE.get());
        if (toolMode == null || toolMode.mode() == 0) {
            BaseHammerItem.hammerMineBlock(stack, level, state, pos, miningEntity);
        }
        return true;
    }

    public InteractionResult useOn(UseOnContext context) {
        return Items.NETHERITE_AXE.useOn(context);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (BaseHamaxeItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE).getType() == HitResult.Type.MISS && player.isCrouching()) {
                ItemStack toolItem = player.getItemInHand(usedHand);
                ToolMode toolMode = (ToolMode)toolItem.get((DataComponentType)ConfluenceMagicLib.TOOL_MODE.get());
                if (toolMode != null && toolMode.mode() == 0) {
                    toolItem.set(ConfluenceMagicLib.TOOL_MODE, (Object)new ToolMode(1));
                } else if (toolMode == null || toolMode.mode() == 1) {
                    toolItem.set(ConfluenceMagicLib.TOOL_MODE, (Object)new ToolMode(0));
                }
                serverPlayer.sendSystemMessage((Component)Component.translatable((String)"message.confluence.toolmode.current").withStyle(ChatFormatting.GRAY).append(this.getModeName(toolItem)), true);
                level.playSound(null, player.blockPosition(), SoundEvents.TRIPWIRE_CLICK_ON, SoundSource.PLAYERS, 0.4f, 0.6f);
            }
        }
        return super.use(level, player, usedHand);
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility itemAbility) {
        return ItemAbilities.DEFAULT_AXE_ACTIONS.contains(itemAbility);
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return true;
    }

    public Component getModeName(ItemStack stack) {
        ToolMode toolMode = (ToolMode)stack.get((DataComponentType)ConfluenceMagicLib.TOOL_MODE.get());
        if (toolMode != null && toolMode.mode() == 1) {
            return Component.translatable((String)"message.confluence.hamaxe.mode.1").withStyle(ChatFormatting.WHITE);
        }
        return Component.translatable((String)"message.confluence.hamaxe.mode.0").withStyle(ChatFormatting.WHITE);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"message.confluence.toolmode.tip").withStyle(ChatFormatting.GRAY));
        tooltipComponents.add((Component)Component.translatable((String)"message.confluence.toolmode.current").withStyle(ChatFormatting.GRAY).append(this.getModeName(stack)));
    }
}

