/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.common;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.entity.PartEntity;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.lib.common.item.CustomRarityItem;
import org.confluence.lib.util.VectorUtils;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.init.ModDamageTypes;
import org.confluence.mod.common.init.item.LanceItems;
import org.confluence.mod.common.item.AltImageComponent;
import org.confluence.mod.mixed.IServerPlayer;
import org.confluence.mod.util.ModUtils;
import org.confluence.terraentity.api.item.ILeftClickStateItem;
import org.confluence.terraentity.attachment.WeaponStorage;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoItemRenderer;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BaseLanceItem
extends CustomRarityItem
implements ILeftClickStateItem,
GeoItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final int attackInterval;
    private final double attackDistance;
    private final double baseAttackDamage;
    private final double baseKnockback;
    private List<Component> tooltips;
    private TooltipComponent component;

    public BaseLanceItem(Item.Properties properties, ModRarity rarity, int attackInterval, double attackDistance, double baseAttackDamage, double baseKnockback) {
        super(properties.stacksTo(1), rarity);
        this.attackInterval = attackInterval;
        this.attackDistance = attackDistance;
        this.baseAttackDamage = baseAttackDamage;
        this.baseKnockback = baseKnockback;
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        if (this.component == null) {
            this.component = new AltImageComponent(stack);
        }
        return Optional.of(this.component);
    }

    public void onLeftClick(Player player, ItemStack itemStack) {
        if (!player.level().isClientSide && !player.getCooldowns().isOnCooldown((Item)this)) {
            this.triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)itemStack, (ServerLevel)((ServerLevel)player.level())), "lance", "sting");
        }
    }

    public void onLeftRelease(Player player, ItemStack itemStack) {
        if (!player.level().isClientSide) {
            this.stopTriggeredAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)itemStack, (ServerLevel)((ServerLevel)player.level())), "lance", "sting");
        }
    }

    public boolean canSwitchWithoutRelease(Player player, ItemStack itemStack) {
        return false;
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (isSelected && entity instanceof ServerPlayer) {
            ServerPlayer owner = (ServerPlayer)entity;
            if (WeaponStorage.of((IAttachmentHolder)owner).leftClicking && !owner.getCooldowns().isOnCooldown((Item)this) && (this.attackInterval <= 1 || owner.level().getGameTime() % (long)this.attackInterval == 0L)) {
                Vec3 startVec = new Vec3(owner.getX(), owner.getEyeY() - 0.1, owner.getZ());
                Vec3 lanceDirection = owner.getViewVector(1.0f);
                Vec3 endVec = startVec.add(lanceDirection.scale(this.attackDistance));
                for (Entity victim : level.getEntities((Entity)owner, new AABB(startVec, endVec), target -> ModUtils.canHitEntity(target, (Entity)owner))) {
                    if (victim.getBoundingBox().inflate(0.3).clip(startVec, endVec).isEmpty()) continue;
                    owner.setLastHurtMob(victim);
                    if (victim instanceof PartEntity) {
                        PartEntity partEntity = (PartEntity)victim;
                        victim = partEntity.getParent();
                    }
                    DamageSource damageSource = ModDamageTypes.of(level, (ResourceKey<DamageType>)DamageTypes.STING, (Entity)owner);
                    Vec3 attackerVelocity = new Vec3(IServerPlayer.of(owner).confluence$getMovementSpeed());
                    Vec3 relativeVelocity = attackerVelocity.subtract(victim.getDeltaMovement());
                    Vec3 projectedVelocity = VectorUtils.vectorProjection((Vec3)relativeVelocity, (Vec3)lanceDirection);
                    double impactSpeed = projectedVelocity.length() * 30.0;
                    victim.hurt(damageSource, (float)Mth.floor((double)(this.baseAttackDamage * (impactSpeed * 6.0 / 175.0 + (double)0.1f))));
                    double kb = impactSpeed * this.baseKnockback * 4.0 / 105.0;
                    VectorUtils.knockBackA2B((Entity)owner, (Entity)victim, (double)kb, (double)(kb * 0.3));
                    EnchantmentHelper.doPostAttackEffects((ServerLevel)((ServerLevel)level), (Entity)victim, (DamageSource)damageSource);
                }
            }
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "lance", state -> PlayState.STOP).triggerableAnim("sting", RawAnimation.begin().thenPlayAndHold("sting")));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (this.tooltips == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)Component.translatable((String)("tooltip." + this.getDescriptionId() + ".0")).withStyle(ChatFormatting.GRAY));
            if (this == LanceItems.JOUSTING_LANCE.get()) {
                builder.add((Object)Component.translatable((String)"tooltip.item.confluence.jousting_lance.1").withStyle(ChatFormatting.GRAY));
            }
            builder.add((Object[])new Component[]{Component.translatable((String)"tooltip.confluence.attack_interval", (Object[])new Object[]{this.attackInterval}).withStyle(ChatFormatting.DARK_GRAY), Component.translatable((String)"tooltip.confluence.attack_distance", (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(this.attackDistance)}).withStyle(ChatFormatting.DARK_GRAY), Component.translatable((String)"tooltip.confluence.attack_damage", (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(this.baseAttackDamage)}).withStyle(ChatFormatting.DARK_GRAY), Component.translatable((String)"tooltip.confluence.knockback", (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(this.baseKnockback)}).withStyle(ChatFormatting.DARK_GRAY)});
            this.tooltips = builder.build();
        }
        tooltipComponents.addAll(this.tooltips);
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        if (this != LanceItems.JOUSTING_LANCE.get()) {
            return;
        }
        consumer.accept(new GeoRenderProvider(){
            private GeoItemRenderer<BaseLanceItem> renderer;

            public BlockEntityWithoutLevelRenderer getGeoItemRenderer() {
                if (this.renderer == null) {
                    String path = BuiltInRegistries.ITEM.getKey((Object)BaseLanceItem.this).getPath();
                    final ResourceLocation model = Confluence.asResource("geo/item/lance/" + path + ".geo.json");
                    final ResourceLocation texture = Confluence.asResource("textures/item/lance/" + path + ".png");
                    final ResourceLocation animation = Confluence.asResource("animations/item/lance.animation.json");
                    this.renderer = new GeoItemRenderer((GeoModel)new GeoModel<BaseLanceItem>(this){

                        public ResourceLocation getModelResource(BaseLanceItem animatable) {
                            return model;
                        }

                        public ResourceLocation getTextureResource(BaseLanceItem animatable) {
                            return texture;
                        }

                        public ResourceLocation getAnimationResource(BaseLanceItem animatable) {
                            return animation;
                        }
                    });
                }
                return this.renderer;
            }
        });
    }

    public static void cancelSting(ServerPlayer player) {
        ItemStack itemStack = player.getMainHandItem();
        Item item = itemStack.getItem();
        if (item instanceof BaseLanceItem) {
            BaseLanceItem lance = (BaseLanceItem)item;
            player.getCooldowns().addCooldown((Item)lance, 5);
            lance.stopTriggeredAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)itemStack, (ServerLevel)player.serverLevel()), "lance", "sting");
        }
    }
}

