/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.common;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundInteractPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.confluence.lib.ConfluenceMagicLib;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.lib.common.item.TooltipItem;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.common.data.map.BugNetEntityToItem;
import org.confluence.mod.common.init.item.ModItems;
import org.confluence.mod.common.item.common.EntityDisplayItem;

public class BugNetItem
extends TooltipItem {
    private final double maxSize;
    private final Predicate<LivingEntity> predicate;

    public BugNetItem(ModRarity rarity, List<Component> tooltips, double maxSize, Predicate<LivingEntity> predicate) {
        super(new Item.Properties().stacksTo(1), rarity, tooltips);
        this.maxSize = maxSize;
        this.predicate = predicate;
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity interactionTarget, InteractionHand usedHand) {
        if (usedHand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        if (player.isLocalPlayer()) {
            ((LocalPlayer)player).connection.send((Packet)ServerboundInteractPacket.createInteractionPacket((Entity)interactionTarget, (boolean)false, (InteractionHand)InteractionHand.MAIN_HAND));
        } else if (this.predicate.test(interactionTarget) && interactionTarget.getBoundingBox().getSize() <= this.maxSize) {
            ItemStack itemStack = BugNetEntityToItem.getItem((ServerPlayer)player, interactionTarget);
            if (itemStack == null) {
                itemStack = ((EntityDisplayItem)((Object)ModItems.ENTITY_DISPLAY.get())).getDefaultInstance();
                interactionTarget.setYRot(0.0f);
                interactionTarget.setYHeadRot(0.0f);
                interactionTarget.setYBodyRot(0.0f);
                interactionTarget.setXRot(0.0f);
                interactionTarget.stopRiding();
                LibUtils.updateItemStackNbt((ItemStack)itemStack, arg_0 -> ((LivingEntity)interactionTarget).save(arg_0));
                if (interactionTarget.hasCustomName()) {
                    itemStack.set(DataComponents.CUSTOM_NAME, (Object)interactionTarget.getCustomName());
                }
                itemStack.remove(ConfluenceMagicLib.MOD_RARITY);
            }
            if (!player.addItem(itemStack)) {
                player.drop(itemStack, false);
            }
            interactionTarget.discard();
            return InteractionResult.SUCCESS_NO_ITEM_USED;
        }
        return InteractionResult.SUCCESS;
    }
}

