/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.common;

import com.mojang.datafixers.util.Pair;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.lib.common.item.TooltipItem;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.common.init.ModStructures;
import org.confluence.mod.common.init.item.ToolItems;

public class DungeonCompass
extends TooltipItem {
    public static final int[][] CRYSTALS = new int[][]{{3, 0}, {2, 2}, {0, 3}, {-2, 2}, {-3, 0}, {-2, -2}, {0, -3}, {2, -2}};
    private static final BlockPattern PATTERN = BlockPatternBuilder.start().aisle(new String[]{"   A   ", " A   A ", "       ", "A     A", "       ", " A   A ", "   A   "}).aisle(new String[]{"   T   ", " T   T ", "   O   ", "T O O T", "   O   ", " T   T ", "   T   "}).where('A', BlockInWorld.hasState(state -> state.is(Blocks.AMETHYST_BLOCK))).where('T', BlockInWorld.hasState(state -> state.is(Blocks.CHISELED_TUFF))).where('O', BlockInWorld.hasState(state -> state.is(Blocks.CRYING_OBSIDIAN))).build();

    public DungeonCompass() {
        super(new Item.Properties().fireResistant().stacksTo(1), ModRarity.GREEN, (Component)Component.translatable((String)"tooltip.item.confluence.dungeon_compass.0").withStyle(ChatFormatting.GRAY));
    }

    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.HEAD;
    }

    public static void matches(Player player, InteractionHand hand, Level level, ItemStack itemStack, BlockState blockState, BlockPos blockPos) {
        if (itemStack.is(ToolItems.METEOR_COMPASS) && blockState.is(Blocks.CHISELED_TUFF)) {
            BlockPattern.BlockPatternMatch matches = PATTERN.matches((LevelReader)level, blockPos.offset(3, 1, 3), Direction.DOWN, Direction.SOUTH);
            if (matches == null) {
                return;
            }
            if (level.isClientSide) {
                RandomSource random = level.random;
                for (int[] crystal : CRYSTALS) {
                    for (int i = 0; i < 16; ++i) {
                        level.addParticle((ParticleOptions)ParticleTypes.ENCHANT, (double)((float)blockPos.getX() + random.nextFloat()), (double)((float)blockPos.getY() + random.nextFloat()) + 1.5, (double)((float)blockPos.getZ() + random.nextFloat()), (double)crystal[0] - 0.5, 0.0, (double)crystal[1] - 0.5);
                    }
                }
            } else {
                ServerLevel serverlevel = (ServerLevel)level;
                HolderSet.Direct dungeon = HolderSet.direct((Holder[])new Holder[]{serverlevel.registryAccess().holderOrThrow(ModStructures.Keys.DUNGEON)});
                Pair pair = serverlevel.getChunkSource().getGenerator().findNearestMapStructure(serverlevel, (HolderSet)dungeon, blockPos, 100, false);
                if (pair == null) {
                    player.displayClientMessage((Component)Component.translatable((String)"message.confluence.dungeon_not_found").withStyle(ChatFormatting.RED), true);
                } else {
                    player.setItemInHand(hand, ItemStack.EMPTY);
                    ItemStack stack = ToolItems.DUNGEON_COMPASS.toStack();
                    LibUtils.updateItemStackNbt((ItemStack)stack, tag -> {
                        BlockPos pos = (BlockPos)pair.getFirst();
                        tag.putIntArray("pos", new int[]{pos.getX(), pos.getY(), pos.getZ()});
                    });
                    LibUtils.createItemEntity((ItemStack)stack, (double)((double)blockPos.getX() + 0.5), (double)((double)blockPos.getY() + 1.5), (double)((double)blockPos.getZ() + 0.5), (Level)level, (int)0);
                }
            }
            player.swing(hand);
        }
    }
}

