/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.common;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import org.confluence.mod.common.init.ModFluids;
import org.confluence.terra_curio.common.init.TCEffects;

public class HoneyBucketItem
extends BucketItem {
    public HoneyBucketItem() {
        super((Fluid)ModFluids.HONEY.fluid().get(), new Item.Properties().craftRemainder(Items.BUCKET).stacksTo(1));
    }

    public ItemStack finishUsingItem(ItemStack pStack, Level pLevel, LivingEntity pEntityLiving) {
        if (!pLevel.isClientSide) {
            pEntityLiving.addEffect(new MobEffectInstance((Holder)TCEffects.HONEY, 900));
            pEntityLiving.removeEffect(MobEffects.POISON);
        }
        if (pEntityLiving instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)pEntityLiving;
            CriteriaTriggers.CONSUME_ITEM.trigger(serverplayer, pStack);
            serverplayer.awardStat(Stats.ITEM_USED.get((Object)this));
        }
        if (pEntityLiving instanceof Player && !((Player)pEntityLiving).hasInfiniteMaterials()) {
            pStack.shrink(1);
        }
        return pStack.isEmpty() ? new ItemStack((ItemLike)Items.BUCKET) : pStack;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 32;
    }

    public UseAnim getUseAnimation(ItemStack pStack) {
        return UseAnim.DRINK;
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pHand) {
        InteractionResultHolder use = super.use(pLevel, pPlayer, pHand);
        if (use.getResult() == InteractionResult.PASS) {
            return ItemUtils.startUsingInstantly((Level)pLevel, (Player)pPlayer, (InteractionHand)pHand);
        }
        return use;
    }
}

