/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.common;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.confluence.mod.common.block.natural.herbs.DeathWeed;
import org.confluence.mod.common.init.block.ModBlocks;
import org.confluence.mod.common.init.block.NatureBlocks;
import org.confluence.mod.common.init.item.ConsumableItems;
import org.confluence.terraentity.init.entity.TEMonsterEntities;

public class ModBoneMealItem
extends Item {
    public ModBoneMealItem() {
        super(new Item.Properties());
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide) {
            AABB aabb = player.getBoundingBox().inflate(2.5);
            List entities = level.getEntities((Entity)player, aabb, entity -> entity instanceof LivingEntity);
            for (Entity entity2 : entities) {
                if (!entity2.isAlive()) continue;
                EntityType entityType = entity2.getType();
                LivingEntity newEntity = null;
                if (stack.is((Item)ConsumableItems.BLOODSTAINED_POWDER.get()) && entityType == EntityType.CREEPER) {
                    entity2.remove(Entity.RemovalReason.KILLED);
                    newEntity = (LivingEntity)((EntityType)TEMonsterEntities.BLOODY_SPORE.value()).create(level);
                } else if (stack.is((Item)ConsumableItems.ROTTEN_BONE_DUST.get()) && entityType == EntityType.SKELETON) {
                    entity2.remove(Entity.RemovalReason.KILLED);
                    newEntity = (LivingEntity)((EntityType)TEMonsterEntities.DECAYEDER.value()).create(level);
                }
                if (newEntity == null) continue;
                newEntity.setPos(entity2.getX(), entity2.getY(), entity2.getZ());
                level.addFreshEntity((Entity)newEntity);
            }
        }
        if (!player.isCreative()) {
            stack.shrink(1);
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        ItemStack stack = context.getItemInHand();
        BlockState state = level.getBlockState(context.getClickedPos());
        for (int i = 0; i < 128; ++i) {
            BlockState randomPlant;
            if (level.isClientSide) continue;
            BlockPos targetPos = context.getClickedPos().above();
            for (int j = 0; j < i / 16 && level.getBlockState((targetPos = targetPos.offset(level.random.nextInt(3) - 1, (level.random.nextInt(3) - 1) * level.random.nextInt(3) / 2, level.random.nextInt(3) - 1)).below()).is(state.getBlock()) && !level.getBlockState(targetPos).isCollisionShapeFullBlock((BlockGetter)level, targetPos); ++j) {
            }
            BlockState targetState = level.getBlockState(targetPos);
            if (!targetState.isAir()) continue;
            String blockType = null;
            if (stack.is((Item)ConsumableItems.BLOODSTAINED_POWDER.get()) && (state.is(NatureBlocks.CRIMSON_GRASS_BLOCK) || state.is(NatureBlocks.CRIMSON_JUNGLE_GRASS_BLOCK))) {
                blockType = "crimson";
            } else if (stack.is((Item)ConsumableItems.ROTTEN_BONE_DUST.get()) && (state.is(NatureBlocks.CORRUPT_GRASS_BLOCK) || state.is(NatureBlocks.CORRUPT_JUNGLE_GRASS_BLOCK))) {
                blockType = "corrupt";
            }
            if (blockType == null || !(randomPlant = this.getRandomPlantState(level, blockType)).canSurvive((LevelReader)level, targetPos)) continue;
            level.setBlock(targetPos, randomPlant, 3);
        }
        stack.shrink(1);
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    private BlockState getRandomPlantState(Level level, String blockType) {
        int random = level.random.nextInt(100);
        BlockState blockState = Blocks.AIR.defaultBlockState();
        if (random < 90) {
            blockState = switch (blockType) {
                case "crimson" -> ((Block)NatureBlocks.CRIMSON_GRASS.get()).defaultBlockState();
                case "corrupt" -> ((Block)NatureBlocks.CORRUPT_GRASS.get()).defaultBlockState();
                default -> blockState;
            };
        } else if (random < 98) {
            blockState = switch (blockType) {
                case "crimson" -> ((Block)NatureBlocks.VICIOUS_MUSHROOM.get()).defaultBlockState();
                case "corrupt" -> ((Block)NatureBlocks.VILE_MUSHROOM.get()).defaultBlockState();
                default -> blockState;
            };
        } else if ("crimson".equals(blockType) || "corrupt".equals(blockType)) {
            blockState = ((DeathWeed)((Object)ModBlocks.DEATHWEED.get())).defaultBlockState();
        }
        return blockState;
    }
}

