/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.common;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.lib.common.item.CustomRarityItem;
import org.confluence.mod.common.component.LootComponent;
import org.confluence.mod.common.init.ModDataComponentTypes;
import org.confluence.mod.common.init.ModSoundEvents;

public class RightClickLootItem
extends CustomRarityItem {
    public RightClickLootItem(ModRarity rarity, ResourceKey<LootTable> lootTable) {
        super(new Item.Properties().component(ModDataComponentTypes.LOOT.get(), (Object)new LootComponent(lootTable)), rarity);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            LootParams lootparams = new LootParams.Builder(serverLevel).withParameter(LootContextParams.ORIGIN, (Object)player.position()).withParameter(LootContextParams.THIS_ENTITY, (Object)player).withLuck(player.getLuck()).create(LootContextParamSets.GIFT);
            LootTable loottable = serverLevel.getServer().reloadableRegistries().getLootTable(((LootComponent)itemStack.get(ModDataComponentTypes.LOOT)).value());
            int count = 1;
            if (player.isCrouching()) {
                count = itemStack.getCount();
            }
            for (int i = 0; i < count; ++i) {
                for (ItemStack loot : loottable.getRandomItems(lootparams)) {
                    if (player.addItem(loot)) continue;
                    player.drop(loot, false, false);
                }
            }
            itemStack.shrink(count);
        } else {
            player.playSound((SoundEvent)ModSoundEvents.TERRA_OPERATION.get(), 0.5f, 1.0f);
        }
        return InteractionResultHolder.success((Object)itemStack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.item.confluence.right_click.common.0").withStyle(ChatFormatting.GRAY));
    }
}

