/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.common;

import java.util.Collections;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.lib.common.item.TooltipItem;
import org.confluence.mod.Confluence;

public class SpongeItem
extends TooltipItem {
    private final Predicate<BlockState> predicate;

    public SpongeItem(ModRarity rarity, String name, int blockInteractionRange, Predicate<BlockState> predicate) {
        super(new Item.Properties().stacksTo(1).attributes(new ItemAttributeModifiers(Collections.singletonList(new ItemAttributeModifiers.Entry(Attributes.BLOCK_INTERACTION_RANGE, new AttributeModifier(Confluence.asResource(name), (double)blockInteractionRange, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND)), true)), rarity, "tooltip.item.confluence." + name + ".0");
        this.predicate = predicate;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack itemStack = player.getItemInHand(usedHand);
        BlockHitResult hitResult = SpongeItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (hitResult.getType() == HitResult.Type.MISS || hitResult.getType() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.pass((Object)itemStack);
        }
        BlockPos blockPos = hitResult.getBlockPos();
        boolean succeed = false;
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)blockPos.offset(-2, -2, -2), (BlockPos)blockPos.offset(2, 2, 2))) {
            if (!level.mayInteract(player, pos) || !this.predicate.test(level.getBlockState(pos))) continue;
            level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            succeed = true;
        }
        if (succeed) {
            return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)level.isClientSide);
        }
        return InteractionResultHolder.fail((Object)itemStack);
    }
}

