/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.common;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.confluence.mod.common.block.natural.spreadable.ISpreadable;
import org.confluence.mod.common.entity.ThrownPowderEntity;

public class ThrownPowderItem
extends Item {
    private final ISpreadable.Type type;

    public ThrownPowderItem(ISpreadable.Type type) {
        super(new Item.Properties());
        this.type = type;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack itemStack = player.getItemInHand(usedHand);
        if (!level.isClientSide) {
            ThrownPowderEntity entity = new ThrownPowderEntity(level, this.type);
            entity.setPos(player.getX(), player.getEyeY() - (double)0.1f, player.getZ());
            entity.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 0.5f);
            level.addFreshEntity((Entity)entity);
            if (!player.hasInfiniteMaterials()) {
                itemStack.shrink(1);
            }
        }
        return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)level.isClientSide);
    }
}

