/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.common;

import java.util.Collections;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.lib.common.item.CustomRarityItem;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.block.functional.network.INetworkEntity;
import org.confluence.mod.common.block.functional.network.PathService;

public class WrenchItem
extends CustomRarityItem {
    public final int color;

    public WrenchItem(int color) {
        super(new Item.Properties().stacksTo(1).attributes(new ItemAttributeModifiers(Collections.singletonList(new ItemAttributeModifiers.Entry(Attributes.BLOCK_INTERACTION_RANGE, new AttributeModifier(Confluence.asResource("wrench"), 20.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND)), true)), ModRarity.BLUE);
        this.color = color;
    }

    public boolean isFoil(ItemStack pStack) {
        return WrenchItem.containsPos(pStack);
    }

    public static boolean containsPos(ItemStack pStack) {
        return LibUtils.getItemStackNbtNoCopy((ItemStack)pStack).contains("blockPos");
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public InteractionResult useOn(UseOnContext pContext) {
        Level pLevel = pContext.getLevel();
        if (pLevel.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        ItemStack itemStack = pContext.getItemInHand();
        BlockPos pPos = pContext.getClickedPos();
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity instanceof INetworkEntity) {
            INetworkEntity entity = (INetworkEntity)blockEntity;
            BlockPos storedPos = WrenchItem.readBlockPos(itemStack);
            if (storedPos == BlockPos.ZERO) {
                WrenchItem.writeBlockPos(itemStack, pPos);
            } else {
                BlockEntity blockEntity2 = pLevel.getBlockEntity(storedPos);
                if (blockEntity2 instanceof INetworkEntity) {
                    INetworkEntity entity1 = (INetworkEntity)blockEntity2;
                    if (entity1.getConnectedPoses().int2ObjectEntrySet().stream().noneMatch(entry -> entry.getIntKey() == this.color && ((Set)entry.getValue()).contains(pPos))) {
                        entity.connectTo(this.color, storedPos, entity1);
                        PathService.INSTANCE.addToQueue(entity);
                    }
                    WrenchItem.removeBlockPos(itemStack);
                }
            }
            return InteractionResult.CONSUME;
        }
        WrenchItem.removeBlockPos(itemStack);
        return InteractionResult.PASS;
    }

    public static void writeBlockPos(ItemStack itemStack, BlockPos pos) {
        LibUtils.updateItemStackNbt((ItemStack)itemStack, nbt -> nbt.put("blockPos", NbtUtils.writeBlockPos((BlockPos)pos)));
    }

    public static BlockPos readBlockPos(ItemStack itemStack) {
        return NbtUtils.readBlockPos((CompoundTag)LibUtils.getItemStackNbtNoCopy((ItemStack)itemStack), (String)"blockPos").orElse(BlockPos.ZERO);
    }

    public static void removeBlockPos(ItemStack itemStack) {
        LibUtils.updateItemStackNbt((ItemStack)itemStack, nbt -> nbt.remove("blockPos"));
    }
}

