/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.food;

import java.util.Arrays;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import org.confluence.mod.common.init.ModEffects;

public class ModFoodProperties {
    public static final FoodProperties GOLDEN_CARP = new FoodProperties.Builder().nutrition(8).saturationModifier(0.8f).fast().alwaysEdible().effect(() -> new MobEffectInstance(ModEffects.EXQUISITELY_STUFFED, 24000, 2), 1.0f).effect(() -> new MobEffectInstance(MobEffects.REGENERATION, 100, 1), 1.0f).effect(() -> new MobEffectInstance(MobEffects.ABSORPTION, 2400), 1.0f).build();
    public static final FoodProperties LIFE_MUSHROOM = new FoodProperties.Builder().nutrition(2).saturationModifier(0.0625f).fast().alwaysEdible().build();

    public static float calcSaturationModifier(int nutrition, float rawSaturation) {
        return rawSaturation / (float)nutrition / 2.0f;
    }

    public static FoodProperties preparedMeatProperties(int nutrition, float rawSaturation) {
        return new FoodProperties.Builder().nutrition(nutrition).saturationModifier(ModFoodProperties.calcSaturationModifier(nutrition, rawSaturation)).fast().alwaysEdible().effect(() -> new MobEffectInstance(ModEffects.EXQUISITELY_STUFFED, 3000), 1.0f).build();
    }

    public static FoodProperties noEffectProperties(int nutrition, float rawSaturation) {
        return new FoodProperties.Builder().nutrition(nutrition).saturationModifier(ModFoodProperties.calcSaturationModifier(nutrition, rawSaturation)).fast().alwaysEdible().build();
    }

    public static FoodProperties hasEffectProperties(int nutrition, float saturation, EffectData ... effects) {
        FoodProperties.Builder builder = new FoodProperties.Builder().nutrition(nutrition).saturationModifier(saturation).fast().alwaysEdible();
        Arrays.stream(effects).forEach(e -> builder.effect(() -> new MobEffectInstance(e.effect, e.duration, e.level), e.probability));
        return builder.build();
    }

    public static FoodProperties WellFedProperties(int duration, int nutrition, float rawSaturation) {
        return new FoodProperties.Builder().nutrition(nutrition).saturationModifier(ModFoodProperties.calcSaturationModifier(nutrition, rawSaturation)).fast().alwaysEdible().effect(() -> new MobEffectInstance(ModEffects.EXQUISITELY_STUFFED, duration), 1.0f).build();
    }

    public static FoodProperties PlentySatisfiedProperties(int duration, int nutrition, float rawSaturation) {
        return new FoodProperties.Builder().nutrition(nutrition).saturationModifier(ModFoodProperties.calcSaturationModifier(nutrition, rawSaturation)).fast().alwaysEdible().effect(() -> new MobEffectInstance(ModEffects.EXQUISITELY_STUFFED, duration, 1), 1.0f).effect(() -> new MobEffectInstance(ModEffects.HUNGER_DELAYED, duration / 6), 1.0f).build();
    }

    public static FoodProperties ExquisitelyStuffedProperties(int duration, int nutrition, float rawSaturation) {
        return new FoodProperties.Builder().nutrition(nutrition).saturationModifier(ModFoodProperties.calcSaturationModifier(nutrition, rawSaturation)).fast().alwaysEdible().effect(() -> new MobEffectInstance(ModEffects.EXQUISITELY_STUFFED, duration, 2), 1.0f).effect(() -> new MobEffectInstance(ModEffects.HUNGER_DELAYED, duration / 6, 1), 1.0f).build();
    }

    public static FoodProperties WellFedProperties(int duration, int nutrition, float rawSaturation, Item item) {
        return new FoodProperties.Builder().nutrition(nutrition).saturationModifier(ModFoodProperties.calcSaturationModifier(nutrition, rawSaturation)).fast().alwaysEdible().usingConvertsTo((ItemLike)item).effect(() -> new MobEffectInstance(ModEffects.EXQUISITELY_STUFFED, duration), 1.0f).build();
    }

    public static FoodProperties PlentySatisfiedProperties(int duration, int nutrition, float rawSaturation, Item item) {
        return new FoodProperties.Builder().nutrition(nutrition).saturationModifier(ModFoodProperties.calcSaturationModifier(nutrition, rawSaturation)).fast().alwaysEdible().usingConvertsTo((ItemLike)item).effect(() -> new MobEffectInstance(ModEffects.EXQUISITELY_STUFFED, duration, 1), 1.0f).effect(() -> new MobEffectInstance(ModEffects.HUNGER_DELAYED, duration / 6), 1.0f).build();
    }

    public static FoodProperties ExquisitelyStuffedProperties(int duration, int nutrition, float rawSaturation, Item item) {
        return new FoodProperties.Builder().nutrition(nutrition).saturationModifier(ModFoodProperties.calcSaturationModifier(nutrition, rawSaturation)).fast().alwaysEdible().usingConvertsTo((ItemLike)item).effect(() -> new MobEffectInstance(ModEffects.EXQUISITELY_STUFFED, duration, 2), 1.0f).effect(() -> new MobEffectInstance(ModEffects.HUNGER_DELAYED, duration / 6, 1), 1.0f).build();
    }

    public record EffectData(Holder<MobEffect> effect, int duration, int level, float probability) {
        public static EffectData of(Holder<MobEffect> effect, int duration) {
            return new EffectData(effect, duration, 0, 1.0f);
        }

        public static EffectData of(Holder<MobEffect> effect, int duration, float probability) {
            return new EffectData(effect, duration, 0, probability);
        }

        public static EffectData of(Holder<MobEffect> effect, int duration, int level) {
            return new EffectData(effect, duration, level, 1.0f);
        }

        public static EffectData of(Holder<MobEffect> effect, int duration, int level, float probability) {
            return new EffectData(effect, duration, level, probability);
        }
    }
}

