/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.mana;

import java.util.Collection;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.common.entity.projectile.mana.CloudProjectile;
import org.confluence.mod.common.item.mana.ManaStaffItem;

public class CloudRodItem
extends ManaStaffItem<CloudProjectile> {
    private int maxCloud = 1;

    public CloudRodItem(Item.Properties properties, ModRarity rarity, ManaStaffItem.ProjectileFactory<CloudProjectile> factory, float damage, int manaCost, float rawVelocity, int cooldown) {
        super(properties, rarity, factory, damage, manaCost, rawVelocity, cooldown);
    }

    public CloudRodItem(ModRarity rarity, ManaStaffItem.ProjectileFactory<CloudProjectile> factory, float damage, int manaCost, float rawVelocity, int cooldown, Consumer<ItemAttributeModifiers.Builder> consumer) {
        super(rarity, factory, damage, manaCost, rawVelocity, cooldown, consumer);
    }

    public CloudRodItem(ModRarity rarity, ManaStaffItem.ProjectileFactory<CloudProjectile> factory, float damage, int manaCost, float rawVelocity, int cooldown, double critChance) {
        super(rarity, factory, damage, manaCost, rawVelocity, cooldown, critChance);
    }

    public CloudRodItem setMaxCloud(int maxCloud) {
        if (maxCloud < 1) {
            throw new IllegalArgumentException("maxCount must be greater than 1, currently is '" + maxCloud + "'");
        }
        this.maxCloud = maxCloud;
        return this;
    }

    @Override
    protected void beforeShoot(ServerPlayer player, ItemStack itemStack, CloudProjectile projectile) {
        Entity entity2;
        AABB aabb;
        super.beforeShoot(player, itemStack, projectile);
        CompoundTag tag = LibUtils.getItemStackNbtNoCopy((ItemStack)itemStack);
        ListTag clouds = tag.getList("Clouds", 11);
        if (clouds.size() == this.maxCloud) {
            UUID removed = NbtUtils.loadUUID((Tag)((Tag)clouds.removeFirst()));
            Entity entity3 = player.serverLevel().getEntity(removed);
            if (entity3 != null) {
                entity3.discard();
            }
        }
        double reach = 64.0;
        double squared = Mth.square((double)reach);
        Vec3 from = player.getEyePosition(1.0f);
        HitResult hitResult = player.pick(reach, 1.0f, false);
        double sqr = hitResult.getLocation().distanceToSqr(from);
        if (hitResult.getType() != HitResult.Type.MISS) {
            squared = sqr;
            reach = Math.sqrt(sqr);
        }
        Vec3 viewVector = player.getViewVector(1.0f);
        Vec3 to = from.add(viewVector.x * reach, viewVector.y * reach, viewVector.z * reach);
        EntityHitResult entityHitResult = ProjectileUtil.getEntityHitResult((Entity)player, (Vec3)from, (Vec3)to, (AABB)(aabb = player.getBoundingBox().expandTowards(viewVector.scale(reach)).inflate(1.0, 1.0, 1.0)), entity -> !entity.isSpectator() && entity.isPickable(), (double)squared);
        if (entityHitResult != null && entityHitResult.getLocation().distanceToSqr(from) < sqr && (entity2 = entityHitResult.getEntity()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity2;
            projectile.setTarget(living);
        }
    }

    @Override
    protected void afterShoot(ServerPlayer player, ItemStack itemStack, CloudProjectile projectile) {
        super.afterShoot(player, itemStack, projectile);
        LibUtils.updateItemStackNbt((ItemStack)itemStack, tag -> {
            ListTag clouds = new ListTag();
            clouds.addAll((Collection)tag.getList("Clouds", 11));
            clouds.add((Object)NbtUtils.createUUID((UUID)projectile.getUUID()));
            tag.put("Clouds", (Tag)clouds);
        });
    }
}

