/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.potion;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.ToIntFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.confluence.mod.common.CommonConfigs;
import org.confluence.mod.common.init.block.NatureBlocks;
import org.confluence.mod.common.init.item.PotionItems;

public abstract class AbstractPotionItem
extends Item {
    public AbstractPotionItem(Item.Properties properties) {
        super(properties.stacksTo(16));
    }

    public int getUseDuration(ItemStack itemStack, LivingEntity entity) {
        return 20;
    }

    public UseAnim getUseAnimation(ItemStack itemStack) {
        return UseAnim.DRINK;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (this.canUse(player.getItemInHand(hand), level, player)) {
            return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)hand);
        }
        return InteractionResultHolder.fail((Object)player.getItemInHand(hand));
    }

    public ItemStack finishUsingItem(ItemStack itemStack, Level level, LivingEntity living) {
        Player player;
        this.apply(itemStack, level, living);
        if (living instanceof Player && !(player = (Player)living).hasInfiniteMaterials()) {
            itemStack.shrink(1);
        }
        if (((Boolean)CommonConfigs.RETURN_POTION_GLASS_BOTTLE.get()).booleanValue()) {
            if (itemStack.isEmpty()) {
                return this.getReturnItem();
            }
            if (living instanceof Player && !(player = (Player)living).hasInfiniteMaterials()) {
                ItemStack itemstack = this.getReturnItem();
                if (!player.getInventory().add(itemstack)) {
                    player.drop(itemstack, false);
                }
            }
            return itemStack;
        }
        return itemStack.isEmpty() ? ItemStack.EMPTY : itemStack;
    }

    protected ItemStack getReturnItem() {
        return PotionItems.BOTTLE.toStack();
    }

    protected boolean canUse(ItemStack itemStack, Level level, Player player) {
        return true;
    }

    protected abstract void apply(ItemStack var1, Level var2, LivingEntity var3);

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        ItemStack stack = context.getItemInHand();
        BlockState state = level.getBlockState(pos);
        if (!level.isClientSide && player != null && stack.is((Item)PotionItems.BOTTLED_WATER.get())) {
            Block block = state.getBlock();
            Block newBlock = null;
            if (block == Blocks.SAND) {
                newBlock = (Block)NatureBlocks.MOISTENED_SAND_BLOCK.get();
            } else if (block == Blocks.RED_SAND) {
                newBlock = (Block)NatureBlocks.MOISTENED_RED_SAND_BLOCK.get();
            } else if (block == NatureBlocks.EBONSAND.get()) {
                newBlock = (Block)NatureBlocks.MOISTENED_EBONSAND_BLOCK.get();
            } else if (block == NatureBlocks.PEARLSAND.get()) {
                newBlock = (Block)NatureBlocks.MOISTENED_PEARLSAND_BLOCK.get();
            } else if (block == NatureBlocks.CRIMSAND.get()) {
                newBlock = (Block)NatureBlocks.MOISTENED_CRIMSAND_BLOCK.get();
            }
            if (newBlock != null) {
                level.playSound(null, pos, SoundEvents.GENERIC_SPLASH, SoundSource.BLOCKS, 1.0f, 1.0f);
                player.setItemInHand(context.getHand(), ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)PotionItems.BOTTLE.toStack()));
                player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
                level.setBlockAndUpdate(pos, newBlock.defaultBlockState());
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        String key = "tooltip." + stack.getDescriptionId() + ".0";
        if (I18n.exists((String)key)) {
            tooltipComponents.add((Component)Component.translatable((String)key).withStyle(ChatFormatting.GRAY));
        }
    }

    public static <T extends AbstractPotionItem> void use(Player player, float required, Class<T> type, ToIntFunction<T> function) {
        if (required <= 0.0f) {
            return;
        }
        ArrayList<Tuple> potions = new ArrayList<Tuple>();
        Item item = player.getOffhandItem().getItem();
        if (type.isInstance(item)) {
            potions.add(new Tuple((Object)player.getOffhandItem(), (Object)function.applyAsInt((AbstractPotionItem)((Object)type.cast(item)))));
        }
        for (ItemStack itemStack : player.getInventory().items) {
            item = itemStack.getItem();
            if (!type.isInstance(item)) continue;
            potions.add(new Tuple((Object)itemStack, (Object)function.applyAsInt((AbstractPotionItem)((Object)type.cast(item)))));
        }
        if (potions.isEmpty()) {
            return;
        }
        potions.sort(Comparator.comparingInt(Tuple::getB));
        Level level = player.level();
        for (int i = 0; i < potions.size(); ++i) {
            Tuple left = (Tuple)potions.get(i);
            if (required <= (float)((Integer)left.getB()).intValue()) {
                ((ItemStack)left.getA()).finishUsingItem(level, (LivingEntity)player);
                return;
            }
            if (i == potions.size() - 1) {
                ((ItemStack)left.getA()).finishUsingItem(level, (LivingEntity)player);
                return;
            }
            Tuple right = (Tuple)potions.get(i + 1);
            if (!((float)((Integer)right.getB()).intValue() >= required)) continue;
            ((ItemStack)right.getA()).finishUsingItem(level, (LivingEntity)player);
            return;
        }
        ((ItemStack)((Tuple)potions.getLast()).getA()).finishUsingItem(level, (LivingEntity)player);
    }
}

