/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.potion;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.confluence.mod.common.init.item.PotionItems;

public class BottleItem
extends Item {
    public BottleItem() {
        super(new Item.Properties().stacksTo(16));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        BlockHitResult blockhitresult = BottleItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        ItemStack itemstack = player.getItemInHand(hand);
        if (blockhitresult.getType() == HitResult.Type.BLOCK) {
            BlockPos blockpos = blockhitresult.getBlockPos();
            if (!level.mayInteract(player, blockpos)) {
                return InteractionResultHolder.pass((Object)itemstack);
            }
            if (level.getFluidState(blockpos).is(FluidTags.WATER)) {
                level.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.BOTTLE_FILL, SoundSource.NEUTRAL, 1.0f, 1.0f);
                level.gameEvent((Entity)player, (Holder)GameEvent.FLUID_PICKUP, blockpos);
                return InteractionResultHolder.sidedSuccess((Object)ItemUtils.createFilledResult((ItemStack)itemstack, (Player)player, (ItemStack)PotionItems.BOTTLED_WATER.toStack()), (boolean)level.isClientSide);
            }
        }
        return InteractionResultHolder.pass((Object)itemstack);
    }
}

