/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.potion;

import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.confluence.lib.ConfluenceMagicLib;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.mod.common.item.potion.AbstractPotionItem;

public class EffectPotionItem
extends AbstractPotionItem {
    public final Holder<MobEffect> mobEffect;
    public final int duration;
    public final int amplifier;

    public EffectPotionItem(Item.Properties properties, Holder<MobEffect> mobEffect, int duration, int amplifier) {
        super(properties);
        this.mobEffect = mobEffect;
        this.duration = duration;
        this.amplifier = amplifier;
    }

    public EffectPotionItem(ModRarity rarity, Holder<MobEffect> mobEffect, int duration) {
        this(new Item.Properties().component(ConfluenceMagicLib.MOD_RARITY, (Object)rarity), mobEffect, duration, 0);
    }

    public EffectPotionItem(ModRarity rarity, Holder<MobEffect> mobEffect, int duration, int amplifier) {
        this(new Item.Properties().component(ConfluenceMagicLib.MOD_RARITY, (Object)rarity), mobEffect, duration, amplifier);
    }

    public EffectPotionItem(Holder<MobEffect> mobEffect, int duration) {
        this(new Item.Properties().component(ConfluenceMagicLib.MOD_RARITY, (Object)ModRarity.BLUE), mobEffect, duration, 0);
    }

    public EffectPotionItem(Holder<MobEffect> mobEffect, int duration, int amplifier) {
        this(new Item.Properties().component(ConfluenceMagicLib.MOD_RARITY, (Object)ModRarity.BLUE), mobEffect, duration, amplifier);
    }

    @Override
    protected void apply(ItemStack itemStack, Level level, LivingEntity living) {
        if (level.isClientSide) {
            return;
        }
        living.addEffect(new MobEffectInstance(this.mobEffect, this.duration, this.amplifier));
    }
}

