/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.potion;

import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.confluence.mod.common.init.ModSoundEvents;
import org.confluence.mod.common.item.potion.AbstractPotionItem;

public class RandomTeleportPotionItem
extends AbstractPotionItem {
    public static final double RANGE = 200.0;

    public RandomTeleportPotionItem() {
        super(new Item.Properties());
    }

    @Override
    protected void apply(ItemStack itemStack, Level level, LivingEntity living) {
        if (!level.isClientSide) {
            double x = living.getX();
            double y = living.getY();
            double z = living.getZ();
            for (int i = 0; i < 16; ++i) {
                double nx = living.getX() + (living.getRandom().nextDouble() - 0.5) * 200.0;
                double ny = Mth.clamp((double)(living.getY() + (living.getRandom().nextDouble() - 0.5) * 200.0), (double)level.getMinBuildHeight(), (double)(level.getMinBuildHeight() + ((ServerLevel)level).getLogicalHeight() - 1));
                double nz = living.getZ() + (living.getRandom().nextDouble() - 0.5) * 200.0;
                if (living.isPassenger()) {
                    living.stopRiding();
                }
                Vec3 vec3 = living.position();
                level.gameEvent((Holder)GameEvent.TELEPORT, vec3, GameEvent.Context.of((Entity)living));
                if (!living.randomTeleport(nx, ny, nz, true)) continue;
                level.playSound(null, x, y, z, (SoundEvent)ModSoundEvents.TRANSMISSION.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                living.playSound((SoundEvent)ModSoundEvents.TRANSMISSION.get(), 1.0f, 1.0f);
                break;
            }
            if (living instanceof Player) {
                Player player = (Player)living;
                player.getCooldowns().addCooldown((Item)this, 20);
            }
        }
    }
}

