/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.spear;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.entity.PartEntity;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.lib.common.item.TooltipItem;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.init.ModDamageTypes;
import org.confluence.mod.common.init.item.ModItems;
import org.confluence.mod.common.item.AltImageComponent;
import org.confluence.mod.util.ModUtils;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.EasingType;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.animation.keyframe.AnimationPoint;
import software.bernie.geckolib.animation.keyframe.Keyframe;
import software.bernie.geckolib.loading.math.MathValue;
import software.bernie.geckolib.loading.math.value.Constant;
import software.bernie.geckolib.model.DefaultedItemGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoItemRenderer;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class AbstractSpearItem
extends TooltipItem
implements GeoItem {
    public static final String LAST_ATTACK_TIME_KEY = "confluence:last_attack_time";
    protected final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected final int attackDuration;
    protected final int attackInterval;
    protected final List<Keyframe<MathValue>> keyframes;
    private TooltipComponent component;

    public AbstractSpearItem(Item.Properties properties, ModRarity rarity, int attackDuration, int attackInterval, List<Keyframe<MathValue>> keyframes) {
        super(properties.stacksTo(1), rarity, AbstractSpearItem.collectTooltips(attackDuration, attackInterval));
        if (attackInterval < 1) {
            throw new IllegalArgumentException("attackInterval must be greater than or equal to 1, currently is " + attackInterval);
        }
        this.attackDuration = attackDuration;
        this.attackInterval = attackInterval;
        this.keyframes = keyframes;
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    private static List<Component> collectTooltips(int attackDuration, int attackInterval) {
        return List.of(Component.translatable((String)"tooltip.confluence.attack_duration", (Object[])new Object[]{attackDuration}).withStyle(ChatFormatting.GRAY), Component.translatable((String)"tooltip.confluence.attack_interval", (Object[])new Object[]{attackInterval}).withStyle(ChatFormatting.GRAY));
    }

    public int getAttackDuration() {
        return this.attackDuration;
    }

    public int getAttackInterval() {
        return this.attackInterval;
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        if (this.component == null) {
            this.component = AltImageComponent.of(stack.getItem());
        }
        return Optional.of(this.component);
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return ModUtils.supportsEnchantment(stack, enchantment);
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity, InteractionHand hand) {
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (entity.level().getGameTime() - LibUtils.getItemStackNbtNoCopy((ItemStack)stack).getLong(LAST_ATTACK_TIME_KEY) > (long)this.attackDuration) {
                LibUtils.updateItemStackNbt((ItemStack)stack, tag -> tag.putLong(LAST_ATTACK_TIME_KEY, entity.level().getGameTime()));
                this.triggerAnim((Entity)entity, GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)level2), "spear", "use");
                this.onStartSting(stack, level2, entity);
            }
        }
        return true;
    }

    protected void onStartSting(ItemStack stack, ServerLevel level, LivingEntity owner) {
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public boolean canAttackBlock(BlockState state, Level level, BlockPos pos, Player player) {
        return false;
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        CompoundTag tag;
        ServerPlayer owner;
        long gameTime;
        long tickCount;
        if (isSelected && entity instanceof ServerPlayer && (tickCount = (gameTime = (owner = (ServerPlayer)entity).level().getGameTime()) - (tag = LibUtils.getItemStackNbtNoCopy((ItemStack)stack)).getLong(LAST_ATTACK_TIME_KEY)) <= (long)this.attackDuration && (this.attackInterval <= 1 || gameTime % (long)this.attackInterval == 0L)) {
            Vec3 viewVector = owner.getViewVector(1.0f);
            Vec3 position = new Vec3(owner.getX(), owner.getEyeY() - 0.1, owner.getZ());
            Vec3 startVec = position.add(viewVector.scale(-0.5));
            Vec3 endVec = position.add(viewVector.scale(this.getDistance(tickCount, (LivingEntity)owner)));
            for (Entity victim : level.getEntities((Entity)owner, new AABB(startVec, endVec), target -> this.canHitEntity((Entity)target, (LivingEntity)owner))) {
                if (victim.getBoundingBox().inflate(0.3).clip(startVec, endVec).isEmpty()) continue;
                owner.setLastHurtMob(victim);
                if (victim instanceof PartEntity) {
                    PartEntity partEntity = (PartEntity)victim;
                    victim = partEntity.getParent();
                }
                this.onHitEntity(stack, (ServerLevel)level, (LivingEntity)owner, victim);
            }
            this.onStingTick(stack, (ServerLevel)level, (LivingEntity)owner, endVec, (long)this.attackDuration - tickCount < (long)this.attackInterval);
        }
    }

    protected abstract void onHitEntity(DamageSource var1, LivingEntity var2, Entity var3);

    protected DamageSource getDamageSource(ServerLevel level, LivingEntity owner) {
        return ModDamageTypes.of((Level)level, (ResourceKey<DamageType>)DamageTypes.STING, (Entity)owner);
    }

    protected void onHitEntity(ItemStack stack, ServerLevel level, LivingEntity owner, Entity victim) {
        DamageSource damageSource = this.getDamageSource(level, owner);
        this.onHitEntity(damageSource, owner, victim);
        EnchantmentHelper.doPostAttackEffects((ServerLevel)level, (Entity)victim, (DamageSource)damageSource);
    }

    protected void onStingTick(ItemStack stack, ServerLevel level, LivingEntity owner, Vec3 tipPos, boolean last) {
    }

    protected boolean hurtVictim(DamageSource damageSource, LivingEntity owner, Entity victim) {
        return victim.hurt(damageSource, (float)owner.getAttributeValue(Attributes.ATTACK_DAMAGE));
    }

    protected boolean canHitEntity(Entity target, LivingEntity owner) {
        return ModUtils.canHitEntity(target, (Entity)owner);
    }

    protected double getDistance(long tickCount, LivingEntity owner) {
        double totalFrameTime = 0.0;
        Keyframe<MathValue> currentFrame = null;
        double startTick = tickCount;
        for (Keyframe<MathValue> frame : this.keyframes) {
            if (!((totalFrameTime += frame.length()) > (double)tickCount)) continue;
            currentFrame = frame;
            startTick = (double)tickCount - (totalFrameTime - frame.length());
            break;
        }
        if (currentFrame == null) {
            currentFrame = this.keyframes.getLast();
        }
        AnimationPoint point = new AnimationPoint(currentFrame, startTick, currentFrame.length(), currentFrame.startValue().get(), currentFrame.endValue().get());
        return point.keyFrame().easingType().apply(point) * owner.getAttributeValue(Attributes.ENTITY_INTERACTION_RANGE) / -16.0;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "spear", state -> PlayState.STOP).triggerableAnim("use", RawAnimation.begin().thenPlay("use")));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(){
            private GeoItemRenderer<AbstractSpearItem> renderer;

            public BlockEntityWithoutLevelRenderer getGeoItemRenderer() {
                if (this.renderer == null) {
                    this.renderer = new GeoItemRenderer((GeoModel)new DefaultedItemGeoModel(Confluence.asResource("spear/" + BuiltInRegistries.ITEM.getKey((Object)AbstractSpearItem.this).getPath())));
                }
                return this.renderer;
            }
        });
    }

    public static ItemAttributeModifiers attributes(float extraRange, float extraDamage) {
        return ItemAttributeModifiers.builder().add(Attributes.ENTITY_INTERACTION_RANGE, new AttributeModifier(ModItems.BASE_ENTITY_INTERACTION_RANGE_ID, (double)extraRange, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_DAMAGE, new AttributeModifier(Item.BASE_ATTACK_DAMAGE_ID, (double)extraDamage, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public static List<Keyframe<MathValue>> createKeyframes(K k, K ... ks) {
        LinkedList<Keyframe> keyframes = new LinkedList<Keyframe>();
        keyframes.add(new Keyframe(0.0, (MathValue)new Constant(0.0), k.toValue(), k.easingType));
        for (K k1 : ks) {
            Keyframe last = (Keyframe)keyframes.getLast();
            keyframes.add(new Keyframe(k1.toTick() - last.endValue().get(), last.endValue(), k1.toValue(), k.easingType));
        }
        return new ObjectArrayList(keyframes);
    }

    public record K(double atTime, double zOffset, EasingType easingType) {
        public double toTick() {
            return this.atTime * 20.0;
        }

        public MathValue toValue() {
            return new Constant(this.zOffset);
        }

        public static K of(double atTime, double zOffset, EasingType easingType) {
            return new K(atTime, zOffset, easingType);
        }
    }
}

