/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.sponsor;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.lib.common.item.CustomRarityItem;
import org.confluence.lib.common.item.TooltipItem;
import org.confluence.mod.common.entity.projectile.IceTofuBrickProjectile;

public class IceTofuBrickItem
extends CustomRarityItem
implements ProjectileItem {
    public IceTofuBrickItem() {
        super(new Item.Properties(), ModRarity.MASTER);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack itemstack = player.getItemInHand(usedHand);
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.SNOWBALL_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
        if (!level.isClientSide) {
            IceTofuBrickProjectile brick = new IceTofuBrickProjectile((LivingEntity)player, level);
            brick.setItem(itemstack);
            brick.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.0f, 0.0f);
            level.addFreshEntity((Entity)brick);
            player.getCooldowns().addCooldown((Item)this, 6);
        }
        return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)level.isClientSide());
    }

    public Projectile asProjectile(Level level, Position pos, ItemStack itemStack, Direction direction) {
        IceTofuBrickProjectile brick = new IceTofuBrickProjectile(pos.x(), pos.y(), pos.z(), level);
        brick.setItem(itemStack);
        return brick;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.addAll(TooltipItem.getTooltipsFromString((String)"ice_tofu_brick", (int)1, (ChatFormatting)ChatFormatting.GRAY));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }
}

