/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.sword.legacy;

import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import org.confluence.mod.common.component.SwordProjectileComponent;
import org.confluence.mod.common.item.sword.BaseSwordItem;
import org.confluence.mod.common.item.sword.legacy.InventoryTickStrategy;
import org.confluence.terraentity.data.component.EffectStrategyComponent;

public class SwordPrefabs {
    public static final Supplier<BaseSwordItem.ModifierBuilder> SHORT_SWORD = () -> new BaseSwordItem.ModifierBuilder().setCanNotPerformSweep();
    public static final Function<Float, BaseSwordItem.ModifierBuilder> BOARD_SWORD = ratio -> SwordPrefabs.withSpecialSweep(ratio.floatValue(), new BaseSwordItem.ModifierBuilder());
    public static final Supplier<BaseSwordItem.ModifierBuilder> NORMAL_SWORD = BaseSwordItem.ModifierBuilder::new;
    public static final Function<Supplier<SwordProjectileComponent>, BaseSwordItem.ModifierBuilder> PROJ_SWORD = strategy -> new BaseSwordItem.ModifierBuilder().setProj((Supplier<SwordProjectileComponent>)strategy);
    public static final Function<EffectStrategyComponent, BaseSwordItem.ModifierBuilder> EFFECT_SWORD = effect -> new BaseSwordItem.ModifierBuilder().setOnHitEffect((EffectStrategyComponent)effect);
    public static final Supplier<BaseSwordItem.ModifierBuilder> UMBRELLA_SWORD = () -> SHORT_SWORD.get().setInventoryTick(InventoryTickStrategy.UMBRELLA_TICK);

    public static BaseSwordItem.ModifierBuilder withSpecialSweep(float ratio, BaseSwordItem.ModifierBuilder builder) {
        builder.setSpecialSweep();
        if (ratio > 0.0f) {
            return builder.addAttributeModifier((Holder<Attribute>)Attributes.SWEEPING_DAMAGE_RATIO, ratio, AttributeModifier.Operation.ADD_VALUE);
        }
        return builder;
    }
}

