/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.menu;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.block.Block;
import org.confluence.lib.common.recipe.AbstractAmountRecipe;
import org.confluence.lib.common.recipe.AmountIngredient;
import org.confluence.mod.common.init.ModMenuTypes;
import org.confluence.mod.common.init.ModRecipes;
import org.confluence.mod.common.init.block.FunctionalBlocks;
import org.confluence.mod.common.recipe.AlchemyTableRecipe;
import org.jetbrains.annotations.Nullable;

public class AlchemyTableMenu
extends AbstractContainerMenu {
    public static final int[][] CORD = new int[][]{{39, 17}, {121, 17}, {39, 37}, {121, 37}, {39, 57}, {121, 57}};
    private final ContainerLevelAccess access;
    private final Player player;
    public final AlchemyTableRecipe.Input input = new AlchemyTableRecipe.Input(this);
    public final ResultContainer result = new ResultContainer();

    public AlchemyTableMenu(int containerId, Inventory inventory) {
        this(containerId, inventory, ContainerLevelAccess.NULL);
    }

    public AlchemyTableMenu(int containerId, Inventory inventory, ContainerLevelAccess access) {
        super(ModMenuTypes.ALCHEMY_TABLE.get(), containerId);
        this.player = inventory.player;
        this.access = access;
        this.addSlot(new ResultSlot(this.input, (Container)this.result, 0, 80, 62));
        this.addSlot(new Slot((Container)this.input, 0, 80, 17));
        for (int i = 1; i < 7; ++i) {
            int[] cord = CORD[i - 1];
            this.addSlot(new Slot((Container)this.input, i, cord[0], cord[1]));
        }
        for (int k = 0; k < 3; ++k) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)inventory, l + k * 9 + 9, 8 + l * 18, 84 + k * 18));
            }
        }
        for (int m = 0; m < 9; ++m) {
            this.addSlot(new Slot((Container)inventory, m, 8 + m * 18, 142));
        }
    }

    public void slotsChanged(Container pInventory) {
        this.access.execute((level, pos) -> {
            Player patt0$temp = this.player;
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                List recipes = this.player.level().getRecipeManager().getRecipesFor(ModRecipes.ALCHEMY_TABLE_TYPE.get(), (RecipeInput)this.input, this.player.level());
                ItemStack itemStack = ItemStack.EMPTY;
                if (!recipes.isEmpty()) {
                    AlchemyTableRecipe recipe = (AlchemyTableRecipe)recipes.stream().max(Comparator.comparingInt(holder -> ((AlchemyTableRecipe)holder.value()).getIngredients().size())).orElseGet(recipes::getFirst).value();
                    itemStack = recipe.getResultItem(null).copy();
                    this.setCurrentRecipe(recipe);
                }
                this.result.setItem(0, itemStack);
                this.setRemoteSlot(0, itemStack);
                serverPlayer.connection.send((Packet)new ClientboundContainerSetSlotPacket(this.containerId, this.incrementStateId(), 0, itemStack));
            }
        });
    }

    private void setCurrentRecipe(AlchemyTableRecipe recipe) {
        Slot slot = this.getSlot(0);
        if (slot instanceof ResultSlot) {
            ResultSlot amountResultSlot = (ResultSlot)slot;
            amountResultSlot.setCurrentRecipe(recipe);
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            Item item = itemstack1.getItem();
            itemstack = itemstack1.copy();
            if (index == 0) {
                item.onCraftedBy(itemstack1, player.level(), player);
                if (!this.moveItemStackTo(itemstack1, 8, 44, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (index < 8 ? !this.moveItemStackTo(itemstack1, 8, 44, false) : !this.moveItemStackTo(itemstack1, 1, 8, false) && (index < 35 ? !this.moveItemStackTo(itemstack1, 35, 44, false) : index < 44 && !this.moveItemStackTo(itemstack1, 8, 35, false))) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            }
            slot.setChanged();
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemstack1);
            this.broadcastChanges();
        }
        return itemstack;
    }

    public boolean stillValid(Player player) {
        return AlchemyTableMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)FunctionalBlocks.ALCHEMY_TABLE.get()));
    }

    public void removed(Player pPlayer) {
        super.removed(pPlayer);
        this.result.removeItemNoUpdate(0);
        this.access.execute((level, blockPos) -> {
            this.clearContainer(pPlayer, (Container)this.input);
            this.clearContainer(pPlayer, (Container)this.input.getMaterials());
        });
    }

    private static class ResultSlot
    extends Slot {
        private static final float CHANCE = 0.33333334f;
        protected final AlchemyTableRecipe.Input input;
        @Nullable
        protected AlchemyTableRecipe recipe;

        public ResultSlot(AlchemyTableRecipe.Input input, Container result, int pSlot, int pX, int pY) {
            super(result, pSlot, pX, pY);
            this.input = input;
        }

        public void setCurrentRecipe(@Nullable AlchemyTableRecipe recipe) {
            this.recipe = recipe;
        }

        public boolean mayPlace(ItemStack pStack) {
            return false;
        }

        public void onTake(Player pPlayer, ItemStack pStack) {
            if (this.recipe != null) {
                RandomSource random = pPlayer.getRandom();
                SimpleContainer materials = this.input.getMaterials();
                int size = materials.getContainerSize();
                ArrayList<Tuple> itemStacks = new ArrayList<Tuple>();
                for (int i = 0; i < size; ++i) {
                    if (!(random.nextFloat() < 0.33333334f)) continue;
                    itemStacks.add(new Tuple((Object)(i + 1), (Object)materials.getItem(i).copy()));
                }
                AbstractAmountRecipe.consumeShapeless((int)size, arg_0 -> ((SimpleContainer)materials).getItem(arg_0), this.recipe.getIngredients());
                for (Tuple back : itemStacks) {
                    this.input.setItem((Integer)back.getA(), (ItemStack)back.getB());
                }
                if (random.nextFloat() < 0.6666666f) {
                    this.input.removeItem(0, AmountIngredient.getAmount((Ingredient)this.recipe.getBase()));
                }
                this.input.setChanged();
            }
        }

        public boolean isFake() {
            return true;
        }
    }
}

