/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.menu;

import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import org.confluence.lib.common.menu.ContainerResultSlot;
import org.confluence.lib.common.menu.ForgeFuelSlot;

public abstract class EnhancedForgeMenu
extends AbstractContainerMenu {
    protected static final int INV_SLOT_START = 6;
    protected static final int INV_SLOT_END = 33;
    protected static final int USE_ROW_SLOT_START = 33;
    protected static final int USE_ROW_SLOT_END = 42;
    protected final Container forgeContainer;
    protected final ContainerData forgeData;

    public EnhancedForgeMenu(MenuType<?> menuType, int containerId, Inventory inventory) {
        this(menuType, containerId, inventory, (Container)new SimpleContainer(6), (ContainerData)new SimpleContainerData(5));
    }

    public EnhancedForgeMenu(MenuType<?> menuType, int containerId, Inventory inventory, Container forgeContainer, ContainerData forgeData) {
        super(menuType, containerId);
        EnhancedForgeMenu.checkContainerSize((Container)forgeContainer, (int)6);
        EnhancedForgeMenu.checkContainerDataCount((ContainerData)forgeData, (int)5);
        this.forgeContainer = forgeContainer;
        this.forgeData = forgeData;
        this.addSlot(new Slot(forgeContainer, 0, 47, 20));
        this.addSlot(new Slot(forgeContainer, 1, 65, 20));
        this.addSlot(new Slot(forgeContainer, 2, 47, 38));
        this.addSlot(new Slot(forgeContainer, 3, 65, 38));
        this.addSlot((Slot)new ForgeFuelSlot(this.getRecipeType(), forgeContainer, 4, 16, 52));
        this.addSlot((Slot)new ContainerResultSlot(forgeContainer, 5, 128, 35));
        for (int k = 0; k < 3; ++k) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)inventory, l + k * 9 + 9, 8 + l * 18, 84 + k * 18));
            }
        }
        for (int m = 0; m < 9; ++m) {
            this.addSlot(new Slot((Container)inventory, m, 8 + m * 18, 142));
        }
        this.addDataSlots(forgeData);
    }

    public boolean stillValid(Player player) {
        return this.forgeContainer.stillValid(player);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index == 5) {
                if (!this.moveItemStackTo(itemstack1, 6, 42, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (index > 4) {
                if (itemstack1.getBurnTime(this.getRecipeType()) > 0) {
                    if (!this.moveItemStackTo(itemstack1, 4, 5, false)) {
                        return ItemStack.EMPTY;
                    }
                } else if (!this.moveItemStackTo(itemstack1, 0, 4, false)) {
                    if (index < 33 ? !this.moveItemStackTo(itemstack1, 33, 42, false) : index < 42 && !this.moveItemStackTo(itemstack1, 6, 33, false)) {
                        return ItemStack.EMPTY;
                    }
                    return ItemStack.EMPTY;
                }
            } else if (!this.moveItemStackTo(itemstack1, 6, 42, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemstack1);
        }
        return itemstack;
    }

    protected abstract RecipeType<?> getRecipeType();

    public float getBurnProgress() {
        int i = this.forgeData.get(2);
        int j = this.forgeData.get(3);
        return j != 0 && i != 0 ? Mth.clamp((float)((float)i / (float)j), (float)0.0f, (float)1.0f) : 0.0f;
    }

    public float getLitProgress() {
        int i = this.forgeData.get(1);
        if (i == 0) {
            i = 100;
        }
        return Mth.clamp((float)((float)this.forgeData.get(0) / (float)i), (float)0.0f, (float)1.0f);
    }

    public boolean isLit() {
        return this.forgeData.get(0) > 0;
    }
}

