/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.menu;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.block.Block;
import org.confluence.lib.common.menu.EitherAmountContainerMenu4x;
import org.confluence.lib.common.menu.ToggleAmountResultSlot;
import org.confluence.lib.common.recipe.AbstractAmountRecipe;
import org.confluence.lib.common.recipe.EnvironmentLevelAccess;
import org.confluence.lib.common.recipe.EnvironmentRecipeInput;
import org.confluence.lib.common.recipe.MenuRecipeInput;
import org.confluence.mod.common.init.ModMenuTypes;
import org.confluence.mod.common.init.ModRecipes;
import org.confluence.mod.common.init.block.FunctionalBlocks;
import org.confluence.mod.common.recipe.HeavyWorkBenchRecipe;
import org.jetbrains.annotations.Nullable;

public class HeavyWorkBenchMenu
extends EitherAmountContainerMenu4x<EnvironmentRecipeInput, HeavyWorkBenchRecipe, ResultSlot, EnvironmentLevelAccess> {
    private List<RecipeHolder<CraftingRecipe>> craftingRecipes = new ArrayList<RecipeHolder<CraftingRecipe>>();

    public HeavyWorkBenchMenu(int containerId, Inventory inventory) {
        this(containerId, inventory, EnvironmentLevelAccess.empty());
    }

    public HeavyWorkBenchMenu(int containerId, Inventory inventory, EnvironmentLevelAccess access) {
        super(ModMenuTypes.HEAVY_WORK_BENCH.get(), ModRecipes.HEAVY_WORK_BENCH_TYPE.get(), containerId, inventory, (ContainerLevelAccess)access, (menu, size) -> {
            access.initializeIfNeeded(inventory.player);
            return new EnvironmentRecipeInput((AbstractContainerMenu)menu, size.intValue(), access);
        }, (input, container, slot, x, y, setup) -> new ResultSlot((MenuRecipeInput)input, (Container)container, (int)slot, (int)x, (int)y, (Runnable)setup){
            final /* synthetic */ Runnable val$setup;
            {
                this.val$setup = runnable;
                super(input, result, pSlot, pX, pY);
            }

            protected void updateMenu() {
                this.val$setup.run();
            }
        });
    }

    public int getRecipesAmount() {
        return this.recipes.size() + this.craftingRecipes.size();
    }

    public ItemStack getUpResult() {
        int index = this.getUpIndex();
        if (index == -1) {
            return this.result.getItem(0);
        }
        int recipesSize = this.recipes.size();
        if (index < recipesSize) {
            return ((HeavyWorkBenchRecipe)((RecipeHolder)this.recipes.get(index)).value()).getResultItem((HolderLookup.Provider)this.player.registryAccess());
        }
        return ((CraftingRecipe)this.craftingRecipes.get(index - recipesSize).value()).getResultItem((HolderLookup.Provider)this.player.registryAccess());
    }

    public ItemStack getDownResult() {
        int index = this.getDownIndex();
        if (index == -1) {
            return this.result.getItem(0);
        }
        int recipesSize = this.recipes.size();
        if (index < recipesSize) {
            return ((HeavyWorkBenchRecipe)((RecipeHolder)this.recipes.get(index)).value()).getResultItem((HolderLookup.Provider)this.player.registryAccess());
        }
        return ((CraftingRecipe)this.craftingRecipes.get(index - recipesSize).value()).getResultItem((HolderLookup.Provider)this.player.registryAccess());
    }

    public void slotsChanged(Container container) {
        this.craftingRecipes = this.player.level().getRecipeManager().getRecipesFor(RecipeType.CRAFTING, (RecipeInput)((EnvironmentRecipeInput)this.input).asCraftingInput(true), this.player.level()).stream().filter(holder -> {
            Class clazz = ((CraftingRecipe)holder.value()).getClass();
            return clazz == ShapedRecipe.class || clazz == ShapelessRecipe.class;
        }).toList();
        this.recipes = this.player.level().getRecipeManager().getRecipesFor(this.recipeType, (RecipeInput)((EnvironmentRecipeInput)this.input), this.player.level());
        int totalSize = this.recipes.size() + this.craftingRecipes.size();
        if (this.selectedRecipeIndex.get() >= totalSize) {
            this.selectedRecipeIndex.set(totalSize - 1);
        }
        ((EnvironmentLevelAccess)this.access).execute((level, pos) -> {
            Player patt0$temp = this.player;
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                ItemStack itemStack = ItemStack.EMPTY;
                if (!this.recipes.isEmpty() || !this.craftingRecipes.isEmpty()) {
                    if (this.selectedRecipeIndex.get() == -1) {
                        this.selectedRecipeIndex.set(0);
                    }
                    if (this.recipes.isEmpty()) {
                        CraftingRecipe recipe = (CraftingRecipe)this.craftingRecipes.get(this.selectedRecipeIndex.get()).value();
                        itemStack = recipe.getResultItem((HolderLookup.Provider)this.player.registryAccess()).copy();
                        ((ResultSlot)this.resultSlot).setAltRecipe(recipe);
                    } else {
                        HeavyWorkBenchRecipe recipe = (HeavyWorkBenchRecipe)((RecipeHolder)this.recipes.get(this.selectedRecipeIndex.get())).value();
                        itemStack = recipe.getResultItem((HolderLookup.Provider)this.player.registryAccess()).copy();
                        ((ResultSlot)this.resultSlot).setCurrentRecipe(recipe);
                    }
                }
                this.result.setItem(0, itemStack);
                this.setRemoteSlot(0, itemStack);
                serverPlayer.connection.send((Packet)new ClientboundContainerSetSlotPacket(this.containerId, this.incrementStateId(), 0, itemStack));
            } else if (!this.recipes.isEmpty() && this.selectedRecipeIndex.get() == -1) {
                this.selectedRecipeIndex.set(0);
            }
        });
    }

    public void setupResultSlot() {
        block2: {
            ItemStack itemStack;
            block4: {
                int recipesSize;
                int index;
                block3: {
                    index = this.selectedRecipeIndex.get();
                    if (!this.isValidRecipeIndex(index)) break block2;
                    recipesSize = this.recipes.size();
                    if (index >= recipesSize) break block3;
                    HeavyWorkBenchRecipe recipe = (HeavyWorkBenchRecipe)((RecipeHolder)this.recipes.get(index)).value();
                    itemStack = recipe.getResultItem((HolderLookup.Provider)this.player.registryAccess());
                    if (!itemStack.isItemEnabled(this.player.level().enabledFeatures())) break block2;
                    ((ResultSlot)this.resultSlot).setCurrentRecipe(recipe);
                    break block4;
                }
                CraftingRecipe recipe = (CraftingRecipe)this.craftingRecipes.get(index - recipesSize).value();
                itemStack = recipe.getResultItem((HolderLookup.Provider)this.player.registryAccess());
                if (!itemStack.isItemEnabled(this.player.level().enabledFeatures())) break block2;
                ((ResultSlot)this.resultSlot).setAltRecipe(recipe);
            }
            this.result.setItem(0, itemStack.copy());
            this.broadcastChanges();
            return;
        }
        this.result.setItem(0, ItemStack.EMPTY);
    }

    public boolean stillValid(Player player) {
        return HeavyWorkBenchMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)FunctionalBlocks.HEAVY_WORK_BENCH.get()));
    }

    public static class ResultSlot
    extends ToggleAmountResultSlot<HeavyWorkBenchRecipe> {
        private CraftingRecipe altRecipe;

        public ResultSlot(MenuRecipeInput input, Container result, int pSlot, int pX, int pY) {
            super(input, result, pSlot, pX, pY);
        }

        public void onTake(Player player, ItemStack stack) {
            if (this.recipe != null) {
                ((HeavyWorkBenchRecipe)this.recipe).either.ifLeft(pattern -> AbstractAmountRecipe.consumeShaped((RecipeInput)this.input, (int)4, (int)4, (ShapedRecipePattern)pattern)).ifRight(ingredients -> AbstractAmountRecipe.consumeShapeless((RecipeInput)this.input, (NonNullList)ingredients));
                this.input.setChanged();
                this.updateMenu();
            }
            if (this.altRecipe != null && (this.altRecipe.getClass() == ShapedRecipe.class || this.altRecipe.getClass() == ShapelessRecipe.class)) {
                for (ItemStack itemStack : this.input.getItems()) {
                    itemStack.shrink(1);
                }
                this.input.setChanged();
                this.updateMenu();
            }
        }

        public void setCurrentRecipe(@Nullable HeavyWorkBenchRecipe recipe) {
            super.setCurrentRecipe((AbstractAmountRecipe)recipe);
            this.altRecipe = null;
        }

        public void setAltRecipe(CraftingRecipe recipe) {
            this.altRecipe = recipe;
            this.recipe = null;
        }
    }
}

