/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.menu;

import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.confluence.lib.common.menu.IToggleSlot;
import org.confluence.terra_curio.common.init.TCTags;
import org.confluence.terra_curio.common.item.curio.BaseCurioItem;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class ToggleCurioSlot
extends Slot
implements IToggleSlot {
    public boolean isActive = true;
    private final Player player;

    public ToggleCurioSlot(Player player, Container container, int slot, int x, int y) {
        super(container, slot, x, y);
        this.player = player;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean mayPlace(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof BaseCurioItem) {
            BaseCurioItem baseCurioItem = (BaseCurioItem)item;
            return baseCurioItem.canEquip(new SlotContext("accessory", (LivingEntity)this.player, this.getSlotIndex(), false, true), stack);
        }
        return stack.is(TCTags.ACCESSORY);
    }

    public boolean mayPickup(Player player) {
        ItemStack itemstack = this.getItem();
        return (itemstack.isEmpty() || player.isCreative() || !EnchantmentHelper.has((ItemStack)itemstack, (DataComponentType)EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE)) && super.mayPickup(player);
    }

    public void setEnable(boolean enable) {
        this.isActive = enable;
    }

    public boolean isEnabled() {
        return this.isActive;
    }

    public static class WrappedContainer
    implements Container {
        private final IDynamicStackHandler handler;

        public WrappedContainer(ICurioStacksHandler handler) {
            this.handler = handler.getStacks();
        }

        public int getContainerSize() {
            return this.handler.getSlots();
        }

        public boolean isEmpty() {
            for (int i = 0; i < this.handler.getSlots(); ++i) {
                if (this.handler.getStackInSlot(i).isEmpty()) continue;
                return false;
            }
            return true;
        }

        public ItemStack getItem(int slot) {
            return this.handler.getStackInSlot(slot);
        }

        public ItemStack removeItem(int slot, int amount) {
            return this.handler.extractItem(slot, amount, false);
        }

        public ItemStack removeItemNoUpdate(int slot) {
            ItemStack itemStack = this.getItem(slot);
            this.handler.setStackInSlot(slot, ItemStack.EMPTY);
            this.handler.setPreviousStackInSlot(slot, ItemStack.EMPTY);
            return itemStack;
        }

        public void setItem(int slot, ItemStack stack) {
            this.handler.setStackInSlot(slot, stack);
        }

        public void setChanged() {
        }

        public boolean stillValid(Player player) {
            return true;
        }

        public void clearContent() {
        }
    }
}

