/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.particle;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.confluence.mod.common.init.ModParticleTypes;
import org.confluence.mod.mixed.IDamageSource;
import org.jetbrains.annotations.NotNull;

public record DamageIndicatorOptions(Component text, boolean big, Type type) implements ParticleOptions
{
    public static final MapCodec<DamageIndicatorOptions> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ComponentSerialization.CODEC.fieldOf("text").forGetter(thisOptions -> thisOptions.text), (App)Codec.BOOL.fieldOf("big").forGetter(options -> options.big), (App)Type.CODEC.fieldOf("type").forGetter(options -> options.type)).apply((Applicative)instance, DamageIndicatorOptions::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, DamageIndicatorOptions> STREAM_CODEC = StreamCodec.composite((StreamCodec)ComponentSerialization.STREAM_CODEC, opt -> opt.text, (StreamCodec)ByteBufCodecs.BOOL, opt -> opt.big, Type.STREAM_CODEC, opt -> opt.type, DamageIndicatorOptions::new);

    @NotNull
    public ParticleType<?> getType() {
        return ModParticleTypes.DAMAGE_INDICATOR.get();
    }

    public static void sendDamageParticle(ServerLevel serverLevel, DamageSource damageSource, float amount, LivingEntity victim) {
        if (damageSource.is(DamageTypes.GENERIC_KILL)) {
            return;
        }
        float roundedAmount = (float)Math.round(amount * 10.0f) / 10.0f;
        int intAmount = (int)roundedAmount;
        if (roundedAmount == 0.0f) {
            return;
        }
        String text = roundedAmount % 1.0f == 0.0f ? String.valueOf(intAmount) : String.valueOf(roundedAmount);
        Vec3 pos = victim.position();
        boolean crit = ((IDamageSource)damageSource).confluence$isCritical();
        MutableComponent component = Component.literal((String)text).withStyle(new ChatFormatting[]{crit ? ChatFormatting.DARK_RED : ChatFormatting.GOLD, ChatFormatting.BOLD});
        serverLevel.sendParticles((ParticleOptions)new DamageIndicatorOptions((Component)component, crit, Type.DAMAGE), pos.x, victim.getBoundingBoxForCulling().maxY, pos.z, 1, 0.1, 0.1, 0.1, 0.0);
    }

    public static void sendHealParticle(float amount, ServerLevel level, LivingEntity living) {
        if (living.getHealth() < living.getMaxHealth()) {
            double y = living.getBoundingBoxForCulling().maxY;
            Vec3 pos = living.position();
            String text = (amount = (float)Math.round(amount * 10.0f) / 10.0f) % 1.0f == 0.0f ? Integer.toString((int)amount) : Float.toString(amount);
            MutableComponent component = Component.literal((String)text).withStyle(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.BOLD});
            level.sendParticles((ParticleOptions)new DamageIndicatorOptions((Component)component, false, Type.HEAL), pos.x, y, pos.z, 1, 0.1, 0.1, 0.1, 0.0);
        }
    }

    public static enum Type {
        DAMAGE,
        HEAL,
        OTHER;

        public static final Codec<Type> CODEC;
        public static final StreamCodec<ByteBuf, Type> STREAM_CODEC;

        public static Type byId(byte i) {
            return i == 0 ? DAMAGE : (i == 1 ? HEAL : OTHER);
        }

        static {
            CODEC = Codec.BYTE.xmap(Type::byId, t -> (byte)t.ordinal());
            STREAM_CODEC = ByteBufCodecs.BYTE.map(Type::byId, t -> (byte)t.ordinal());
        }
    }
}

