/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.recipe;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import org.confluence.lib.common.recipe.AbstractAmountRecipe;
import org.confluence.lib.common.recipe.ItemStackHandlerRecipeInput;
import org.confluence.mod.common.init.ModRecipes;
import org.confluence.mod.common.init.block.FunctionalBlocks;

public class AltarRecipe
extends AbstractAmountRecipe<ItemStackHandlerRecipeInput> {
    public AltarRecipe(ItemStack pResult, NonNullList<Ingredient> pIngredients) {
        super(pResult, pIngredients);
    }

    protected int maxIngredientSize() {
        return 5;
    }

    public RecipeSerializer<?> getSerializer() {
        return ModRecipes.ALTAR_SERIALIZER.get();
    }

    public String getGroup() {
        return "altar";
    }

    public RecipeType<?> getType() {
        return ModRecipes.ALTAR_TYPE.get();
    }

    public ItemStack getToastSymbol() {
        return FunctionalBlocks.DEMON_ALTAR.toStack();
    }

    public static class Serializer
    implements RecipeSerializer<AltarRecipe> {
        public static final MapCodec<AltarRecipe> CODEC = AbstractAmountRecipe.shapelessSerializerMapCodec(AltarRecipe::new);
        public static final StreamCodec<RegistryFriendlyByteBuf, AltarRecipe> STREAM_CODEC = AbstractAmountRecipe.shapelessSerializerSteamCodec(AltarRecipe::new);

        public MapCodec<AltarRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, AltarRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

