/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Function5;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import org.confluence.lib.common.recipe.AbstractAmountRecipe;
import org.confluence.lib.common.recipe.AmountIngredient;

public abstract class EnhancedForgeRecipe
extends AbstractAmountRecipe<RecipeInput> {
    protected final float experience;
    protected final int cookingTime;
    protected final boolean requiresFuel;

    public EnhancedForgeRecipe(ItemStack result, NonNullList<Ingredient> ingredients, float experience, int cookingTime, boolean requiresFuel) {
        super(result, ingredients);
        this.experience = experience;
        this.cookingTime = cookingTime;
        this.requiresFuel = requiresFuel;
    }

    public float getExperience() {
        return this.experience;
    }

    public int getCookingTime() {
        return this.cookingTime;
    }

    public boolean isRequiresFuel() {
        return this.requiresFuel;
    }

    protected int maxIngredientSize() {
        return 4;
    }

    public static <R extends EnhancedForgeRecipe> MapCodec<R> codec(Factory<R> factory) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)INGREDIENTS_CODEC.forGetter(AbstractAmountRecipe::getIngredients), (App)Codec.FLOAT.lenientOptionalFieldOf("experience", (Object)Float.valueOf(0.0f)).forGetter(EnhancedForgeRecipe::getExperience), (App)Codec.INT.lenientOptionalFieldOf("cookingtime", (Object)100).forGetter(EnhancedForgeRecipe::getCookingTime), (App)Codec.BOOL.lenientOptionalFieldOf("requires_fuel", (Object)false).forGetter(EnhancedForgeRecipe::isRequiresFuel)).apply((Applicative)instance, (Function5)factory));
    }

    public static <R extends EnhancedForgeRecipe> StreamCodec<RegistryFriendlyByteBuf, R> streamCodec(final Factory<R> factory) {
        return new StreamCodec<RegistryFriendlyByteBuf, R>(){

            public R decode(RegistryFriendlyByteBuf buffer) {
                int size = buffer.readVarInt();
                NonNullList nonnulllist = NonNullList.withSize((int)size, (Object)AmountIngredient.EMPTY);
                nonnulllist.replaceAll(ignore -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer));
                ItemStack itemstack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
                return factory.create(itemstack, (NonNullList<Ingredient>)nonnulllist, buffer.readFloat(), buffer.readVarInt(), buffer.readBoolean());
            }

            public void encode(RegistryFriendlyByteBuf buffer, R recipe) {
                buffer.writeVarInt(((EnhancedForgeRecipe)((Object)recipe)).ingredients.size());
                for (Ingredient ingredient : ((EnhancedForgeRecipe)((Object)recipe)).ingredients) {
                    Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)ingredient);
                }
                ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)((EnhancedForgeRecipe)((Object)recipe)).result);
                buffer.writeFloat(((EnhancedForgeRecipe)((Object)recipe)).experience);
                buffer.writeVarInt(((EnhancedForgeRecipe)((Object)recipe)).cookingTime);
                buffer.writeBoolean(((EnhancedForgeRecipe)((Object)recipe)).requiresFuel);
            }
        };
    }

    public static interface Factory<R extends EnhancedForgeRecipe>
    extends Function5<ItemStack, NonNullList<Ingredient>, Float, Integer, Boolean, R> {
        public R create(ItemStack var1, NonNullList<Ingredient> var2, float var3, int var4, boolean var5);

        default public R apply(ItemStack itemStack, NonNullList<Ingredient> ingredients, Float aFloat, Integer integer, Boolean aBoolean) {
            return this.create(itemStack, ingredients, aFloat.floatValue(), integer, aBoolean);
        }
    }
}

