/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.confluence.mod.common.init.ModRecipes;
import org.confluence.mod.common.menu.FletchingTableMenu;
import org.jetbrains.annotations.Nullable;

public class FletchingTableRecipe
implements Recipe<Input> {
    private final ItemStack result;
    private final Ingredient tail;
    private final Ingredient body;
    private final Ingredient head;
    private final NonNullList<Ingredient> ingredients;

    public FletchingTableRecipe(ItemStack result, Ingredient tail, Ingredient body, Ingredient head) {
        this.result = result;
        this.tail = tail;
        this.body = body;
        this.head = head;
        this.ingredients = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{tail, body, head});
    }

    public boolean matches(Input input, Level level) {
        return this.tail.test(input.getTail()) && this.body.test(input.getBody()) && this.head.test(input.getHead());
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public Ingredient getTail() {
        return this.tail;
    }

    public Ingredient getBody() {
        return this.body;
    }

    public Ingredient getHead() {
        return this.head;
    }

    public ItemStack assemble(Input input, HolderLookup.Provider registries) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(@Nullable HolderLookup.Provider registries) {
        return this.result;
    }

    public RecipeSerializer<?> getSerializer() {
        return ModRecipes.FLETCHING_TABLE_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return ModRecipes.FLETCHING_TABLE_TYPE.get();
    }

    public static class Input
    extends SimpleContainer
    implements RecipeInput {
        private final FletchingTableMenu menu;

        public Input(FletchingTableMenu menu) {
            super(3);
            this.menu = menu;
        }

        public void setTail(ItemStack tail) {
            this.setItem(0, tail);
        }

        public ItemStack getTail() {
            return this.getItem(0);
        }

        public void setBody(ItemStack body) {
            this.setItem(1, body);
        }

        public ItemStack getBody() {
            return this.getItem(1);
        }

        public void setHead(ItemStack head) {
            this.setItem(2, head);
        }

        public ItemStack getHead() {
            return this.getItem(2);
        }

        public void setChanged() {
            super.setChanged();
            this.menu.slotsChanged((Container)this);
        }

        public int size() {
            return this.getContainerSize();
        }
    }

    public static class Serializer
    implements RecipeSerializer<FletchingTableRecipe> {
        public static final MapCodec<FletchingTableRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)Ingredient.CODEC_NONEMPTY.lenientOptionalFieldOf("tail", (Object)Ingredient.EMPTY).forGetter(recipe -> recipe.tail), (App)Ingredient.CODEC_NONEMPTY.lenientOptionalFieldOf("body", (Object)Ingredient.EMPTY).forGetter(recipe -> recipe.body), (App)Ingredient.CODEC_NONEMPTY.lenientOptionalFieldOf("head", (Object)Ingredient.EMPTY).forGetter(recipe -> recipe.head)).apply((Applicative)instance, FletchingTableRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, FletchingTableRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<FletchingTableRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, FletchingTableRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static FletchingTableRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            ItemStack itemstack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            Ingredient tail = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            Ingredient body = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            Ingredient head = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            return new FletchingTableRecipe(itemstack, tail, body, head);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, FletchingTableRecipe recipe) {
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.tail);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.body);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.head);
        }
    }
}

