/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.recipe.special;

import com.mojang.serialization.MapCodec;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.confluence.lib.ConfluenceMagicLib;
import org.confluence.lib.common.component.NbtComponent;
import org.confluence.lib.util.LibStreamCodecUtils;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.common.init.ModRecipes;
import org.confluence.mod.common.init.item.ConsumableItems;
import org.confluence.mod.common.init.item.ModItems;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BoomBunnyRecipe
extends ShapelessRecipe {
    private static BoomBunnyRecipe INSTANCE;

    private BoomBunnyRecipe() {
        super("", CraftingBookCategory.MISC, ModItems.ENTITY_DISPLAY.toStack(), NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{ModItems.ENTITY_DISPLAY}), Ingredient.of((ItemLike[])new ItemLike[]{ConsumableItems.DYNAMITE})}));
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.BOOM_BUNNY_SERIALIZER.get();
    }

    public boolean matches(CraftingInput input, Level level) {
        if (super.matches(input, level)) {
            for (int i = 0; i < input.ingredientCount(); ++i) {
                String id;
                CompoundTag tag;
                ItemStack itemStack = input.getItem(i);
                if (itemStack.isEmpty() || !itemStack.is(ModItems.ENTITY_DISPLAY) || (tag = LibUtils.getItemStackNbtIfPresent((ItemStack)itemStack)) == null || !"terra_entity:bunny".equals(id = tag.getString("id")) && !"minecraft:rabbit".equals(id)) continue;
                return true;
            }
        }
        return false;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        ItemStack assemble = super.assemble(input, registries);
        for (int i = 0; i < input.ingredientCount(); ++i) {
            CompoundTag tag;
            ItemStack itemStack = input.getItem(i);
            if (itemStack.isEmpty() || !itemStack.is(ModItems.ENTITY_DISPLAY) || (tag = LibUtils.getItemStackNbtIfPresent((ItemStack)itemStack)) == null) continue;
            tag = tag.copy();
            tag.putString("id", "terra_entity:boom_bunny");
            tag.putUUID("UUID", Mth.createInsecureUUID());
            assemble.set(ConfluenceMagicLib.NBT, (Object)new NbtComponent(tag));
            assemble.set(DataComponents.CUSTOM_NAME, (Object)((Component)itemStack.get(DataComponents.CUSTOM_NAME)));
            assemble.remove(ConfluenceMagicLib.MOD_RARITY);
            break;
        }
        return assemble;
    }

    public boolean isSpecial() {
        return true;
    }

    public boolean isIncomplete() {
        return false;
    }

    public static BoomBunnyRecipe getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new BoomBunnyRecipe();
        }
        return INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<BoomBunnyRecipe> {
        public static final MapCodec<BoomBunnyRecipe> CODEC = MapCodec.unit(BoomBunnyRecipe::getInstance);
        public static final StreamCodec<RegistryFriendlyByteBuf, BoomBunnyRecipe> STREAM_CODEC = LibStreamCodecUtils.unit(BoomBunnyRecipe::getInstance);

        public MapCodec<BoomBunnyRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, BoomBunnyRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

