/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import org.confluence.lib.common.data.IdFixer;
import org.confluence.mod.common.worldgen.BannedBiomeMultiNoiseBiomeSource;

public class BannedBiomeNoiseBasedChunkGenerator
extends NoiseBasedChunkGenerator {
    public static final MapCodec<BannedBiomeNoiseBasedChunkGenerator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)MultiNoiseBiomeSource.CODEC.fieldOf("biome_source").forGetter(BannedBiomeNoiseBasedChunkGenerator::getBiomeSource), (App)NoiseGeneratorSettings.CODEC.fieldOf("settings").forGetter(NoiseBasedChunkGenerator::generatorSettings), (App)ResourceKey.codec((ResourceKey)Registries.BIOME).mapResult(IdFixer.FIX_BIOME_KEY_FUNC).fieldOf("banned_biome").forGetter(generator -> generator.bannedBiome), (App)ResourceKey.codec((ResourceKey)Registries.BIOME).mapResult(IdFixer.FIX_BIOME_KEY_FUNC).fieldOf("target_biome").forGetter(generator -> generator.targetBiome)).apply((Applicative)instance, BannedBiomeNoiseBasedChunkGenerator::new));
    public final ResourceKey<Biome> bannedBiome;
    public final ResourceKey<Biome> targetBiome;

    public BannedBiomeNoiseBasedChunkGenerator(MultiNoiseBiomeSource biomeSource, Holder<NoiseGeneratorSettings> settingsHolder, ResourceKey<Biome> bannedBiome, ResourceKey<Biome> targetBiome) {
        super((BiomeSource)new BannedBiomeMultiNoiseBiomeSource(biomeSource, bannedBiome, targetBiome), settingsHolder);
        this.bannedBiome = bannedBiome;
        this.targetBiome = targetBiome;
    }

    public MultiNoiseBiomeSource getBiomeSource() {
        return (MultiNoiseBiomeSource)super.getBiomeSource();
    }

    protected MapCodec<BannedBiomeNoiseBasedChunkGenerator> codec() {
        return CODEC;
    }
}

