/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.worldgen;

import com.mojang.serialization.MapCodec;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import org.confluence.mod.api.SecretFlagMatcher;
import org.confluence.mod.common.init.ModFeatures;

public class SecretFlagPlacement
extends PlacementModifier
implements SecretFlagMatcher {
    public static final MapCodec<SecretFlagPlacement> CODEC = SecretFlagMatcher.createMapCodec(SecretFlagPlacement::new);
    private final long flag;
    private final boolean flip;

    public SecretFlagPlacement(long flag, boolean flip) {
        this.flag = flag;
        this.flip = flip;
    }

    public static SecretFlagPlacement of(long flag) {
        return new SecretFlagPlacement(flag, false);
    }

    public static SecretFlagPlacement of(long flag, boolean flip) {
        return new SecretFlagPlacement(flag, flip);
    }

    public Stream<BlockPos> getPositions(PlacementContext context, RandomSource random, BlockPos pos) {
        return this.matchesSecretFlag() ? Stream.of(pos) : Stream.empty();
    }

    public PlacementModifierType<?> type() {
        return ModFeatures.SECRET_FLAG_PLACEMENT_MODIFIER.get();
    }

    @Override
    public long secretFlag() {
        return this.flag;
    }

    @Override
    public boolean flipMatch() {
        return this.flip;
    }
}

