/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.worldgen.carver;

import com.mojang.serialization.Codec;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.carver.CarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.carver.WorldCarver;
import net.minecraft.world.phys.Vec3;
import org.confluence.mod.common.block.natural.spreadable.MushroomGrassBlock;
import org.confluence.mod.common.init.block.NatureBlocks;

public class GlowingMushroomCaveCarver
extends WorldCarver<CarverConfiguration> {
    public GlowingMushroomCaveCarver(Codec<CarverConfiguration> codec) {
        super(codec);
    }

    public boolean carve(CarvingContext context, CarverConfiguration config, final ChunkAccess chunk, Function<BlockPos, Holder<Biome>> biomeAccessor, RandomSource random, Aquifer aquifer, ChunkPos chunkPos, CarvingMask carvingMask) {
        WorldCarver.CarveSkipChecker checker = (context1, relativeX, relativeY, relativeZ, y) -> {
            if (relativeY < -0.25) {
                return true;
            }
            return relativeX * relativeX + relativeY * relativeY + relativeZ * relativeZ > 1.0;
        };
        Aquifer outer = new Aquifer(){
            final BlockState mud = Blocks.MUD.defaultBlockState();
            final BlockState grass = ((MushroomGrassBlock)NatureBlocks.MUSHROOM_GRASS_BLOCK.get()).defaultBlockState();
            final BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();

            public BlockState computeSubstance(DensityFunction.FunctionContext context, double substance) {
                this.pos.set(context.blockX(), context.blockY(), context.blockZ());
                if (chunk.getBlockState((BlockPos)this.pos).isAir()) {
                    return null;
                }
                return chunk.getBlockState((BlockPos)this.pos.move(0, 1, 0)).isAir() ? this.grass : this.mud;
            }

            public boolean shouldScheduleFluidUpdate() {
                return false;
            }
        };
        float y2 = config.y.sample(random, (WorldGenerationContext)context);
        float yScale = config.yScale.sample(random);
        final BlockState air = Blocks.AIR.defaultBlockState();
        final BlockState grass = ((MushroomGrassBlock)NatureBlocks.MUSHROOM_GRASS_BLOCK.get()).defaultBlockState();
        for (int i = 0; i < 4; ++i) {
            final Vec3 position = chunkPos.getMiddleBlockPosition((int)(y2 += random.nextFloat() * yScale)).getCenter().add(Mth.nextDouble((RandomSource)random, (double)-8.0, (double)8.0), 0.0, Mth.nextDouble((RandomSource)random, (double)-8.0, (double)8.0));
            Aquifer inner = new Aquifer(){

                public BlockState computeSubstance(DensityFunction.FunctionContext context, double substance) {
                    return (double)context.blockY() >= position.y + 2.0 ? air : grass;
                }

                public boolean shouldScheduleFluidUpdate() {
                    return true;
                }
            };
            double horizontalRadius = Mth.nextDouble((RandomSource)random, (double)(yScale + 2.0f), (double)((yScale + 2.0f) * 2.0f));
            double verticalRadius = Mth.nextDouble((RandomSource)random, (double)yScale, (double)(yScale * 2.0f));
            this.carveEllipsoid(context, config, chunk, biomeAccessor, outer, position.x, position.y, position.z, horizontalRadius, verticalRadius, new CarvingMask(chunk.getHeight(), chunk.getMinBuildHeight()), checker);
            this.carveEllipsoid(context, config, chunk, biomeAccessor, inner, position.x, position.y + 2.0, position.z, horizontalRadius - 4.0, verticalRadius - 3.0, new CarvingMask(chunk.getHeight(), chunk.getMinBuildHeight()), checker);
        }
        return true;
    }

    public boolean isStartChunk(CarverConfiguration config, RandomSource random) {
        return random.nextFloat() < config.probability;
    }
}

