/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.worldgen.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.confluence.lib.util.FeatureUtils;

public class BaobabTreeFeature
extends Feature<Config> {
    public BaobabTreeFeature(Codec<Config> pCodec) {
        super(pCodec);
    }

    private static void setLeaves(BlockPos startPos, int size1, BlockState leaves, RandomSource random, WorldGenLevel level) {
        int x = startPos.getX();
        int y = startPos.getY();
        int z = startPos.getZ();
        int size = Math.max(size1, 1);
        HashSet<BlockPos> rootSet = new HashSet<BlockPos>();
        HashSet trunkSet = new HashSet();
        HashSet leavesSet = new HashSet();
        rootSet.add(startPos);
        BoundingBox boxDown = new BoundingBox(x - size1, y, z - size1, x + size1, y, z + size1);
        BoundingBox boxUp = new BoundingBox(x - 1, y + 1, z - 1, x + 1, y + 1, z + 1);
        BoundingBox box = new BoundingBox(x - size, y, z - size, x + size, y + 1, z + size);
        FeatureUtils.leaves((BoundingBox)boxDown, (BlockState)leaves, (boolean)true, (RandomSource)random, (WorldGenLevel)level, (BlockState)Blocks.AIR.defaultBlockState(), (boolean)false);
        FeatureUtils.leaves((BoundingBox)boxUp, (BlockState)leaves, (boolean)true, (RandomSource)random, (WorldGenLevel)level, (BlockState)Blocks.AIR.defaultBlockState(), (boolean)false);
        TreeFeature.updateLeaves((LevelAccessor)level, (BoundingBox)box, rootSet, trunkSet, leavesSet);
    }

    public boolean place(FeaturePlaceContext<Config> pContext) {
        RandomSource random = pContext.random();
        Config config = (Config)pContext.config();
        WorldGenLevel level = pContext.level();
        BlockPos baseBlockPos = pContext.origin();
        BlockState trunkBlockState = config.trunk().getState(random, baseBlockPos);
        BlockState branchBlockState = config.branch().getState(random, baseBlockPos);
        BlockState rootBlockState = config.root().getState(random, baseBlockPos);
        BlockState innerBlockState = config.inner().getState(random, baseBlockPos);
        BlockState leavesBlockState = config.leaves().getState(random, baseBlockPos);
        int height = config.height + random.nextInt(3);
        int xMin = baseBlockPos.getX() - 1;
        int xMax = baseBlockPos.getX() + 2;
        int zMin = baseBlockPos.getZ() - 1;
        int zMax = baseBlockPos.getZ() + 2;
        ArrayList<BlockPos> trunkPosList = new ArrayList<BlockPos>();
        ArrayList<BlockPos> rootPosList = new ArrayList<BlockPos>();
        ArrayList<BlockPos> leavesPosList = new ArrayList<BlockPos>();
        for (int y = 0; y < height; ++y) {
            for (int x = -1; x < 3; ++x) {
                for (int z = -1; z < 3; ++z) {
                    trunkPosList.add(baseBlockPos.offset(x, y, z));
                }
            }
        }
        boolean placed = true;
        for (int k = 0; k < trunkPosList.size() && placed; ++k) {
            placed = level.getBlockState((BlockPos)trunkPosList.get(k)).canBeReplaced() || level.getBlockState((BlockPos)trunkPosList.get(k)).is(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"leaves")));
        }
        for (int kx = -1; kx < 3; ++kx) {
            for (int kz = -1; kz < 3; ++kz) {
                placed = level.getBlockState(baseBlockPos.offset(kx, -1, kz)).is(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"dirt"))) && placed;
            }
        }
        if (placed) {
            for (BlockPos pos : trunkPosList) {
                level.setBlock(pos, trunkBlockState, 3);
            }
            for (int y = 1; y < height - 1; ++y) {
                for (int x = 0; x < 2; ++x) {
                    for (int z = 0; z < 2; ++z) {
                        level.setBlock(baseBlockPos.offset(x, y, z), innerBlockState, 3);
                    }
                }
            }
            for (int i = 0; i < 8; ++i) {
                boolean rootOrBranch = i / 4 == 0;
                BlockState placeRootOrBranch = rootOrBranch ? rootBlockState : branchBlockState;
                int branchLength = rootOrBranch ? 3 : 6;
                boolean rootPlace = !rootOrBranch;
                int xOffset = -1 * (int)Mth.cos((float)((float)i * (float)Math.PI / 2.0f));
                int zOffset = -1 * (int)Mth.sin((float)((float)i * (float)Math.PI / 2.0f));
                BlockState placeXZ = (BlockState)placeRootOrBranch.trySetValue((Property)BlockStateProperties.AXIS, (Comparable)(Mth.abs((int)xOffset) == 1 ? Direction.Axis.X : Direction.Axis.Z));
                int end = Mth.abs((int)xOffset) == 1 ? (xOffset == 1 ? xMin : xMax) : (zOffset == 1 ? zMin : zMax);
                BlockPos rootPosEnd = baseBlockPos.offset(branchLength * (int)Mth.cos((float)((float)i * (float)Math.PI / 2.0f)) + random.nextInt(2), 0, branchLength * (int)Mth.sin((float)((float)i * (float)Math.PI / 2.0f)) + random.nextInt(2));
                BlockPos rootPosPlace = rootPosEnd.offset(0, rootOrBranch ? 0 : height - 1, 0);
                int rootHeight = 0;
                int j = 0;
                while (j < 5 && !rootPlace) {
                    rootPosPlace = rootPosEnd.offset(0, -j, 0);
                    rootPlace = level.getBlockState(rootPosPlace).canBeReplaced() && level.getBlockState(rootPosPlace.offset(0, -1, 0)).is(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"dirt")));
                    rootHeight = j++;
                }
                rootHeight += random.nextInt(3) + 2;
                rootPosPlace = rootPosPlace.offset(0, rootOrBranch || random.nextInt(4) != 3 ? 0 : -height / 2 + 1, 0);
                for (j = 0; j < rootHeight; ++j) {
                    rootPosList.add(rootPosPlace.offset(0, j, 0));
                    rootPlace = level.getBlockState(rootPosPlace.offset(0, j, 0)).canBeReplaced() && rootPlace;
                }
                BlockPos transitionPos = ((BlockPos)rootPosList.getLast()).offset(xOffset, -(rootOrBranch ? 0 : rootHeight - 1), zOffset);
                int transitionLength = Mth.abs((int)(end - (Mth.abs((int)xOffset) == 1 ? transitionPos.getX() : transitionPos.getZ())));
                if (transitionLength == 0) {
                    if (rootPlace) {
                        for (j = 0; j < rootPosList.size(); ++j) {
                            level.setBlock((BlockPos)rootPosList.get(j), placeRootOrBranch, 3);
                            if (j + 1 != rootPosList.size() || rootOrBranch) continue;
                            leavesPosList.add((BlockPos)rootPosList.get(j));
                        }
                    }
                } else {
                    for (j = 0; j < transitionLength; ++j) {
                        rootPlace = level.getBlockState(transitionPos.offset(xOffset * j, 0, zOffset * j)).canBeReplaced() && rootPlace;
                    }
                    if (rootPlace) {
                        for (j = 0; j < rootPosList.size(); ++j) {
                            level.setBlock((BlockPos)rootPosList.get(j), placeRootOrBranch, 3);
                            if (j + 1 != rootPosList.size() || rootOrBranch) continue;
                            leavesPosList.add((BlockPos)rootPosList.get(j));
                        }
                        for (j = 0; j < transitionLength; ++j) {
                            level.setBlock(transitionPos.offset(xOffset * j, 0, zOffset * j), placeXZ, 3);
                        }
                    }
                }
                rootPosList.clear();
            }
            for (BlockPos blockPos : leavesPosList) {
                BaobabTreeFeature.setLeaves(blockPos, 2 + random.nextInt(2), leavesBlockState, random, level);
            }
            return true;
        }
        return false;
    }

    public record Config(BlockStateProvider trunk, BlockStateProvider branch, BlockStateProvider root, BlockStateProvider leaves, BlockStateProvider inner, int height) implements FeatureConfiguration
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockStateProvider.CODEC.fieldOf("trunk_block").forGetter(Config::trunk), (App)BlockStateProvider.CODEC.fieldOf("branch_block").forGetter(Config::branch), (App)BlockStateProvider.CODEC.fieldOf("root_block").forGetter(Config::root), (App)BlockStateProvider.CODEC.fieldOf("leaves_block").forGetter(Config::leaves), (App)BlockStateProvider.CODEC.fieldOf("inner_block").forGetter(Config::inner), (App)Codec.INT.fieldOf("height").forGetter(Config::height)).apply((Applicative)instance, Config::new));
    }
}

