/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.worldgen.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Column;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import org.confluence.lib.util.FeatureUtils;
import org.confluence.mod.common.block.functional.BoulderBlock;
import org.confluence.mod.common.block.functional.network.INetworkEntity;
import org.confluence.mod.common.init.ModFeatures;
import org.confluence.mod.common.init.block.FunctionalBlocks;

public class BoulderTrapFeature
extends Feature<Config> {
    public BoulderTrapFeature(Codec<Config> pCodec) {
        super(pCodec);
    }

    public boolean place(FeaturePlaceContext<Config> pContext) {
        BlockPos supportPos;
        Column.Range range;
        Object t;
        Optional optionalColumn;
        BlockPos blockPos;
        Config config = (Config)pContext.config();
        WorldGenLevel level = pContext.level();
        if (FeatureUtils.isPosAir((WorldGenLevel)level, (BlockPos)(blockPos = pContext.origin())) && (optionalColumn = Column.scan((LevelSimulatedReader)level, (BlockPos)blockPos, (int)config.maxBoulderHeight, BlockBehaviour.BlockStateBase::isAir, ModFeatures.IS_BASE_STONE)).isPresent() && (t = optionalColumn.get()) instanceof Column.Range && (range = (Column.Range)t).height() > 4 && FeatureUtils.isPosSturdy((WorldGenLevel)level, (BlockPos)(supportPos = blockPos.atY(range.floor())), (Direction)Direction.UP)) {
            BlockPos boulderPos = blockPos.atY(range.ceiling());
            Tuple<BlockPos, BlockState> pressurePlate = ModFeatures.getPressurePlate(level, supportPos);
            BlockPos platePos = (BlockPos)pressurePlate.getA();
            boolean b = FeatureUtils.safeSetBlock((WorldGenLevel)level, (BlockPos)boulderPos, (BlockState)ModFeatures.getBoulder(level, pContext.random(), config.boulder), ModFeatures.IS_REPLACEABLE);
            boolean b1 = FeatureUtils.safeSetBlock((WorldGenLevel)level, (BlockPos)platePos, (BlockState)((BlockState)pressurePlate.getB()), ModFeatures.IS_REPLACEABLE);
            if (b && b1) {
                INetworkEntity boulder = ModFeatures.getNetworkEntity(level, boulderPos);
                INetworkEntity plate = ModFeatures.getNetworkEntity(level, platePos);
                if (boulder != null && plate != null) {
                    boulder.connectTo(0xFF0000, platePos, plate);
                }
                return true;
            }
        }
        return false;
    }

    public record Config(BlockState boulder, int maxBoulderHeight) implements FeatureConfiguration
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockState.CODEC.fieldOf("boulder").orElseGet(() -> ((BoulderBlock)FunctionalBlocks.NORMAL_BOULDER.get()).defaultBlockState()).forGetter(Config::boulder), (App)ExtraCodecs.POSITIVE_INT.lenientOptionalFieldOf("max_boulder_height", (Object)64).forGetter(Config::maxBoulderHeight)).apply((Applicative)instance, Config::new));
    }
}

