/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.worldgen.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import org.confluence.lib.util.LibCodecUtils;
import org.confluence.lib.util.LibUtils;

public class CattailsFeature
extends Feature<Config> {
    public CattailsFeature(Codec<Config> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<Config> context) {
        RandomSource random = context.random();
        Config config = (Config)context.config();
        WorldGenLevel level = context.level();
        BlockPos origin = context.origin();
        BlockState head = config.cattailsHead.getState(random, origin);
        BlockState body = config.cattailsBody.getState(random, origin);
        int minY = level.getMinBuildHeight();
        int maxY = level.getMaxBuildHeight();
        int placed = 0;
        BlockPos.MutableBlockPos bottomPos = new BlockPos.MutableBlockPos();
        Direction dir = Direction.WEST;
        Direction.Axis axis = dir.getAxis();
        int lx = dir.getStepX();
        int lz = dir.getStepZ();
        int x = 0;
        int z = 0;
        int s = 1;
        for (int i = 0; i < config.maxCheck; ++i) {
            block9: {
                boolean condition;
                BlockPos.MutableBlockPos abovePos;
                block11: {
                    BlockState lastState;
                    int length;
                    BlockState state;
                    block10: {
                        boolean isStartInAir;
                        if (LibUtils.checkChance((double)config.chance, (RandomSource)random) || !(isStartInAir = (state = level.getBlockState((BlockPos)bottomPos.setWithOffset((Vec3i)origin, x, 0, z))).isAir()) && !state.is(Blocks.WATER)) break block9;
                        length = 1;
                        abovePos = new BlockPos.MutableBlockPos(bottomPos.getX(), bottomPos.getY(), bottomPos.getZ());
                        if (!isStartInAir) break block10;
                        do {
                            lastState = state;
                            state = level.getBlockState((BlockPos)bottomPos.move(0, -1, 0));
                        } while (++length <= config.maxLength && bottomPos.getY() > minY && (state.isAir() || state.is(Blocks.WATER)));
                        condition = lastState.is(Blocks.WATER);
                        bottomPos.move(0, 1, 0);
                        if (length == config.maxLength && (!condition || !body.canSurvive((LevelReader)level, (BlockPos)bottomPos))) break block9;
                        abovePos.move(0, config.maxLength - length, 0);
                        break block11;
                    }
                    do {
                        lastState = state;
                        state = level.getBlockState((BlockPos)bottomPos.move(0, -1, 0));
                    } while (++length < config.maxLength && bottomPos.getY() > minY && state.is(Blocks.WATER));
                    bottomPos.move(0, 1, 0);
                    if (length == config.maxLength || !lastState.is(Blocks.WATER) || !body.canSurvive((LevelReader)level, (BlockPos)bottomPos)) break block9;
                    do {
                        state = level.getBlockState((BlockPos)abovePos.move(0, 1, 0));
                    } while (++length <= config.maxLength && abovePos.getY() < maxY && (state.isAir() || state.is(Blocks.WATER)));
                    condition = state.isAir();
                }
                if (condition && body.canSurvive((LevelReader)level, (BlockPos)bottomPos)) {
                    for (int y = bottomPos.getY(); y < abovePos.getY(); ++y) {
                        level.setBlock((BlockPos)bottomPos.setY(y), (BlockState)body.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(level.getBlockState((BlockPos)bottomPos).is(Blocks.WATER))), 3);
                    }
                    level.setBlock((BlockPos)abovePos, (BlockState)head.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(level.getBlockState((BlockPos)abovePos).is(Blocks.WATER))), 3);
                    ++placed;
                }
            }
            if ((x += dir.getStepX()) != lx || (z += dir.getStepZ()) != lz) continue;
            dir = dir.getClockWise();
            lx += dir.getStepX() * s;
            lz += dir.getStepZ() * s;
            if (dir.getAxis() != axis) continue;
            s += 2;
        }
        return placed > 0;
    }

    public record Config(BlockStateProvider cattailsHead, BlockStateProvider cattailsBody, int radius, float chance, int maxLength, int maxCheck) implements FeatureConfiguration
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockStateProvider.CODEC.fieldOf("cattails_head").forGetter(Config::cattailsHead), (App)BlockStateProvider.CODEC.fieldOf("cattails_body").forGetter(Config::cattailsBody), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("radius").forGetter(Config::radius), (App)LibCodecUtils.floatRange((float)0.0f, (float)1.0f).fieldOf("chance").forGetter(Config::chance), (App)ExtraCodecs.POSITIVE_INT.fieldOf("max_length").forGetter(Config::maxLength), (App)ExtraCodecs.POSITIVE_INT.fieldOf("max_check").forGetter(Config::maxCheck)).apply((Applicative)instance, Config::new));
    }
}

