/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.worldgen.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import org.confluence.lib.util.FeatureUtils;

public class ColumnPatchFeature
extends Feature<Config> {
    public static final Predicate<BlockState> PREDICATE = blockState -> !blockState.isAir() && !blockState.is(BlockTags.FEATURES_CANNOT_REPLACE);

    public ColumnPatchFeature(Codec<Config> pCodec) {
        super(pCodec);
    }

    public boolean place(FeaturePlaceContext<Config> pContext) {
        Config config = (Config)pContext.config();
        WorldGenLevel level = pContext.level();
        RandomSource random = pContext.random();
        BlockPos blockPos = pContext.origin();
        if (FeatureUtils.isPosAir((WorldGenLevel)level, (BlockPos)blockPos)) {
            BlockPos.MutableBlockPos mutablePos = blockPos.mutable();
            for (int v = 1; v <= config.maxSearchHeight && FeatureUtils.isPosAir((WorldGenLevel)level, (BlockPos)mutablePos); ++v) {
                if (v == config.maxSearchHeight) {
                    return false;
                }
                mutablePos.move(Direction.DOWN);
            }
            return this.carvePatch(config, level, random, mutablePos, pContext.chunkGenerator().getMinY());
        }
        BlockPos.MutableBlockPos mutablePos = blockPos.mutable();
        for (int v = 1; v <= config.maxSearchHeight && !FeatureUtils.isPosAir((WorldGenLevel)level, (BlockPos)mutablePos); ++v) {
            if (v == config.maxSearchHeight) {
                return false;
            }
            mutablePos.move(Direction.UP);
        }
        return this.carvePatch(config, level, random, mutablePos, pContext.chunkGenerator().getMinY());
    }

    private boolean carvePatch(Config config, WorldGenLevel level, RandomSource random, BlockPos.MutableBlockPos mutablePos, int minY) {
        int ay;
        int radiusSqr = config.radius * config.radius;
        int ox = mutablePos.getX();
        int oy = mutablePos.getY();
        int oz = mutablePos.getZ();
        HashSet<BlockPos> air = new HashSet<BlockPos>();
        HashSet<BlockPos> ice = new HashSet<BlockPos>();
        for (int y = 1; y <= config.maxDepth && (ay = oy - y) >= minY; ++y) {
            mutablePos.setY(ay);
            for (int x = -config.radius; x <= config.radius; ++x) {
                int ax = ox + x;
                int radiusSqrSubXSqr = radiusSqr - x * x;
                mutablePos.setX(ax);
                for (int z = -config.radius; z <= config.radius; ++z) {
                    if (z * z > radiusSqrSubXSqr || !level.isStateAtPosition((BlockPos)mutablePos.setZ(oz + z), PREDICATE)) continue;
                    if (y <= 3) {
                        air.add(mutablePos.immutable());
                        continue;
                    }
                    ice.add(mutablePos.immutable());
                }
            }
        }
        if ((float)(air.size() + ice.size()) / ((float)(config.maxDepth * config.radius * config.radius) * (float)Math.PI) > config.successRatio) {
            BlockState airState = Blocks.AIR.defaultBlockState();
            air.forEach(blockPos -> level.setBlock(blockPos, airState, 3));
            ice.forEach(blockPos -> level.setBlock(blockPos, config.blockStateProvider.getState(random, blockPos), 3));
            return true;
        }
        return false;
    }

    public record Config(int stepHeight, int radius, int maxDepth, int maxSearchHeight, float successRatio, BlockStateProvider blockStateProvider) implements FeatureConfiguration
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.validate(i -> i >= 0 ? DataResult.success((Object)i) : DataResult.error(() -> "Value must be non-negative: " + i)).lenientOptionalFieldOf("step_height", (Object)3).forGetter(Config::stepHeight), (App)ExtraCodecs.POSITIVE_INT.lenientOptionalFieldOf("radius", (Object)4).forGetter(Config::radius), (App)ExtraCodecs.POSITIVE_INT.lenientOptionalFieldOf("max_depth", (Object)32).forGetter(Config::maxDepth), (App)ExtraCodecs.POSITIVE_INT.lenientOptionalFieldOf("max_search_height", (Object)32).forGetter(Config::maxDepth), (App)ExtraCodecs.POSITIVE_FLOAT.lenientOptionalFieldOf("success_ratio", (Object)Float.valueOf(0.5f)).forGetter(Config::successRatio), (App)BlockStateProvider.CODEC.fieldOf("block").forGetter(Config::blockStateProvider)).apply((Applicative)instance, Config::new));
    }
}

