/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.worldgen.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import org.confluence.lib.util.FeatureUtils;
import org.confluence.mod.common.block.functional.DetonatorBlock;
import org.confluence.mod.common.block.functional.InstantExplosionBlock;
import org.confluence.mod.common.block.functional.network.INetworkEntity;
import org.confluence.mod.common.init.ModFeatures;
import org.confluence.mod.common.init.block.FunctionalBlocks;

public class DetonatorFeature
extends Feature<Config> {
    public DetonatorFeature(Codec<Config> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<Config> context) {
        int mx = SectionPos.sectionToBlockCoord((int)SectionPos.blockToSectionCoord((int)context.origin().getX()), (int)8);
        int mz = SectionPos.sectionToBlockCoord((int)SectionPos.blockToSectionCoord((int)context.origin().getZ()), (int)8);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(mx, context.origin().getY(), mz);
        WorldGenLevel level = context.level();
        if (FeatureUtils.isPosAir((WorldGenLevel)level, (BlockPos)pos)) {
            Config config = (Config)context.config();
            for (int v = 1; v <= config.maxSearchDown && FeatureUtils.isPosAir((WorldGenLevel)level, (BlockPos)pos); ++v) {
                pos.move(0, -1, 0);
            }
            RandomSource random = context.random();
            if (!FeatureUtils.isPosLiquid((WorldGenLevel)level, (BlockPos)pos) && ((ConfiguredFeature)config.oreFeature.value()).place(level, context.chunkGenerator(), random, (BlockPos)pos) && FeatureUtils.safeSetBlock((WorldGenLevel)level, (BlockPos)pos, (BlockState)((InstantExplosionBlock)FunctionalBlocks.INSTANTANEOUS_EXPLOSION_TNT.get()).defaultBlockState(), ModFeatures.IS_REPLACEABLE)) {
                BlockPos.MutableBlockPos offset = new BlockPos.MutableBlockPos();
                for (int i = 0; i < config.tryTimes; ++i) {
                    offset.setWithOffset((Vec3i)pos, Mth.randomBetweenInclusive((RandomSource)random, (int)-7, (int)7), 0, Mth.randomBetweenInclusive((RandomSource)random, (int)-7, (int)7));
                    if (!FeatureUtils.isPosAir((WorldGenLevel)level, (BlockPos)offset) || !FeatureUtils.isPosSturdy((WorldGenLevel)level, (BlockPos)offset.offset(0, -1, 0), (Direction)Direction.UP)) continue;
                    level.setBlock((BlockPos)offset, ((DetonatorBlock)FunctionalBlocks.DETONATOR.get()).defaultBlockState(), 3);
                    INetworkEntity a = ModFeatures.getNetworkEntity(level, (BlockPos)pos);
                    INetworkEntity b = ModFeatures.getNetworkEntity(level, (BlockPos)offset);
                    if (a == null || b == null) continue;
                    a.connectTo(3786171, (BlockPos)offset, b);
                    return true;
                }
            }
        }
        return false;
    }

    public record Config(Holder<ConfiguredFeature<?, ?>> oreFeature, int maxSearchDown, int tryTimes) implements FeatureConfiguration
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ConfiguredFeature.CODEC.fieldOf("ore_feature").forGetter(Config::oreFeature), (App)ExtraCodecs.POSITIVE_INT.lenientOptionalFieldOf("max_search_down", (Object)32).forGetter(Config::maxSearchDown), (App)ExtraCodecs.POSITIVE_INT.lenientOptionalFieldOf("try_times", (Object)4).forGetter(Config::tryTimes)).apply((Applicative)instance, Config::new));
    }
}

