/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.worldgen.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Column;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import org.confluence.lib.util.FeatureUtils;
import org.confluence.mod.common.block.functional.FragilePressureBlock;
import org.confluence.mod.common.block.functional.MechanicalFragileBlock;
import org.confluence.mod.common.block.functional.network.INetworkEntity;
import org.confluence.mod.common.init.ModFeatures;
import org.confluence.mod.common.init.block.FunctionalBlocks;
import org.jetbrains.annotations.NotNull;

public class FallingSandTrapFeature
extends Feature<Config> {
    public FallingSandTrapFeature(Codec<Config> codec) {
        super(codec);
    }

    public boolean place(@NotNull FeaturePlaceContext<Config> context) {
        Column.Range range;
        Object t;
        BlockPos origin;
        Config config = (Config)context.config();
        WorldGenLevel level = context.level();
        if (!FeatureUtils.isPosAir((WorldGenLevel)level, (BlockPos)(origin = context.origin()))) {
            return false;
        }
        Optional optionalColumn = Column.scan((LevelSimulatedReader)level, (BlockPos)origin, (int)config.maxDistanceTo, BlockBehaviour.BlockStateBase::isAir, ModFeatures.IS_BASE_STONE);
        if (optionalColumn.isPresent() && (t = optionalColumn.get()) instanceof Column.Range && (range = (Column.Range)t).height() >= config.minDistanceTo) {
            Object fragileEntity1;
            int halfHeight = range.height() / 2;
            BlockPos supportPos = origin.atY(range.floor());
            if (!FeatureUtils.isPosSturdy((WorldGenLevel)level, (BlockPos)supportPos, (Direction)Direction.UP)) {
                return false;
            }
            int radius = config.radius;
            int ceiling = range.ceiling();
            int width = radius * 2 + 1;
            BlockState fragile = ((MechanicalFragileBlock)FunctionalBlocks.MECHANICAL_FRAGILE_SANDSTONE.get()).defaultBlockState();
            BlockPos.MutableBlockPos mutable = origin.mutable().setY(ceiling).move(-radius, 0, -radius);
            BlockPos supportingPos = mutable.immutable();
            level.setBlock(supportingPos, fragile, 3);
            INetworkEntity fragileEntity = ModFeatures.getNetworkEntity(level, supportingPos);
            if (fragileEntity == null) {
                return false;
            }
            BlockPos.MutableBlockPos mutable1 = mutable.immutable().mutable();
            for (int z = 1; z < width; ++z) {
                level.setBlock((BlockPos)mutable1.move(0, 0, 1), fragile, 3);
                fragileEntity1 = ModFeatures.getNetworkEntity(level, (BlockPos)mutable1);
                if (fragileEntity1 != null) {
                    fragileEntity1.connectTo(0xFFFF00, supportingPos, fragileEntity);
                }
                FallingSandTrapFeature.fillAir(level, (BlockPos)mutable1, halfHeight);
            }
            for (int x = 1; x < width; ++x) {
                level.setBlock((BlockPos)mutable.move(1, 0, 0), fragile, 3);
                fragileEntity1 = ModFeatures.getNetworkEntity(level, (BlockPos)mutable);
                if (fragileEntity1 != null) {
                    fragileEntity1.connectTo(0xFFFF00, supportingPos, fragileEntity);
                }
                mutable1 = mutable.immutable().mutable();
                for (int z = 1; z < width; ++z) {
                    level.setBlock((BlockPos)mutable1.move(0, 0, 1), fragile, 3);
                    fragileEntity1 = ModFeatures.getNetworkEntity(level, (BlockPos)mutable1);
                    if (fragileEntity1 != null) {
                        fragileEntity1.connectTo(0xFFFF00, supportingPos, fragileEntity);
                    }
                    FallingSandTrapFeature.fillAir(level, (BlockPos)mutable1, halfHeight);
                }
            }
            BlockState sand = Blocks.SAND.defaultBlockState();
            for (BlockPos pos : BlockPos.betweenClosed((BlockPos)origin.atY(0).offset(-radius, ceiling + 1, -radius), (BlockPos)origin.atY(0).offset(radius, ceiling + config.height, radius))) {
                FeatureUtils.safeSetBlock((WorldGenLevel)level, (BlockPos)pos, (BlockState)sand, ModFeatures.IS_REPLACEABLE);
            }
            boolean isDeepslate = level.isStateAtPosition(supportPos, blockState -> blockState.is(Blocks.DEEPSLATE));
            BlockState pressureBlock = ((FragilePressureBlock)(isDeepslate ? FunctionalBlocks.DEEPSLATE_PRESSURE_BLOCK : FunctionalBlocks.STONE_PRESSURE_BLOCK).get()).defaultBlockState();
            level.setBlock(supportPos, pressureBlock, 3);
            INetworkEntity plateEntity = ModFeatures.getNetworkEntity(level, supportPos);
            if (plateEntity != null) {
                fragileEntity.connectTo(0xFFFF00, supportPos, plateEntity);
                return true;
            }
        }
        return false;
    }

    private static void fillAir(WorldGenLevel level, BlockPos pos, int height) {
        for (int i = 1; i < height; ++i) {
            level.setBlock(pos.below(i), Blocks.AIR.defaultBlockState(), 3);
        }
    }

    public record Config(BlockStateProvider fallingBlock, int radius, int height, int minDistanceTo, int maxDistanceTo) implements FeatureConfiguration
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockStateProvider.CODEC.lenientOptionalFieldOf("falling_block", (Object)BlockStateProvider.simple((Block)Blocks.SAND)).forGetter(Config::fallingBlock), (App)ExtraCodecs.POSITIVE_INT.lenientOptionalFieldOf("radius", (Object)4).forGetter(Config::radius), (App)ExtraCodecs.POSITIVE_INT.lenientOptionalFieldOf("height", (Object)4).forGetter(Config::height), (App)ExtraCodecs.POSITIVE_INT.lenientOptionalFieldOf("min_distance_to", (Object)4).forGetter(Config::minDistanceTo), (App)ExtraCodecs.POSITIVE_INT.lenientOptionalFieldOf("max_distance_to", (Object)16).forGetter(Config::maxDistanceTo)).apply((Applicative)instance, Config::new));
    }
}

