/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.worldgen.feature;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.neoforged.neoforge.common.Tags;
import org.confluence.lib.util.FeatureUtils;
import org.confluence.mod.common.init.block.OreBlocks;

public class GemstoneCaveFeature
extends Feature<Config> {
    private final Supplier<BlockState[]> stonedGems = Suppliers.memoize(() -> new BlockState[]{((Block)OreBlocks.RUBY_ORE.get()).defaultBlockState(), ((Block)OreBlocks.TOPAZ_ORE.get()).defaultBlockState(), ((Block)OreBlocks.SAPPHIRE_ORE.get()).defaultBlockState(), ((Block)OreBlocks.JADE_ORE.get()).defaultBlockState(), ((Block)OreBlocks.AMETHYST_ORE.get()).defaultBlockState(), Blocks.DIAMOND_ORE.defaultBlockState()});
    private final Supplier<BlockState[]> deepslatedGems = Suppliers.memoize(() -> new BlockState[]{((Block)OreBlocks.DEEPSLATE_RUBY_ORE.get()).defaultBlockState(), ((Block)OreBlocks.DEEPSLATE_TOPAZ_ORE.get()).defaultBlockState(), ((Block)OreBlocks.DEEPSLATE_SAPPHIRE_ORE.get()).defaultBlockState(), ((Block)OreBlocks.DEEPSLATE_JADE_ORE.get()).defaultBlockState(), ((Block)OreBlocks.DEEPSLATE_AMETHYST_ORE.get()).defaultBlockState(), Blocks.DEEPSLATE_DIAMOND_ORE.defaultBlockState()});

    public GemstoneCaveFeature(Codec<Config> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<Config> context) {
        int index0;
        Config config = (Config)context.config();
        RandomSource random = context.random();
        WorldGenLevel level = context.level();
        BlockPos blockPos = context.origin();
        float radius = (float)config.radius + 0.5f;
        BlockState stone = Blocks.STONE.defaultBlockState();
        BlockState deepslate = Blocks.DEEPSLATE.defaultBlockState();
        BlockState air = Blocks.AIR.defaultBlockState();
        int t = index0 = random.nextInt(6);
        while (t == index0) {
            t = random.nextInt(6);
        }
        int index1 = t;
        float rotation = (float)Math.PI * 2 * random.nextFloat();
        int x = Mth.floor((float)(Mth.sin((float)rotation) * radius));
        int z = Mth.floor((float)(Mth.cos((float)rotation) * radius));
        FeatureUtils.ball((double)(radius + 2.0f), (BlockPos)blockPos, state -> this.determineGems((BlockState)state, index0), (boolean)true, (WorldGenLevel)level);
        FeatureUtils.ball((double)(radius + 2.0f), (BlockPos)blockPos, state -> this.determineGems((BlockState)state, index1), (boolean)true, (WorldGenLevel)level, (float)0.5f, (RandomSource)random);
        FeatureUtils.ball((double)(radius + 2.0f), (BlockPos)blockPos, state -> GemstoneCaveFeature.isDeepslate(state) ? deepslate : stone, (boolean)true, (WorldGenLevel)level, (float)0.7f, (RandomSource)random);
        FeatureUtils.ball((double)radius, (BlockPos)blockPos, (BlockState)air, (boolean)true, (WorldGenLevel)level);
        FeatureUtils.ellipsoid((double)(radius - 1.0f), (double)(radius + 1.0f), (double)(radius - 1.0f), (BlockPos)blockPos.offset(x, 0, z), (BlockState)air, (boolean)true, (WorldGenLevel)level);
        return true;
    }

    private static boolean isDeepslate(BlockState state) {
        return state.is(Blocks.DEEPSLATE) || state.is(Tags.Blocks.ORES_IN_GROUND_DEEPSLATE);
    }

    private BlockState determineGems(BlockState state, int index) {
        if (GemstoneCaveFeature.isDeepslate(state)) {
            return this.deepslatedGems.get()[index];
        }
        return this.stonedGems.get()[index];
    }

    public record Config(int radius) implements FeatureConfiguration
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("radius").forGetter(Config::radius)).apply((Applicative)instance, Config::new));
    }
}

