/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.worldgen.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import org.confluence.lib.util.FeatureUtils;

public class MushroomTreeFeature
extends Feature<Config> {
    public MushroomTreeFeature(Codec<Config> pCodec) {
        super(pCodec);
    }

    public boolean place(FeaturePlaceContext<Config> pContext) {
        boolean placed;
        RandomSource random = pContext.random();
        Config config = (Config)pContext.config();
        WorldGenLevel level = pContext.level();
        BlockPos baseBlockPos = pContext.origin();
        BlockState stemBlockState = config.stem().getState(random, baseBlockPos);
        BlockState pileusBlockState = config.pileus().getState(random, baseBlockPos);
        BlockState indusiumBlockState = config.indusium().getState(random, baseBlockPos);
        int height = config.height + random.nextInt(config.height_more + 1) - 1;
        int width = random.nextInt(1, 3);
        boolean check0 = FeatureUtils.rectangularCheck((BlockPos)baseBlockPos, (BlockPos)baseBlockPos.offset(0, height, 0), (WorldGenLevel)level);
        boolean check1 = FeatureUtils.rectangularCheck((BlockPos)baseBlockPos.offset(width, height + 1, width), (BlockPos)baseBlockPos.offset(-width, height + 2, -width), (WorldGenLevel)level);
        boolean check2 = FeatureUtils.rectangularCheck((BlockPos)baseBlockPos.offset(width - 1, height + 3, width), (BlockPos)baseBlockPos.offset(1 - width, height + 3, -width), (WorldGenLevel)level);
        boolean check3 = FeatureUtils.rectangularCheck((BlockPos)baseBlockPos.offset(width, height + 3, width - 1), (BlockPos)baseBlockPos.offset(-width, height + 3, 1 - width), (WorldGenLevel)level);
        boolean bl = placed = check0 && check1 && check2 && check3;
        if (placed) {
            FeatureUtils.rectangular((BlockPos)baseBlockPos, (BlockPos)baseBlockPos.offset(0, height, 0), (BlockState)stemBlockState, (WorldGenLevel)level, (boolean)true);
            FeatureUtils.rectangular((BlockPos)baseBlockPos.offset(width, height + 1, width), (BlockPos)baseBlockPos.offset(-width, height + 2, -width), (BlockState)pileusBlockState, (WorldGenLevel)level, (boolean)true);
            FeatureUtils.rectangular((BlockPos)baseBlockPos.offset(width - 1, height + 3, width), (BlockPos)baseBlockPos.offset(1 - width, height + 3, -width), (BlockState)pileusBlockState, (WorldGenLevel)level, (boolean)true);
            FeatureUtils.rectangular((BlockPos)baseBlockPos.offset(width, height + 3, width - 1), (BlockPos)baseBlockPos.offset(-width, height + 3, 1 - width), (BlockState)pileusBlockState, (WorldGenLevel)level, (boolean)true);
            for (int x = -width; x <= width; ++x) {
                for (int y = 0; y < 3; ++y) {
                    for (int z = -width; z <= width; ++z) {
                        BlockPos checkPos = baseBlockPos.offset(x, height + 1 + y, z);
                        if (!level.getBlockState(checkPos).is(pileusBlockState.getBlock())) continue;
                        if (level.getBlockState(checkPos.offset(0, 1, 0)).is(pileusBlockState.getBlock())) {
                            level.setBlock(checkPos, (BlockState)level.getBlockState(checkPos).trySetValue((Property)PipeBlock.UP, (Comparable)Boolean.valueOf(true)), 3);
                        }
                        if (level.getBlockState(checkPos.offset(0, -1, 0)).is(pileusBlockState.getBlock())) {
                            level.setBlock(checkPos, (BlockState)level.getBlockState(checkPos).trySetValue((Property)PipeBlock.DOWN, (Comparable)Boolean.valueOf(true)), 3);
                        }
                        if (level.getBlockState(checkPos.offset(1, 0, 0)).is(pileusBlockState.getBlock())) {
                            level.setBlock(checkPos, (BlockState)level.getBlockState(checkPos).trySetValue((Property)PipeBlock.EAST, (Comparable)Boolean.valueOf(true)), 3);
                        }
                        if (level.getBlockState(checkPos.offset(-1, 0, 0)).is(pileusBlockState.getBlock())) {
                            level.setBlock(checkPos, (BlockState)level.getBlockState(checkPos).trySetValue((Property)PipeBlock.WEST, (Comparable)Boolean.valueOf(true)), 3);
                        }
                        if (level.getBlockState(checkPos.offset(0, 0, 1)).is(pileusBlockState.getBlock())) {
                            level.setBlock(checkPos, (BlockState)level.getBlockState(checkPos).trySetValue((Property)PipeBlock.SOUTH, (Comparable)Boolean.valueOf(true)), 3);
                        }
                        if (!level.getBlockState(checkPos.offset(0, 0, -1)).is(pileusBlockState.getBlock())) continue;
                        level.setBlock(checkPos, (BlockState)level.getBlockState(checkPos).trySetValue((Property)PipeBlock.NORTH, (Comparable)Boolean.valueOf(true)), 3);
                    }
                }
            }
            if (level.getBlockState(baseBlockPos.offset(1, height, 0)).canBeReplaced()) {
                level.setBlock(baseBlockPos.offset(1, height, 0), (BlockState)indusiumBlockState.trySetValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST), 3);
            }
            if (level.getBlockState(baseBlockPos.offset(-1, height, 0)).canBeReplaced()) {
                level.setBlock(baseBlockPos.offset(-1, height, 0), (BlockState)indusiumBlockState.trySetValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST), 3);
            }
            if (level.getBlockState(baseBlockPos.offset(0, height, 1)).canBeReplaced()) {
                level.setBlock(baseBlockPos.offset(0, height, 1), (BlockState)indusiumBlockState.trySetValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH), 3);
            }
            if (level.getBlockState(baseBlockPos.offset(0, height, -1)).canBeReplaced()) {
                level.setBlock(baseBlockPos.offset(0, height, -1), (BlockState)indusiumBlockState.trySetValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH), 3);
            }
            return true;
        }
        return false;
    }

    public record Config(BlockStateProvider stem, BlockStateProvider pileus, BlockStateProvider indusium, int height, int height_more) implements FeatureConfiguration
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockStateProvider.CODEC.fieldOf("stem_block").forGetter(Config::stem), (App)BlockStateProvider.CODEC.fieldOf("pileus_block").forGetter(Config::pileus), (App)BlockStateProvider.CODEC.fieldOf("indusium_block").forGetter(Config::indusium), (App)Codec.INT.fieldOf("height").forGetter(Config::height), (App)Codec.INT.fieldOf("height_more").forGetter(Config::height)).apply((Applicative)instance, Config::new));
    }
}

