/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.worldgen.secret_seed;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.Shapes;
import org.confluence.mod.common.entity.projectile.boulder.BoulderEntity;
import org.confluence.mod.common.init.ModSecretSeeds;
import org.confluence.mod.common.init.item.ModItems;
import org.confluence.mod.common.item.sponsor.BoredomsPactFallingResolve;
import org.confluence.mod.common.worldgen.secret_seed.SecretSeed;
import org.confluence.terra_curio.util.CuriosUtils;
import top.theillusivec4.curios.api.CuriosApi;

public class BoulderWorld
extends SecretSeed {
    public BoulderWorld(long flag, ResourceLocation id) {
        super(flag, id);
    }

    @Override
    public boolean match(String seed) {
        return "redigit".equals(seed);
    }

    public static void createBoulderWhenBlockDestroy(ServerPlayer serverPlayer, BlockState blockState, BlockPos pos) {
        if (ModSecretSeeds.BOULDER_WORLD.match(serverPlayer.server) && serverPlayer.level().random.nextFloat() <= 0.01f && blockState.getCollisionShape((BlockGetter)serverPlayer.level(), pos) == Shapes.block()) {
            BoulderEntity entity = new BoulderEntity((Level)serverPlayer.serverLevel(), pos.getCenter(), blockState);
            entity.targetTo((Player)serverPlayer);
            entity.setVertical(false);
            serverPlayer.serverLevel().addFreshEntity((Entity)entity);
        }
    }

    public static void forceSetAccessory(ServerPlayer player) {
        ItemStack stack;
        if (ModSecretSeeds.BOULDER_WORLD.match(player.server) && ((stack = CuriosUtils.getSlot((LivingEntity)player, (String)"accessory", (int)0)) == null || !stack.is((Item)ModItems.BOREDOMS_PACT_FALLING_RESOLVE.get()))) {
            Optional optional = CuriosApi.getCuriosInventory((LivingEntity)player);
            optional.ifPresent(iCuriosItemHandler -> {
                ItemStack itemStack = ((BoredomsPactFallingResolve)((Object)((Object)ModItems.BOREDOMS_PACT_FALLING_RESOLVE.get()))).getDefaultInstance();
                itemStack.enchant(player.server.registryAccess().holderOrThrow(Enchantments.BINDING_CURSE), 1);
                iCuriosItemHandler.setEquippedCurio("accessory", 0, itemStack);
            });
        }
    }
}

