/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.worldgen.structure;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import org.confluence.lib.util.StructureUtils;
import org.confluence.lib.util.VectorUtils;
import org.joml.Vector3d;

public class BaseStructures {
    public static BlockPos livingTree(BlockPos centerPos, Object2IntMap<BlockPos> blockMap, WorldgenRandom random, int treeTrunkHeight, int treeTrunkEndOffset, double treeTrunkStartRadius, double treeTrunkEndRadius, int treeTrunkBlocks, int treeBranchLength, int treeBranchLengthRandomAddition, int treeBranchEndOffset, int treeBranchStartRadius, int treeBranchStartRadiusRandomAddition, int treeBranchEndRadius, int treeBranchBlocks, int treeBranchCount, int treeBranchCountRandomAddition, int treeRootLength, int treeRootLengthRandomAddition, int treeRootEndOffset, int treeRootStartRadius, int treeRootStartRadiusRandomAddition, int treeRootEndRadius, int treeRootBlocks, int treeRootCount, int treeRootCountRandomAddition, boolean isGenerateTreeRoot, int largeTreeRootLength, int largeTreeRootEndOffset, double largeTreeRootStartRadius, double largeTreeRootEndRadius, int largeTreeRootBlocks, boolean isGenerateLargeTreeRoot, double branchLeafGenerationRadiusXZ, double branchLeafGenerationRadiusY, double trunkLeafGenerationRadiusXZ, double trunkLeafGenerationRadiusY, double leafBlobGenerationRadiusXZ, double leafBlobGenerationRadiusY, float leafPosDensity, float leafDensity, int leafBlocks, int rootEndBlocks) {
        ArrayList<Vector3d> locationList = new ArrayList<Vector3d>();
        Vector3d locationStart = new Vector3d();
        Vector3d locationEnd = new Vector3d();
        locationStart.x = centerPos.getX();
        locationStart.y = centerPos.getY();
        locationStart.z = centerPos.getZ();
        locationEnd.x = centerPos.getX() + random.nextInt(-treeTrunkEndOffset, treeTrunkEndOffset + 1);
        locationEnd.y = centerPos.getY() + treeTrunkHeight;
        locationEnd.z = centerPos.getZ() + random.nextInt(-treeTrunkEndOffset, treeTrunkEndOffset + 1);
        locationList.add(locationStart);
        locationList.add(locationEnd);
        List leavesTop = VectorUtils.ellipsoidPos((double)trunkLeafGenerationRadiusXZ, (double)trunkLeafGenerationRadiusY, (double)trunkLeafGenerationRadiusXZ, (BlockPos)VectorUtils.fromVector3d((Vector3d)locationEnd), (float)leafPosDensity, (WorldgenRandom)random);
        StructureUtils.lineSetEllipsoid((List)leavesTop, (double)leafBlobGenerationRadiusXZ, (double)leafBlobGenerationRadiusY, (double)leafBlobGenerationRadiusXZ, (int)leafBlocks, (boolean)true, blockMap, (float)leafDensity, (WorldgenRandom)random);
        VectorUtils.lightningPathList(locationList, (double)1.0, (int)8, (RandomSource)random);
        StructureUtils.lineSet(locationList, (double)treeTrunkStartRadius, (double)treeTrunkEndRadius, (int)treeTrunkBlocks, (boolean)true, blockMap);
        BaseStructures.stick(random, locationList, blockMap, true, treeBranchLength, treeBranchLengthRandomAddition, treeBranchEndOffset, treeBranchStartRadius, treeBranchStartRadiusRandomAddition, treeBranchEndRadius, treeBranchBlocks, treeBranchCount, treeBranchCountRandomAddition, branchLeafGenerationRadiusXZ, branchLeafGenerationRadiusY, leafBlobGenerationRadiusXZ, leafBlobGenerationRadiusY, leafPosDensity, leafDensity, leafBlocks, rootEndBlocks);
        if (isGenerateTreeRoot) {
            BaseStructures.stick(random, locationList, blockMap, false, treeRootLength, treeRootLengthRandomAddition, treeRootEndOffset, treeRootStartRadius, treeRootStartRadiusRandomAddition, treeRootEndRadius, treeRootBlocks, treeRootCount, treeRootCountRandomAddition, branchLeafGenerationRadiusXZ, branchLeafGenerationRadiusY, leafBlobGenerationRadiusXZ, leafBlobGenerationRadiusY, leafPosDensity, leafDensity, leafBlocks, rootEndBlocks);
        }
        if (isGenerateLargeTreeRoot) {
            locationList.clear();
            locationEnd.x = centerPos.getX() + random.nextInt(-largeTreeRootEndOffset, largeTreeRootEndOffset + 1);
            locationEnd.y = centerPos.getY() - largeTreeRootLength;
            locationEnd.z = centerPos.getZ() + random.nextInt(-largeTreeRootEndOffset, largeTreeRootEndOffset + 1);
            locationList.add(locationStart);
            locationList.add(locationEnd);
            VectorUtils.lightningPathList(locationList, (double)1.0, (int)12, (RandomSource)random);
            StructureUtils.lineSet(locationList, (double)largeTreeRootStartRadius, (double)largeTreeRootEndRadius, (int)largeTreeRootBlocks, (boolean)true, blockMap);
            StructureUtils.ball((double)4.9, (BlockPos)centerPos, (int)0, (boolean)true, blockMap);
            StructureUtils.lineSet(locationList, (double)(largeTreeRootStartRadius * 2.0 / 5.0), (double)(largeTreeRootEndRadius - 0.1), (int)0, (boolean)true, blockMap);
        }
        return VectorUtils.fromVector3d((Vector3d)((Vector3d)locationList.get(locationList.size() / 2 + random.nextInt(-locationList.size() / 4, locationList.size() / 4 + 1))));
    }

    private static void stick(WorldgenRandom random, List<Vector3d> locationList, Object2IntMap<BlockPos> blockMap, boolean branch, int len, int lenRandom, int offset, int startRadius, int startRadiusRandomAddition, int endRadius, int blocks, int count, int countRandomAddition, double branchLeafGenerationRadiusXZ, double branchLeafGenerationRadiusY, double leafBlobGenerationRadiusXZ, double leafBlobGenerationRadiusY, float leafPosDensity, float leafDensity, int leafBlocks, int endBlocks) {
        List leavesTop = new ArrayList();
        int stickCount = count + random.nextInt(countRandomAddition);
        for (int stickPlace = 0; stickPlace < stickCount; ++stickPlace) {
            double anCs = 360.0 / (double)stickCount;
            double everyA = anCs * (double)stickPlace / 180.0 * Math.PI;
            double everyB = ((double)random.nextInt(110) - 20.0) * Math.pow((double)random.nextInt(101) / 100.0, 3.0) / 180.0 * Math.PI;
            int length = len + random.nextInt(lenRandom);
            double endX = (double)length * Math.cos(everyA) * Math.cos(everyB);
            double endY = (double)length * Math.sin(everyB);
            double endZ = (double)length * Math.sin(everyA) * Math.cos(everyB);
            Vector3d stickStart = locationList.get(branch ? Math.max(locationList.size() - locationList.size() / 11 * 7 - random.nextInt(locationList.size() / 9), 0) : random.nextInt(locationList.size() / 9));
            Vector3d stickEnd = new Vector3d();
            stickEnd.x = branch ? locationList.getLast().x + endX : locationList.getFirst().x + endX / 2.0;
            stickEnd.y = branch ? locationList.getLast().y + endY + (double)offset : locationList.getFirst().y - endY + (double)offset;
            stickEnd.z = branch ? locationList.getLast().z + endZ : locationList.getFirst().z + endZ / 2.0;
            ArrayList<Vector3d> stickList = new ArrayList<Vector3d>();
            stickList.add(stickStart);
            stickList.add(stickEnd);
            VectorUtils.lightningPathList(stickList, (double)1.0, (int)8, (RandomSource)random);
            StructureUtils.lineSet(stickList, (double)(startRadius + random.nextInt(startRadiusRandomAddition)), (double)endRadius, (int)blocks, (boolean)true, blockMap);
            if (branch) {
                leavesTop.clear();
                leavesTop = VectorUtils.ellipsoidPos((double)branchLeafGenerationRadiusXZ, (double)branchLeafGenerationRadiusY, (double)branchLeafGenerationRadiusXZ, (BlockPos)VectorUtils.fromVector3d((Vector3d)stickEnd), (float)leafPosDensity, (WorldgenRandom)random);
                StructureUtils.lineSetEllipsoid(leavesTop, (double)leafBlobGenerationRadiusXZ, (double)leafBlobGenerationRadiusY, (double)leafBlobGenerationRadiusXZ, (int)leafBlocks, (boolean)false, blockMap, (float)leafDensity, (WorldgenRandom)random);
                continue;
            }
            Vector3d rootEnd = (Vector3d)stickList.getLast();
            StructureUtils.ball((double)endRadius, (BlockPos)VectorUtils.fromVector3d((Vector3d)rootEnd), (int)endBlocks, (boolean)true, blockMap);
        }
    }
}

